/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.todo;

import java.awt.AlphaComposite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.makagiga.MainWindow;
import org.makagiga.Tabs;
import org.makagiga.chart.ChartModel;
import org.makagiga.chart.ChartPainter;
import org.makagiga.commons.Config;
import org.makagiga.commons.MDataTransfer;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MProperties;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.UI;
import org.makagiga.commons.preview.AbstractPreview;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.commons.swing.Input;
import org.makagiga.desktop.Widget;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.todo.TodoEditor;
import org.makagiga.editors.todo.TodoEditorCore;
import org.makagiga.fs.MetaInfo;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.todo.Priority;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskModel;
import org.makagiga.todo.TaskSelection;
import org.makagiga.tree.Tree;

public final class TodoEditorPlugin
extends EditorPlugin {
    public TodoEditorPlugin() {
        this.setEncryption(EditorPlugin.Encryption.MEMORY);
    }

    @Override
    public void importData(Object object, DataFlavor dataFlavor, Map<DataFlavor, Object> map, File file) throws Exception {
        List list = (List)MDataTransfer.getData(object, dataFlavor);
        if (list == null) {
            throw new IOException();
        }
        TaskModel taskModel = new TaskModel();
        taskModel.setEventsEnabled(false);
        for (Task task : list) {
            taskModel.addRow(task);
        }
        taskModel.saveToXML(file);
    }

    @Override
    public boolean isDataFlavorSupported(Object object, DataFlavor dataFlavor, Map<DataFlavor, Object> map) {
        return dataFlavor.equals(TaskSelection.TASK_FLAVOR);
    }

    @Override
    public Editor<?> create() {
        return new TodoEditor();
    }

    public static void newTask(MetaInfo metaInfo, MDate mDate) {
        TodoEditorCore todoEditorCore = TodoEditorPlugin.getTodoEditor(metaInfo);
        if (todoEditorCore == null) {
            return;
        }
        String string = Input.getText(UI.windowFor(todoEditorCore), "", UI._("Summary"), UI._("Add a New Task for This Day"), "ui/newfile", "newtask");
        if (string != null) {
            todoEditorCore.addTask(string, Priority.DEFAULT, 0, mDate.getTime(), MDate.currentTime(), 0L, true);
        }
    }

    @Override
    public void onInit(Config config, PluginInfo pluginInfo) throws PluginException {
        super.onInit(config, pluginInfo);
        this.setFileTypes(new EditorPlugin.FileType("mgtodo"));
        this.setImportTypes(new EditorPlugin.FileType("mgtodo", this.getName(), "application/x-makagiga-todo"));
        this.setExportTypes(new EditorPlugin.FileType("mgtodo", this.getName()), new EditorPlugin.FileType("html", "HTML"), new EditorPlugin.FileType("ods", UI._("OpenDocument Spreadsheet")), new EditorPlugin.FileType("opml", "OPML"), new EditorPlugin.FileType("xhtml", "XHTML"), new EditorPlugin.FileType("ics", "iCalendar Tasks"), new EditorPlugin.FileType("csv", "Comma Separated Values (CSV)"), new EditorPlugin.FileType("txt", UI._("Plain Text")), new EditorPlugin.FileType("xml", "XML"), new EditorPlugin.FileType("vcs", "vCalendar Tasks"));
        DefaultPreview.getInstance().addHandler("mgtodo", new AbstractPreview(false){

            @Override
            public Image getImage(File file, int n, MProperties mProperties) throws Exception {
                TaskModel taskModel = new TaskModel();
                taskModel.loadFromXML(file, false);
                StringBuilder stringBuilder = new StringBuilder();
                if (taskModel.isEmpty()) {
                    stringBuilder.append('<').append(UI._("Empty")).append('>');
                } else {
                    for (Object object : taskModel) {
                        if (((Task)object).getSummary().isEmpty()) continue;
                        stringBuilder.append(((Task)object).isDone() ? "[X] " : "[ ] ").append(((Task)object).getSummary()).append('\n');
                    }
                }
                if (stringBuilder.length() > 0) {
                    BufferedImage bufferedImage = DefaultPreview.getTextImage(stringBuilder.toString(), n);
                    if (!taskModel.isEmpty()) {
                        Object object;
                        object = bufferedImage.createGraphics();
                        ((Graphics2D)object).setComposite(AlphaComposite.SrcOver.derive(0.2f));
                        ChartModel chartModel = taskModel.createChartModel();
                        ChartPainter<ChartModel> chartPainter = new ChartPainter<ChartModel>(chartModel);
                        chartPainter.chartSize.set((int)((float)n / 1.2f));
                        chartPainter.shadowVisible.no();
                        chartPainter.textVisible.no();
                        chartPainter.paint((Graphics2D)object, n, n, null, null);
                        ((Graphics)object).dispose();
                    }
                    return bufferedImage;
                }
                return null;
            }
        });
    }

    @Override
    public void onPostInit() throws PluginException {
        super.onPostInit();
    }

    public static void showTask(MetaInfo metaInfo, Task task) {
        if (metaInfo.getFS() == null) {
            Object var2_2 = metaInfo.getProperty("metaInfo.owner", null);
            if (var2_2 instanceof Widget) {
                Widget widget = var2_2;
                widget.putClientProperty(task.getClass().getName(), task);
                MainWindow.showWidget(widget, false);
            }
        } else {
            TodoEditorCore todoEditorCore = TodoEditorPlugin.getTodoEditor(metaInfo);
            if (todoEditorCore != null) {
                todoEditorCore.selectTask(task);
            }
        }
    }

    private static TodoEditorCore getTodoEditor(MetaInfo metaInfo) {
        Tabs tabs;
        Editor<?> editor;
        if (!metaInfo.getFile().exists()) {
            MStatusBar.warning(UI._("File does not exist: {0}", metaInfo));
            return null;
        }
        if (Tree.getInstance().open(metaInfo) && (editor = (tabs = Tabs.getInstance()).getTabAt(metaInfo)) instanceof TodoEditor) {
            tabs.setSelectedComponent(editor);
            return (TodoEditorCore)editor.getCore();
        }
        return null;
    }
}

