/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.todo;

import java.awt.Color;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Locale;
import javax.swing.event.TableModelEvent;
import org.makagiga.commons.ColorProperty;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.Flags;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MV;
import org.makagiga.commons.Searchable;
import org.makagiga.commons.TK;
import org.makagiga.commons.category.Category;
import org.makagiga.commons.category.CategoryList;
import org.makagiga.commons.category.CategoryListRenderer;
import org.makagiga.commons.category.CategoryManager;
import org.makagiga.editors.EditorSearch;
import org.makagiga.editors.todo.TodoEditor;
import org.makagiga.feeds.opml.OPMLWriter;
import org.makagiga.opendocument.Content;
import org.makagiga.opendocument.DocumentWriter;
import org.makagiga.pim.calendar.VCalendar;
import org.makagiga.todo.Column;
import org.makagiga.todo.Priority;
import org.makagiga.todo.Task;
import org.makagiga.todo.TaskList;
import org.makagiga.todo.TaskModel;
import org.makagiga.todo.TaskState;
import org.makagiga.todo.TaskTable;
import org.makagiga.tree.tracker.Tracker;

public final class TodoEditorCore
extends TaskTable
implements Config.GlobalEntry {
    private final WeakReference<TodoEditor> editorRef;

    public TodoEditorCore(TodoEditor todoEditor) {
        this.editorRef = new WeakReference<TodoEditor>(todoEditor);
    }

    @Override
    public String getGlobalEntry(String string) {
        return this.getEditor().getGlobalEntry(string);
    }

    public String getKeywords() {
        if (this.isEmpty(MV.MODEL)) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (Task task : this.getTaskList()) {
            String string = task.getSummary();
            if (string.isEmpty()) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String getSelectedSummary() {
        try {
            return ((TaskModel)this.getModel()).getValueAt(this.convertRowIndexToModel(this.getSelectedRow()), Column.SUMMARY.ordinal()).toString();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    @Override
    public Color getSelectionBackground() {
        TodoEditor todoEditor = this.getEditor();
        return todoEditor != null && todoEditor.isExportMode() ? this.getBackground() : super.getSelectionBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void saveToFileAsCSV(OutputStream outputStream) throws Exception {
        FS.TextWriter textWriter = null;
        try {
            textWriter = FS.getUTF8Writer(outputStream);
            StringBuilder stringBuilder = new StringBuilder();
            for (Column column : Column.values()) {
                if (column == Column.DONE || column == Column.CIRCLE) continue;
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.escapeCSV((Object)column));
            }
            textWriter.println(stringBuilder.toString());
            int n = ((TaskModel)this.getModel()).getRowCount();
            for (int i = 0; i < n; ++i) {
                stringBuilder.setLength(0);
                for (Column column : Column.values()) {
                    void var4_10;
                    if (column == Column.DONE || column == Column.CIRCLE) continue;
                    Object object = ((TaskModel)this.getModel()).getValueAt(i, column.ordinal());
                    if (column == Column.COMPLETE) {
                        String string = Task.formatComplete((Integer)object);
                    } else if (column.getColumnClass() == MDate.class) {
                        MDate mDate = (MDate)object;
                        if (mDate.isValid()) {
                            String string = mDate.format("yyyy-MM-dd HH:mm:ss", Locale.ENGLISH);
                        } else {
                            String string = "";
                        }
                    }
                    stringBuilder.append(this.escapeCSV(var4_10)).append(column == Column.CATEGORY ? (char)'\n' : ',');
                }
                textWriter.print(stringBuilder.toString());
            }
        }
        finally {
            FS.close(textWriter);
        }
    }

    public void saveToFileAsHTML(OutputStream outputStream, boolean bl, boolean bl2) throws Exception {
        CategoryManager categoryManager = CategoryManager.getSharedInstance();
        ArrayList<Column> arrayList = new ArrayList<Column>(Column.values().length);
        int n = this.columnModel.getColumnCount();
        for (int i = 0; i < n; ++i) {
            Column object;
            int n2 = this.convertColumnIndexToModel(i);
            if (n2 == -1 || (object = Column.values()[n2]) == Column.CIRCLE) continue;
            arrayList.add(object);
        }
        HTMLBuilder hTMLBuilder = new HTMLBuilder(bl ? (bl2 ? "<!DOCTYPE html>" : "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">") : "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        hTMLBuilder.beginHTML(this.getEditor().getMetaInfo().toString(), "UTF-8");
        hTMLBuilder.addMeta("Generator", MApplication.getTitle());
        hTMLBuilder.beginStyle();
        hTMLBuilder.beginRule(bl ? "body, html" : "body");
        hTMLBuilder.addAttr("background-color", Color.WHITE);
        hTMLBuilder.addAttr("color", Color.BLACK);
        hTMLBuilder.addAttr("font-family", "sans-serif");
        hTMLBuilder.addAttr("margin", "0px");
        hTMLBuilder.addAttr("padding", "0px");
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("table");
        if (this.isGridVisible()) {
            hTMLBuilder.addAttr("border", "1px solid black");
        } else {
            hTMLBuilder.addAttr("border", "0px solid black");
        }
        hTMLBuilder.addAttr("border-collapse", "collapse");
        hTMLBuilder.addAttr("border-spacing", "0px");
        hTMLBuilder.addAttr("width", "100%");
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("td");
        if (this.isGridVisible()) {
            hTMLBuilder.addAttr("border", "1px solid black");
        } else {
            hTMLBuilder.addAttr("border", "0px solid black");
        }
        hTMLBuilder.addAttr("font-size", this.getFont().getSize() + "px");
        hTMLBuilder.addAttr("padding", "2px");
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("td.c_category span");
        hTMLBuilder.addAttr("border-style", "solid");
        hTMLBuilder.addAttr("border-width", "1px");
        hTMLBuilder.addAttr("padding", "0px 2px 0px 2px");
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("td.c_complete");
        hTMLBuilder.addAttr("text-align", Column.COMPLETE.getHTMLAlign());
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("td.c_done");
        hTMLBuilder.addAttr("font-family", "monospace");
        hTMLBuilder.addAttr("text-align", Column.DONE.getHTMLAlign());
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("td.c_priority");
        hTMLBuilder.addAttr("text-align", Column.PRIORITY.getHTMLAlign());
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("td.done");
        hTMLBuilder.addAttr("text-decoration", "line-through");
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("thead td");
        hTMLBuilder.addAttr("font-weight", "bold");
        hTMLBuilder.addAttr("text-align", "center");
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("tr.odd");
        hTMLBuilder.addAttr("background-color", MColor.getDarker(Color.WHITE));
        hTMLBuilder.endRule();
        hTMLBuilder.endStyle();
        hTMLBuilder.beginDoc();
        hTMLBuilder.beginTag("table");
        hTMLBuilder.beginTag("thead");
        hTMLBuilder.beginTag("tr");
        for (Column column : arrayList) {
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(column.toString()), "style", "text-align: " + column.getHTMLAlign());
        }
        hTMLBuilder.endTag("tr");
        hTMLBuilder.endTag("thead");
        hTMLBuilder.beginTag("tbody");
        for (Integer n2 : this.rowIterator(MV.VIEW)) {
            Task task = this.getTaskAt(this.convertRowIndexToModel(n2));
            if (n2 % 2 != 0) {
                hTMLBuilder.beginTag("tr", "class", "odd");
            } else {
                hTMLBuilder.beginTag("tr");
            }
            for (Column column : arrayList) {
                switch (column) {
                    case DONE: {
                        this.writeItemDone(hTMLBuilder, task);
                        break;
                    }
                    case SUMMARY: {
                        this.writeItemSummary(hTMLBuilder, task);
                        break;
                    }
                    case PRIORITY: {
                        this.writeItemPriority(hTMLBuilder, task, n2);
                        break;
                    }
                    case COMPLETE: {
                        this.writeItemComplete(hTMLBuilder, task, false);
                        break;
                    }
                    case DATE_TIME: {
                        this.writeItemDateTime(hTMLBuilder, task, n2, false);
                        break;
                    }
                    case START_DATE_TIME: {
                        this.writeItemDateTime(hTMLBuilder, task.getStartDateTime(), false);
                        break;
                    }
                    case COMPLETE_DATE_TIME: {
                        this.writeItemDateTime(hTMLBuilder, task.getCompleteDateTime(), false);
                        break;
                    }
                    case CATEGORY: {
                        hTMLBuilder.beginTag("td", "class", "c_category");
                        CategoryList categoryList = new CategoryList(categoryManager, task.getCategory());
                        for (Category category : categoryList) {
                            Color color = category.getColor();
                            if (color == null) {
                                color = Category.DEFAULT_COLOR;
                            }
                            Color color2 = CategoryListRenderer.getBorderColor(category, color);
                            String string = "background-color: " + ColorProperty.toString(color) + "; " + "border-color: " + ColorProperty.toString(color2) + "; " + "color: black";
                            hTMLBuilder.doubleTag("span", HTMLBuilder.escape(category.getName()), "style", string);
                        }
                        hTMLBuilder.endTag("td");
                        break;
                    }
                }
            }
            hTMLBuilder.endTag("tr");
        }
        hTMLBuilder.endTag("tbody");
        hTMLBuilder.endTag("table");
        hTMLBuilder.endDoc();
        hTMLBuilder.save(outputStream);
    }

    public void saveToFileAsODS(OutputStream outputStream) throws Exception {
        DocumentWriter.write(this.getEditor().getMetaInfo().toString(), this.getModel(), new Content.TableModelFilter(){

            @Override
            public Object formatValue(int n, int n2, Object object) {
                if (object instanceof MDate) {
                    return Task.formatDate((MDate)object, TaskState.UNKNOWN);
                }
                if (object instanceof Integer && n2 == Column.COMPLETE.ordinal()) {
                    return Task.formatComplete((Integer)Integer.class.cast(object));
                }
                return super.formatValue(n, n2, object);
            }

            @Override
            public boolean includeColumn(int n) {
                return n != Column.DONE.ordinal();
            }
        }, outputStream);
    }

    public void saveToFileAsOPML(OutputStream outputStream) throws Exception {
        String string = this.getEditor().getMetaInfo().toString();
        OPMLWriter oPMLWriter = new OPMLWriter();
        oPMLWriter.beginOPML();
        oPMLWriter.emptyHead(string);
        oPMLWriter.beginBody();
        oPMLWriter.beginOutline(string, new Object[0]);
        for (Task task : this.getTaskList()) {
            oPMLWriter.addOutline(task.getSummary(), new Object[0]);
        }
        oPMLWriter.endOutline();
        oPMLWriter.endBody();
        oPMLWriter.endOPML();
        oPMLWriter.save(outputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveToFileAsText(OutputStream outputStream) throws Exception {
        FS.TextWriter textWriter = null;
        try {
            textWriter = FS.getUTF8Writer(outputStream);
            int n = TaskList.findMaxSummaryLength(this.getTaskList());
            for (Task task : this.getTaskList()) {
                textWriter.write(task.toString(n));
            }
            if (textWriter.checkError()) {
                throw new IOException();
            }
        }
        finally {
            FS.close(textWriter);
        }
    }

    public void saveToFileAsVcs(OutputStream outputStream) throws Exception {
        this.saveToFileAsXCalendar(outputStream, new VCalendar());
    }

    public EditorSearch.SearchResult searchFor(String string, int n, Flags flags) {
        int n2;
        int n3 = this.getRowCount();
        if (n3 == 0) {
            return EditorSearch.SearchResult.NOT_FOUND;
        }
        if (n > n3 - 1) {
            return EditorSearch.SearchResult.WRAP_AROUND;
        }
        EnumSet<Searchable.Matches> enumSet = flags.isSet(1L) ? EnumSet.of(Searchable.Matches.CASE_SENSITIVE) : Task.DEFAULT_SEARCH_OPTIONS;
        String string2 = enumSet.contains((Object)Searchable.Matches.CASE_SENSITIVE) ? string : string.toUpperCase();
        int n4 = this.getRowCount();
        for (n2 = 0; n2 < n4; ++n2) {
            if (n2 < n || !this.searchAtRow(n2, string2, enumSet)) continue;
            this.selectRow(n2);
            return EditorSearch.SearchResult.FOUND;
        }
        n2 = this.getSelectedRow();
        int n5 = n2 = n2 == -1 ? 0 : n2;
        if (this.searchAtRow(n2, string2, enumSet)) {
            return EditorSearch.SearchResult.WRAP_AROUND;
        }
        return EditorSearch.SearchResult.NOT_FOUND;
    }

    @Override
    protected void onChange(TableModelEvent tableModelEvent) {
        TodoEditor todoEditor = this.getEditor();
        if (todoEditor != null && ((TaskModel)this.getModel()).getEventsEnabled()) {
            todoEditor.setModified(true);
            todoEditor.syncLater();
            Tracker.notifyTaskChange(todoEditor.getMetaInfo(), this, tableModelEvent);
            todoEditor.getEditorDesigner().updateComponentsLater(this);
        }
    }

    @Override
    protected void updateStatusText() {
        this.getEditor().updateStatusText();
    }

    private String escapeCSV(Object object) {
        String string;
        String string2 = string = object == null ? "" : object.toString();
        if (string.isEmpty()) {
            return string;
        }
        string = string.replace("\"", "\"\"");
        return "\"" + string + "\"";
    }

    private String formatHTMLTime(MDate mDate, boolean bl) {
        String string = TK.escapeXML(Task.formatDate(mDate, TaskState.UNKNOWN));
        if (bl) {
            return "<time datetime=\"" + mDate.formatRFC3339() + "\">" + string + "</time>";
        }
        return string;
    }

    private TodoEditor getEditor() {
        return this.editorRef == null ? null : (TodoEditor)this.editorRef.get();
    }

    private boolean searchAtRow(int n, String string, EnumSet<Searchable.Matches> enumSet) {
        Task task = this.getTaskAt(this.convertRowIndexToModel(n));
        return task.matches(string, enumSet);
    }

    private void writeItemComplete(HTMLBuilder hTMLBuilder, Task task, boolean bl) {
        String string = HTMLBuilder.escape(task.formatComplete());
        hTMLBuilder.doubleTag("td", string, "class", "c_complete");
    }

    private void writeItemDateTime(HTMLBuilder hTMLBuilder, MDate mDate, boolean bl) {
        hTMLBuilder.doubleTag("td", this.formatHTMLTime(mDate, bl), new Object[0]);
    }

    private void writeItemDateTime(HTMLBuilder hTMLBuilder, Task task, int n, boolean bl) {
        TaskState taskState = task.getDateTimeState();
        Color color = taskState.getColor();
        if (color == null) {
            hTMLBuilder.doubleTag("td", this.formatHTMLTime(task.getDateTime(), bl), new Object[0]);
        } else {
            color = MRenderer.getRowColor(n, color);
            hTMLBuilder.doubleTag("td", this.formatHTMLTime(task.getDateTime(), bl), "style", "background-color: " + ColorProperty.toString(color));
        }
    }

    private void writeItemDone(HTMLBuilder hTMLBuilder, Task task) {
        hTMLBuilder.doubleTag("td", HTMLBuilder.escape("[" + (task.isDone() ? "X" : " ") + "]"), "class", "c_done");
    }

    private void writeItemPriority(HTMLBuilder hTMLBuilder, Task task, int n) {
        Priority priority = task.getPriority();
        Color color = priority.getColor();
        if (color == null) {
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(priority.toString()), "class", "c_priority");
        } else {
            color = MRenderer.getRowColor(n, color);
            hTMLBuilder.doubleTag("td", HTMLBuilder.escape(priority.toString()), "class", "c_priority", "style", "background-color: " + ColorProperty.toString(color));
        }
    }

    private void writeItemSummary(HTMLBuilder hTMLBuilder, Task task) {
        String string = HTMLBuilder.escape(task.getSummary());
        if (task.isDone()) {
            hTMLBuilder.doubleTag("td", string, "class", "done");
        } else {
            hTMLBuilder.doubleTag("td", string, new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveToFileAsXCalendar(OutputStream outputStream, VCalendar vCalendar) throws Exception {
        try {
            for (Task task : this.getTaskList()) {
                vCalendar.add(task.toVCalendarTodo(vCalendar));
            }
            vCalendar.write(outputStream);
        }
        finally {
            FS.close(vCalendar);
        }
    }
}

