/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.notepad;

import java.awt.Color;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.HTMLBuilder;
import org.makagiga.commons.Linkify;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MText;
import org.makagiga.commons.MTextArea;
import org.makagiga.editors.notepad.NotepadEditor;
import org.makagiga.fs.MetaInfo;
import org.makagiga.opendocument.DocumentWriter;
import org.makagiga.tree.formats.Incollector;

public final class NotepadEditorCore
extends MTextArea {
    WeakReference<NotepadEditor> editorRef;

    public NotepadEditorCore() {
        this.setWordWrap(true);
    }

    public void saveToFileAsHTML(OutputStream outputStream, String string) throws Exception {
        HTMLBuilder hTMLBuilder = new HTMLBuilder("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">");
        hTMLBuilder.beginHTML(string, "UTF-8");
        hTMLBuilder.addMeta("Generator", MApplication.getTitle());
        hTMLBuilder.beginStyle();
        hTMLBuilder.beginRule("body");
        hTMLBuilder.addAttr("background-color", Color.WHITE);
        hTMLBuilder.addAttr("color", Color.BLACK);
        hTMLBuilder.endRule();
        hTMLBuilder.beginRule("pre");
        hTMLBuilder.addAttr("font-family", "sans-serif");
        hTMLBuilder.endRule();
        hTMLBuilder.endStyle();
        hTMLBuilder.beginDoc();
        hTMLBuilder.setIndentLevel(0);
        hTMLBuilder.beginTag("pre");
        hTMLBuilder.setIndentLevel(0);
        Linkify linkify = Linkify.getInstance();
        String string2 = linkify.apply(HTMLBuilder.escape(this.getText()));
        hTMLBuilder.appendLine(string2);
        hTMLBuilder.endTag("pre");
        hTMLBuilder.endDoc();
        hTMLBuilder.save(outputStream);
    }

    public void saveToFileAsINR(OutputStream outputStream, MetaInfo metaInfo) throws Exception {
        Incollector incollector = new Incollector();
        Incollector.Entry entry = new Incollector.Entry();
        entry.setMetaInfo(metaInfo);
        entry.setNote(new Incollector.Note(metaInfo.toString(), this.getText()));
        incollector.addEntry(entry);
        incollector.export(outputStream);
    }

    public void saveToFileAsODT(OutputStream outputStream) throws Exception {
        DocumentWriter.write(this.getText(), outputStream);
    }

    public void saveToFileAsText(OutputStream outputStream) throws Exception {
        MText.save((JTextComponent)this, outputStream);
    }

    @Override
    public void setModified(boolean bl, Object object) {
        super.setModified(bl, object);
        NotepadEditor notepadEditor = (NotepadEditor)this.editorRef.get();
        notepadEditor.setModified(bl);
        if (bl) {
            notepadEditor.syncLater();
        }
        notepadEditor.getEditorDesigner().updateLater();
    }
}

