/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.notepad;

import java.awt.Component;
import java.awt.Font;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.makagiga.Sidebar;
import org.makagiga.Tabs;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Config;
import org.makagiga.commons.MFontChooser;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MText;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.UI;
import org.makagiga.editors.AbstractTextEditor;
import org.makagiga.editors.Actions;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorConfig;
import org.makagiga.editors.EditorDesigner;
import org.makagiga.editors.EditorExport;
import org.makagiga.editors.EditorIO;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.editors.EditorZoom;
import org.makagiga.editors.notepad.NotepadEditorCore;
import org.makagiga.editors.notepad.NotepadEditorDesigner;
import org.makagiga.editors.notepad.spi.HTMLPreviewProvider;
import org.makagiga.tools.EditorQuickFind;

public final class NotepadEditor
extends AbstractTextEditor<NotepadEditorCore>
implements EditorConfig,
EditorDesigner<NotepadEditorDesigner>,
EditorExport,
EditorIO {
    private NotepadEditorDesigner designer;

    public NotepadEditor() {
        super(new NotepadEditorCore());
        ((NotepadEditorCore)this.core).editorRef = new WeakReference<NotepadEditor>(this);
        this.designer = new NotepadEditorDesigner(this);
    }

    @Override
    public void onClose() {
        super.onClose();
        if (this.designer != null) {
            this.designer.dispose(new Object[0]);
            this.designer = null;
        }
    }

    @Override
    public void loadConfig(Config config) {
        Config config2 = Config.getDefault();
        Font font = config2.readFont(Config.getPlatformKey(this.getGlobalEntry("core")), null);
        if (font != null) {
            this.fontSize = font.getSize();
            ((NotepadEditorCore)this.core).setFont(font);
        }
        this.restorePosition(config);
    }

    @Override
    public void saveConfig(Config config) {
        Config config2 = Config.getDefault();
        this.writeFontSize(config2);
        this.writePosition(config);
    }

    @Override
    public NotepadEditorDesigner getEditorDesigner() {
        return this.designer;
    }

    @Override
    public void updateEditorDesigner() {
    }

    @Override
    public void exportFile(EditorPlugin.FileType fileType, OutputStream outputStream) throws Exception {
        if (fileType.is("html")) {
            ((NotepadEditorCore)this.core).saveToFileAsHTML(outputStream, this.getMetaInfo().toString());
        } else if (fileType.is("ied")) {
            ((NotepadEditorCore)this.core).saveToFileAsINR(outputStream, this.getMetaInfo());
        } else if (fileType.is("odt")) {
            ((NotepadEditorCore)this.core).saveToFileAsODT(outputStream);
        } else if (fileType.is("txt")) {
            ((NotepadEditorCore)this.core).saveToFileAsText(outputStream);
        } else {
            this.exportNotSupported(fileType);
        }
    }

    @Override
    public void loadFile(InputStream inputStream, boolean bl) throws Exception {
        MText.load((JTextComponent)this.core, inputStream);
        ((NotepadEditorCore)this.core).getDocument().putProperty("tabSize", 4);
        EditorQuickFind.autoSearch();
    }

    @Override
    public void saveFile(OutputStream outputStream) throws Exception {
        ((NotepadEditorCore)this.core).saveToFileAsText(outputStream);
        this.updateIndex(((NotepadEditorCore)this.core).getText());
    }

    @Override
    @Deprecated
    public JComponent getZoomComponent() {
        return super.getZoomComponent();
    }

    @Override
    @Deprecated
    public boolean isZoomEnabled(EditorZoom.ZoomType zoomType) {
        return super.isZoomEnabled(zoomType);
    }

    @Override
    @Deprecated
    public void zoom(EditorZoom.ZoomType zoomType) {
        super.zoom(zoomType);
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        super.updateMenu(string, mMenu);
        if (string.equals("VIEW_MENU_EDITOR")) {
            mMenu.addSeparator();
            this.getSharedActionGroup().updateMenu(mMenu);
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        super.updateToolBar(string, mToolBar);
        if (string.equals("EDITOR_TOOL_BAR")) {
            mToolBar.addSeparator();
            this.getSharedActionGroup().updateToolBar(mToolBar);
        }
    }

    @Override
    protected ActionGroup createSharedActionGroup() {
        ActionGroup actionGroup = new ActionGroup();
        actionGroup.add("font", new FontAction()).setVisibleInToolBar(false);
        actionGroup.add("html-preview", new HTMLPreviewAction()).setVisibleInToolBar(false);
        return actionGroup;
    }

    @Override
    protected void writeFontSize(Config config) {
        Font font = ((NotepadEditorCore)this.core).getFont();
        if (font != null) {
            config.write(Config.getPlatformKey(this.getGlobalEntry("core")), font);
        }
    }

    private static final class HTMLPreviewAction
    extends Actions.Base<NotepadEditor> {
        @Override
        public void onAction(NotepadEditor notepadEditor) {
            Sidebar.getInstance().goTo(Sidebar.Tab.DESIGNER, false);
            notepadEditor.designer.selectHTMLPreview();
        }

        private HTMLPreviewAction() {
            super(UI._("HTML Preview"));
            this.setAcceleratorKey(HTMLPreviewProvider.ACTION_KEY_STROKE);
            this.setEnabled(true);
        }
    }

    private static final class FontAction
    extends Actions.Base<NotepadEditor> {
        @Override
        public void onAction(NotepadEditor notepadEditor) {
            Font font = MFontChooser.getFont(this.getSourceWindow(), ((NotepadEditorCore)notepadEditor.core).getFont());
            if (font == null) {
                return;
            }
            Config config = Config.getDefault();
            notepadEditor.writeFontSize(config);
            config.sync();
            for (Editor editor : Tabs.getInstance()) {
                if (!(editor instanceof NotepadEditor)) continue;
                ((Component)editor.getCore()).setFont(font);
            }
        }

        private FontAction() {
            super(UI._("Select a Font..."), "ui/font");
            this.setEnabled(true);
        }
    }
}

