/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image.tools;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.BufferedImage;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import org.makagiga.commons.Lockable;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.TK;
import org.makagiga.editors.image.ImageEditor;
import org.makagiga.editors.image.ImageEditorCore;
import org.makagiga.editors.image.tools.BrushTool;
import org.makagiga.editors.image.tools.ToolPanel;

public class Tool
implements Lockable,
MIcon.Name,
MouseListener,
MouseMotionListener,
MouseWheelListener {
    private boolean locked;
    private boolean update;
    private boolean updateOnMouseRelease;
    private boolean useBrushTool = true;
    private Cursor cursor = Cursor.getPredefinedCursor(0);
    private Icon icon;
    private KeyStroke keyStroke;
    private Set<String> visibleID;
    private String id;
    private String name;
    private ToolPanel toolPanel;
    protected ImageEditor editor;
    protected ImageEditorCore core;

    public Tool(String string, String string2) {
        this(string, MIcon.get(Tool.class, string2 + ".png", MIcon.getSmallSize()), string2);
    }

    public Tool(String string, Icon icon, String string2) {
        this.name = string;
        this.icon = icon;
        this.id = TK.validateID(string2);
        ToolPanel toolPanel = this.createToolPanel();
        if (toolPanel != null) {
            this.setToolPanel(toolPanel);
        }
    }

    public void activate() {
    }

    public Point convertPoint(int n, int n2) {
        double d = ImageEditorCore.getScale();
        return new Point((int)((double)n / d), (int)((double)n2 / d));
    }

    public Point convertPoint(MouseEvent mouseEvent) {
        return this.convertPoint(mouseEvent.getX(), mouseEvent.getY());
    }

    public Point convertPoint(Point point) {
        return this.convertPoint(point.x, point.y);
    }

    public void draw(Graphics2D graphics2D, int n, int n2) {
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public String getID() {
        return this.id;
    }

    public KeyStroke getKeyStroke() {
        return this.keyStroke;
    }

    public void setKeyStroke(KeyStroke keyStroke) {
        this.keyStroke = keyStroke;
    }

    public void setKeyStroke(int n) {
        this.setKeyStroke(n, 0);
    }

    public void setKeyStroke(int n, int n2) {
        this.keyStroke = KeyStroke.getKeyStroke(n, n2);
    }

    public String getName() {
        return this.name;
    }

    public ToolPanel getToolPanel() {
        return this.toolPanel;
    }

    public void setToolPanel(ToolPanel toolPanel) {
        this.toolPanel = toolPanel;
    }

    public boolean getUpdateOnMouseRelease() {
        return this.updateOnMouseRelease;
    }

    public void setUpdateOnMouseRelease(boolean bl) {
        this.updateOnMouseRelease = bl;
    }

    public boolean getUseBrushTool() {
        return this.useBrushTool;
    }

    public void setUseBrushTool(boolean bl) {
        this.useBrushTool = bl;
    }

    public boolean isPanelVisible(String string) {
        return this.visibleID == null || this.visibleID.contains(string);
    }

    public void setVisiblePanel(String string, boolean bl) {
        if (bl) {
            if (this.visibleID == null) {
                this.visibleID = new HashSet<String>();
            }
            this.visibleID.add(string);
        } else if (this.visibleID != null) {
            this.visibleID.remove(string);
        }
    }

    public boolean isUpdate() {
        return this.update;
    }

    public void setContext(ImageEditor imageEditor, ImageEditorCore imageEditorCore) {
        this.editor = imageEditor;
        this.core = imageEditorCore;
    }

    @Override
    public boolean isLocked() {
        return this.locked;
    }

    @Override
    public void setLocked(boolean bl) {
        this.locked = bl;
    }

    @Override
    public String getIconName() {
        return MIcon.getName(this.icon);
    }

    @Override
    public void setIconName(String string) {
        this.icon = MIcon.small(string);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.updateOnMouseRelease) {
            this.core.beforeModification();
            Graphics2D graphics2D = this.core.getCanvas().createGraphics();
            this.update(graphics2D);
            graphics2D.dispose();
            this.core.afterModification();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
    }

    protected ToolPanel createToolPanel() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void update(Graphics2D graphics2D) {
        BufferedImage bufferedImage = this.core.getCanvas();
        try {
            this.update = true;
            if (this.useBrushTool) {
                BrushTool.getInstance().setup(graphics2D);
            }
            this.draw(graphics2D, bufferedImage.getWidth(), bufferedImage.getHeight());
        }
        finally {
            this.update = false;
        }
    }
}

