/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image.tools;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.UI;
import org.makagiga.editors.image.tools.AbstractRectangleTool;
import org.makagiga.editors.image.tools.BrushTool;
import org.makagiga.editors.image.tools.ToolPanel;

public class RectangleTool
extends AbstractRectangleTool {
    private boolean drawing;

    public RectangleTool() {
        this(null);
        this.setKeyStroke(82, 64);
    }

    @Deprecated
    public RectangleTool(BrushTool brushTool) {
        super(UI._("Rectangle"), "rectangle");
        this.setUpdateOnMouseRelease(true);
        this.setVisiblePanel("brush-color", true);
        this.setVisiblePanel("brush-properties", true);
        this.setVisiblePanel("rectangle", true);
    }

    @Override
    public void draw(Graphics2D graphics2D, int n, int n2) {
        if (!this.drawing) {
            return;
        }
        BrushTool brushTool = BrushTool.getInstance();
        ToolPanel toolPanel = this.getToolPanel();
        if (toolPanel != null && ((Panel)Panel.class.cast(toolPanel)).fill.isSelected()) {
            if (brushTool.getType() == BrushTool.Type.CIRCLE) {
                int n3 = brushTool.getSize();
                graphics2D.fillRoundRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height, n3, n3);
            } else {
                graphics2D.fillRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
            }
        } else {
            graphics2D.drawRect(this.bounds.x, this.bounds.y, this.bounds.width, this.bounds.height);
        }
    }

    @Deprecated
    public BrushTool getBrushTool() {
        return BrushTool.getInstance();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        super.mouseDragged(mouseEvent);
        this.drawing = true;
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.drawing) {
            super.mouseReleased(mouseEvent);
            this.drawing = false;
        }
    }

    @Deprecated
    protected RectangleTool(String string, Icon icon, String string2, BrushTool brushTool) {
        super(string, icon, string2);
        this.setUpdateOnMouseRelease(true);
    }

    @Override
    protected ToolPanel createToolPanel() {
        return new Panel(this);
    }

    private static final class Panel
    extends ToolPanel {
        private final MCheckBox fill = new MCheckBox(UI._("Filled"));

        private Panel(RectangleTool rectangleTool) {
            super(rectangleTool);
            this.setComponent(this.fill);
        }
    }
}

