/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image;

import java.awt.Dimension;
import java.awt.Image;
import javax.swing.AbstractButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.Config;
import org.makagiga.commons.Item;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MCheckBox;
import org.makagiga.commons.MComboBox;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MNumberSpinner;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.UI;
import org.makagiga.editors.image.ImageEditor;

public final class ResizeDialog
extends MDialog {
    private boolean inUpdate = true;
    private Image image;
    private MCheckBox highQuality;
    private MCheckBox keepAspectRatio;
    private MNumberSpinner<Integer> newHeight;
    private MNumberSpinner<Integer> newWidth;

    @Deprecated
    public ResizeDialog(Image image, double d) {
        this(null, image, d);
    }

    private ResizeDialog(ImageEditor imageEditor, Image image, double d) {
        super(imageEditor.getWindowAncestor(), UI._("Scale Image"), "ui/scale", 15);
        this.image = image;
        this.changeButton((AbstractButton)this.getOKButton(), UI._("Scale Image"));
        this.changeButton((AbstractButton)this.getUserButton(), MActionInfo.RESTORE_DEFAULT_VALUES);
        this.getOKButton().setEnabled(false);
        Config config = Config.getDefault();
        MPanel mPanel = MPanel.createVBoxPanel();
        MPanel mPanel2 = MPanel.createGridPanel(3, 3, 5, 5);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        int n3 = 16384;
        this.newWidth = new MNumberSpinner();
        this.newWidth.setRange((Comparable<Integer>)1, (Comparable<Integer>)n3);
        this.newWidth.setNumber(n);
        this.newWidth.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ResizeDialog.this.updateWidthAspectRatio();
            }
        });
        mPanel2.add(MLabel.createFor(this.newWidth, UI._("New Width:"), 11));
        mPanel2.add(this.newWidth);
        mPanel2.add(this.createOriginalLabel(n));
        this.newHeight = new MNumberSpinner();
        this.newHeight.setRange((Comparable<Integer>)1, (Comparable<Integer>)n3);
        this.newHeight.setNumber(n2);
        this.newHeight.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ResizeDialog.this.updateHeightAspectRatio();
            }
        });
        mPanel2.add(MLabel.createFor(this.newHeight, UI._("New Height:"), 11));
        mPanel2.add(this.newHeight);
        mPanel2.add(this.createOriginalLabel(n2));
        mPanel.add(mPanel2);
        this.keepAspectRatio = new MCheckBox(UI._("Keep aspect ratio")){

            @Override
            protected void onClick() {
                ResizeDialog.this.updateWidthAspectRatio();
            }
        };
        this.keepAspectRatio.setSelected(config.read("Resize.keepAspectRatio", true));
        mPanel2.add(new MLabel());
        mPanel2.add(this.keepAspectRatio);
        mPanel.addGap();
        MComboBox<Template> mComboBox = new MComboBox<Template>(){

            @Override
            protected void onSelect() {
                if (ResizeDialog.this.inUpdate) {
                    return;
                }
                ResizeDialog.this.inUpdate = true;
                Template template = (Template)this.getSelectedItem();
                ResizeDialog.this.newWidth.setNumber(((Dimension)template.getValue()).width);
                ResizeDialog.this.newHeight.setNumber(((Dimension)template.getValue()).height);
                ResizeDialog.this.inUpdate = false;
                ResizeDialog.this.updateWidthAspectRatio();
            }
        };
        mComboBox.addItem(new Template(n, n2, UI._("original")));
        Dimension dimension = config.readDimension("Resize", 0, 0);
        if (dimension.width > 0 && dimension.height > 0) {
            mComboBox.addItem(new Template(dimension.width, dimension.height, UI._("recent")));
        }
        mComboBox.addItem(new Template(1024, 768));
        mComboBox.addItem(new Template(800, 600));
        mComboBox.addItem(new Template(640, 480, "e-mail"));
        mComboBox.addItem(new Template(320, 240));
        mComboBox.addItem(new Template(96, 96, "avatar"));
        mComboBox.addItem(new Template(80, 80, "avatar"));
        mComboBox.addItem(new Template(48, 48, "buddy icon"));
        mComboBox.addItem(new Template(16, 16, "favicon"));
        if (d != 1.0) {
            mComboBox.addItem(new Template((int)((double)n * d), (int)((double)n2 * d), UI._("current zoom")));
        }
        mComboBox.setMaximumRowCount(-1);
        mPanel.add(MPanel.createHLabelPanel(mComboBox, UI._("Templates:")));
        mPanel.addGap();
        this.highQuality = new MCheckBox(UI._("High quality"));
        this.highQuality.setSelected(config.read("Resize.highQuality", true));
        mPanel.add(this.highQuality);
        this.addCenter(mPanel);
        this.inUpdate = false;
        this.updateComponents();
        this.packFixed();
    }

    @Deprecated
    public Image getImage() {
        Config config = Config.getDefault();
        config.write("Resize.highQuality", this.highQuality.isSelected());
        config.write("Resize.keepAspectRatio", this.keepAspectRatio.isSelected());
        int n = this.newWidth.getNumber();
        int n2 = this.newHeight.getNumber();
        config.write("Resize.width", n);
        config.write("Resize.height", n2);
        config.sync();
        return UI.scaleImage(this.image, n, n2, this.highQuality.isSelected() ? UI.Quality.HIGH : UI.Quality.LOW);
    }

    public static Image show(ImageEditor imageEditor, Image image, double d) {
        ResizeDialog resizeDialog = new ResizeDialog(imageEditor, image, d);
        Image image2 = resizeDialog.exec() ? resizeDialog.getImage() : null;
        resizeDialog.freeImage();
        return image2;
    }

    @Deprecated
    protected void freeImage() {
        this.image = null;
        this.highQuality = null;
        this.keepAspectRatio = null;
        this.newHeight = null;
        this.newWidth = null;
    }

    @Override
    protected void onUserClick() {
        this.newWidth.setNumber(this.image.getWidth(null));
        this.newHeight.setNumber(this.image.getHeight(null));
    }

    private MLabel createOriginalLabel(int n) {
        String string = Integer.toString(n);
        MLabel mLabel = new MLabel(UI._("Original: {0}", string));
        mLabel.setStyle("font-size: smaller");
        return mLabel;
    }

    private void updateComponents() {
        boolean bl = this.newWidth.getNumber().intValue() != this.image.getWidth(null) || this.newHeight.getNumber().intValue() != this.image.getHeight(null);
        this.getOKButton().setEnabled(bl);
        this.getUserButton().setEnabled(bl);
    }

    private void updateHeightAspectRatio() {
        if (this.inUpdate) {
            return;
        }
        this.inUpdate = true;
        if (this.keepAspectRatio.isSelected()) {
            float f = (float)this.image.getHeight(null) / (float)this.newHeight.getNumber().intValue();
            this.newWidth.setNumber((int)((float)this.image.getWidth(null) / f));
        }
        this.updateComponents();
        this.inUpdate = false;
    }

    private void updateWidthAspectRatio() {
        if (this.inUpdate) {
            return;
        }
        this.inUpdate = true;
        if (this.keepAspectRatio.isSelected()) {
            float f = (float)this.image.getWidth(null) / (float)this.newWidth.getNumber().intValue();
            this.newHeight.setNumber((int)((float)this.image.getHeight(null) / f));
        }
        this.updateComponents();
        this.inUpdate = false;
    }

    private static final class Template
    extends Item<Dimension> {
        @Override
        public String toString() {
            if (this.text != null) {
                return String.format("%d x %d (%s)", ((Dimension)this.value).width, ((Dimension)this.value).height, this.text);
            }
            return String.format("%d x %d", ((Dimension)this.value).width, ((Dimension)this.value).height);
        }

        private Template(int n, int n2) {
            this(n, n2, (String)null);
        }

        private Template(int n, int n2, String string) {
            super(new Dimension(n, n2));
            this.text = string;
        }
    }
}

