/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors.image;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import javax.swing.BorderFactory;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.UI;

final class ImagePreviewPanel
extends MPanel
implements MDisposable {
    private BufferedImage originalPreviewImage;
    private final ImageLabel originalLabel;
    private final ImageLabel previewLabel = new ImageLabel(UI._("Preview"));

    public ImagePreviewPanel() {
        super(2, 1, 10, 10);
        this.add(this.previewLabel);
        this.originalLabel = new ImageLabel(UI._("Original"));
        this.add(this.originalLabel);
    }

    public BufferedImage getOriginalPreviewImage() {
        return this.originalPreviewImage;
    }

    public void setFilter(BufferedImageOp bufferedImageOp) {
        this.setPreviewImage(bufferedImageOp.filter(this.originalPreviewImage, null));
    }

    public void setOriginalImage(BufferedImage bufferedImage, int n, int n2, boolean bl) {
        this.originalPreviewImage = bl ? (BufferedImage)UI.scaleImage(bufferedImage, n, n2, UI.Quality.MEDIUM) : bufferedImage.getSubimage(0, 0, Math.min(bufferedImage.getWidth(), n), Math.min(bufferedImage.getHeight(), n2));
        this.originalLabel.setImage(this.originalPreviewImage);
        this.previewLabel.setImage(this.originalPreviewImage);
    }

    public void setPreviewImage(BufferedImage bufferedImage) {
        this.previewLabel.setImage(bufferedImage);
    }

    @Override
    public Object dispose(Object ... objectArray) {
        this.originalPreviewImage = null;
        this.originalLabel.setImage(null);
        this.previewLabel.setImage(null);
        return null;
    }

    private static final class ImageLabel
    extends MLabel {
        private ImageLabel(String string) {
            this.setBackground(Color.WHITE);
            this.setBorder(BorderFactory.createTitledBorder(string));
            this.setOpaque(true);
            this.setToolTipText(string);
            this.setVerticalAlignment(1);
        }
    }
}

