/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.net.URL;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.text.JTextComponent;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MWebBrowserPanel;
import org.makagiga.commons.WebBrowser;
import org.makagiga.commons.print.PrintInfo;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorPrint;
import org.makagiga.editors.EditorSearch;
import org.makagiga.editors.EditorZoom;
import org.makagiga.editors.TextUtils;
import org.makagiga.plugins.PluginMenu;

public class WebBrowserEditor
extends Editor<JComponent>
implements EditorPrint,
EditorSearch,
EditorZoom,
Focusable,
PluginMenu {
    protected WebBrowser browser;

    public WebBrowserEditor() {
        this(MWebBrowserPanel.createDefaultWebBrowser());
    }

    public WebBrowserEditor(WebBrowser webBrowser) {
        this.browser = webBrowser;
        JComponent jComponent = (JComponent)webBrowser.getProperty("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY");
        this.setCore(jComponent);
        JComponent jComponent2 = (JComponent)webBrowser.getProperty("org.makagiga.commons.WebBrowser.CONTAINER_PROPERTY");
        this.addWebBrowserContainer(jComponent2);
    }

    @Override
    public void focus() {
        ((JComponent)this.core).requestFocusInWindow();
    }

    @Override
    public MessageFormat getPrintFooter(boolean bl) {
        if (bl) {
            URL uRL = (URL)this.browser.getProperty("org.makagiga.commons.WebBrowser.URL_PROPERTY");
            return uRL == null ? null : new MessageFormat(uRL.toString());
        }
        return null;
    }

    @Override
    public String getPrintTitle() {
        String string = (String)this.browser.getProperty("org.makagiga.commons.WebBrowser.TITLE_PROPERTY");
        return string == null ? super.getPrintTitle() : string;
    }

    @Override
    public boolean getSupportsToolBarUnderTabs() {
        return true;
    }

    public WebBrowser getWebBrowser() {
        return this.browser;
    }

    public boolean isPrintActionVisible() {
        Object t = this.browser.getProperty("org.makagiga.commons.WebBrowser.SHOW_PRINT_ACTION_PROPERTY");
        if (t == null) {
            return true;
        }
        return Boolean.TRUE.equals(t);
    }

    @Override
    public void onClose() {
        if (this.browser instanceof MDisposable) {
            ((MDisposable)MDisposable.class.cast(this.browser)).dispose(new Object[0]);
        }
        if (this.browser != null) {
            Object t = this.browser.getProperty("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY");
            if (t instanceof JTextComponent) {
                TextUtils.uninstallSearchHighlighter((JTextComponent)t);
            }
            this.browser = null;
        }
    }

    @Override
    public void setPrinting(boolean bl) {
        super.setPrinting(bl);
        this.browser.setProperty("org.makagiga.commons.WebBrowser.SYNCHRONOUS_IMAGE_LOADING_PROPERTY", bl);
    }

    @Override
    public Printable getPrintable(Flags flags, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        return this.browser.getPrintable(messageFormat, messageFormat2, 0);
    }

    @Override
    public PrintInfo.PrintResult printDocument(Flags flags, MessageFormat messageFormat, MessageFormat messageFormat2) throws PrinterException {
        return this.browser.printDocument(messageFormat, messageFormat2, flags == null ? 0 : flags.intValue()) ? PrintInfo.PrintResult.COMPLETE : PrintInfo.PrintResult.CANCELLED;
    }

    @Override
    public EditorSearch.SearchResult findText(String string, Flags flags) {
        Object t = this.browser.getProperty("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY");
        return t instanceof JTextComponent ? TextUtils.findText((JTextComponent)t, string, flags) : EditorSearch.SearchResult.NOT_FOUND;
    }

    @Override
    public EditorSearch.SearchResult findNextText(String string, Flags flags) {
        Object t = this.browser.getProperty("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY");
        return t instanceof JTextComponent ? TextUtils.findNextText((JTextComponent)t, string, flags) : EditorSearch.SearchResult.NOT_FOUND;
    }

    @Override
    public String getDefaultSearchText() {
        return (String)this.browser.getProperty("org.makagiga.commons.WebBrowser.SELECTED_TEXT_PROPERTY");
    }

    @Override
    public int getSupportedSearchOptions() {
        Object t = this.browser.getProperty("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY");
        return t instanceof JTextComponent ? 1 : 2;
    }

    @Override
    public JComponent getZoomComponent() {
        return null;
    }

    @Override
    public boolean isZoomEnabled(EditorZoom.ZoomType zoomType) {
        Object t = this.browser.getProperty("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY");
        return t instanceof JTextComponent ? TextUtils.canZoom((JTextComponent)t, zoomType) : false;
    }

    @Override
    public void zoom(EditorZoom.ZoomType zoomType) {
        Object t = this.browser.getProperty("org.makagiga.commons.WebBrowser.RENDERER_PROPERTY");
        if (t instanceof JTextComponent) {
            TextUtils.zoom((JTextComponent)t, zoomType);
        }
    }

    @Override
    public void updateMenu(String string, MMenu mMenu) {
        MMenu mMenu2;
        if (string.equals("EDIT_MENU") && (mMenu2 = (MMenu)this.browser.getProperty("org.makagiga.commons.WebBrowser.EDIT_MENU_PROPERTY")) != null) {
            mMenu.addItemsFromMenu(mMenu2);
        }
    }

    @Override
    public void updateToolBar(String string, MToolBar mToolBar) {
        ActionGroup actionGroup;
        Boolean bl;
        if (string.equals("EDITOR_TOOL_BAR") && ((bl = (Boolean)this.browser.getProperty("org.makagiga.commons.WebBrowser.SHOW_ACTION_GROUP_PROPERTY")) == null || Boolean.TRUE.equals(bl)) && (actionGroup = (ActionGroup)this.browser.getProperty("org.makagiga.commons.WebBrowser.ACTION_GROUP_PROPERTY")) != null) {
            actionGroup.updateToolBar(mToolBar);
        }
    }

    protected void addWebBrowserContainer(JComponent jComponent) {
        this.addCenter(jComponent);
    }
}

