/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.editors;

import java.awt.datatransfer.DataFlavor;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.makagiga.commons.Config;
import org.makagiga.commons.FS;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;
import org.makagiga.commons.preview.DefaultPreview;
import org.makagiga.commons.preview.Preview;
import org.makagiga.editors.Editor;
import org.makagiga.plugins.AbstractPlugin;
import org.makagiga.plugins.PluginEvent;
import org.makagiga.plugins.PluginException;
import org.makagiga.plugins.PluginInfo;
import org.makagiga.plugins.PluginListener;
import org.makagiga.plugins.PluginManager;
import org.makagiga.plugins.PluginType;

public abstract class EditorPlugin
extends AbstractPlugin<Editor<?>> {
    private boolean readOnly;
    private Encryption encryption = Encryption.NOT_SUPPORTED;
    private static Map<String, PluginInfo> extensionCache = new HashMap<String, PluginInfo>();
    private final MArrayList<FileType> exportTypeList = new MArrayList();
    private final MArrayList<FileType> fileTypeList = new MArrayList();
    private final MArrayList<FileType> importTypeList = new MArrayList();
    private PluginListener pluginListener;
    private String documentDisplayName;

    @Override
    public void onDestroy() throws PluginException {
        super.onDestroy();
        if (this.pluginListener != null) {
            this.getPluginManagerPrivileged().removePluginListener(this.pluginListener);
            this.pluginListener = null;
        }
    }

    @Override
    public void onInit(Config config, PluginInfo pluginInfo) throws PluginException {
        super.onInit(config, pluginInfo);
        this.pluginListener = new PluginListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public PluginListener.Result pluginChanged(PluginEvent pluginEvent) {
                if (pluginEvent.getID() != PluginEvent.ID.UNLOADED) return PluginListener.Result.OK;
                Class<EditorPlugin> clazz = EditorPlugin.class;
                synchronized (EditorPlugin.class) {
                    extensionCache.clear();
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return PluginListener.Result.OK;
                }
            }
        };
        this.getPluginManagerPrivileged().addPluginListener(this.pluginListener);
    }

    public static Editor<?> createEditorForInfo(PluginInfo pluginInfo) throws Exception {
        Editor editor;
        try {
            editor = (Editor)((EditorPlugin)EditorPlugin.class.cast(pluginInfo.getPluggable())).create();
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            throw new Exception(noClassDefFoundError);
        }
        editor.setInfo(pluginInfo);
        return editor;
    }

    public static Editor<?> createEditorForPath(String string) throws Exception {
        String string2 = FS.getExtension(string);
        if (string2 == null) {
            MLogger.error("plugin", "No type for file name \"%s\"", string);
            return null;
        }
        PluginInfo pluginInfo = EditorPlugin.findPluginForExtension(string2);
        if (pluginInfo == null) {
            MLogger.error("plugin", "No editor for file name \"%s\"", string);
            return null;
        }
        return EditorPlugin.createEditorForInfo(pluginInfo);
    }

    public static MIcon findIconForExtension(String string) {
        PluginInfo pluginInfo = EditorPlugin.findPluginForExtension(string);
        return pluginInfo == null ? null : pluginInfo.getIcon();
    }

    public static PluginInfo findPluginForDataFlavor(Object object, DataFlavor dataFlavor, Map<DataFlavor, Object> map) {
        for (PluginInfo pluginInfo : PluginType.EDITOR.get()) {
            if (!((EditorPlugin)EditorPlugin.class.cast(pluginInfo.getPluggable())).isDataFlavorSupported(object, dataFlavor, map)) continue;
            return pluginInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static PluginInfo findPluginForExtension(String string) {
        Class<EditorPlugin> clazz = EditorPlugin.class;
        synchronized (EditorPlugin.class) {
            PluginInfo pluginInfo2 = extensionCache.get(string);
            if (pluginInfo2 != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return pluginInfo2;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (PluginInfo pluginInfo2 : PluginType.EDITOR.get()) {
                if (!((EditorPlugin)EditorPlugin.class.cast(pluginInfo2.getPluggable())).hasExtension(string)) continue;
                Class<EditorPlugin> clazz2 = EditorPlugin.class;
                synchronized (EditorPlugin.class) {
                    extensionCache.put(string, pluginInfo2);
                    // ** MonitorExit[var3_4] (shouldn't be in output)
                    return pluginInfo2;
                }
            }
            return null;
        }
    }

    public static PluginInfo findPluginForMime(String string) {
        for (PluginInfo pluginInfo : PluginType.EDITOR.get()) {
            if (!((EditorPlugin)EditorPlugin.class.cast(pluginInfo.getPluggable())).hasImportMime(string)) continue;
            return pluginInfo;
        }
        return null;
    }

    public FileType getDefaultExtension() {
        return this.fileTypeList.getFirst();
    }

    public String getDocumentDisplayName() {
        return this.documentDisplayName == null ? this.getInfo().toString() : this.documentDisplayName;
    }

    public void setDocumentDisplayName(String string) {
        this.documentDisplayName = string;
    }

    public final Encryption getEncryption() {
        return this.encryption;
    }

    public final void setEncryption(Encryption encryption) {
        this.encryption = TK.checkNull(encryption, "value");
    }

    public List<FileType> getExportTypes() {
        return Collections.unmodifiableList(this.exportTypeList);
    }

    public List<FileType> getFileTypes() {
        return Collections.unmodifiableList(this.fileTypeList);
    }

    public List<FileType> getImportTypes() {
        return Collections.unmodifiableList(this.importTypeList);
    }

    public boolean hasExtension(String string) {
        for (FileType fileType : this.fileTypeList) {
            if (!fileType.is(string)) continue;
            return true;
        }
        return false;
    }

    public boolean hasImportMime(String string) {
        for (FileType fileType : this.importTypeList) {
            if (!string.equals(fileType.mime)) continue;
            return true;
        }
        return false;
    }

    public void importData(Object object, DataFlavor dataFlavor, Map<DataFlavor, Object> map, File file) throws Exception {
    }

    public boolean isDataFlavorSupported(Object object, DataFlavor dataFlavor, Map<DataFlavor, Object> map) {
        return false;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    protected void addPreview(String string, Preview preview) {
        SecurityManager securityManager = System.getSecurityManager();
        DefaultPreview defaultPreview = securityManager == null ? DefaultPreview.getInstance() : AccessController.doPrivileged(new PrivilegedAction<DefaultPreview>(){

            @Override
            public DefaultPreview run() {
                return DefaultPreview.getInstance();
            }
        });
        defaultPreview.addHandler(string, preview);
    }

    protected void setExportTypes(FileType ... fileTypeArray) {
        this.exportTypeList.clear();
        this.exportTypeList.addAll((FileType[])fileTypeArray);
    }

    protected void setFileTypes(FileType ... fileTypeArray) {
        this.fileTypeList.clear();
        this.fileTypeList.addAll((FileType[])fileTypeArray);
    }

    protected void setImportTypes(FileType ... fileTypeArray) {
        this.importTypeList.clear();
        this.importTypeList.addAll((FileType[])fileTypeArray);
    }

    protected void setReadOnly(boolean bl) {
        this.readOnly = bl;
    }

    private PluginManager getPluginManagerPrivileged() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return PluginManager.getInstance();
        }
        return AccessController.doPrivileged(new PrivilegedAction<PluginManager>(){

            @Override
            public PluginManager run() {
                return PluginManager.getInstance();
            }
        });
    }

    public static final class FileType {
        private final boolean internal;
        private String[] aliases;
        private final String description;
        private final String extension;
        private final String mime;

        public FileType(String string) {
            this(string, null, null, TK.EMPTY_STRING_ARRAY);
        }

        public FileType(String string, String[] stringArray) {
            this(string, null, null, stringArray);
        }

        public FileType(String string, String string2) {
            this(string, string2, null, TK.EMPTY_STRING_ARRAY);
        }

        public FileType(String string, String string2, String string3) {
            this(string, string2, string3, TK.EMPTY_STRING_ARRAY);
        }

        public FileType(String string, String string2, String string3, String[] stringArray) {
            this(string, string2, string3, false);
            this.aliases = TK.copyOf(stringArray);
        }

        public FileType(String string, String string2, String string3, boolean bl) {
            this.internal = bl;
            this.description = string2;
            this.extension = string;
            this.mime = string3;
            if (bl) {
                this.aliases = TK.EMPTY_STRING_ARRAY;
            }
        }

        public String getDescription() {
            return this.description;
        }

        public String[] getExtensions() {
            String[] stringArray = new String[1 + this.aliases.length];
            stringArray[0] = this.extension;
            System.arraycopy(this.aliases, 0, stringArray, 1, this.aliases.length);
            return stringArray;
        }

        public boolean is(String string) {
            if (this.extension == null) {
                return false;
            }
            if (string == null) {
                return false;
            }
            if (this.extension.equalsIgnoreCase(string)) {
                return true;
            }
            for (String string2 : this.aliases) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return true;
            }
            return false;
        }

        public boolean isInternal() {
            return this.internal;
        }

        public String toString() {
            return this.extension;
        }
    }

    public static enum Encryption {
        NOT_SUPPORTED,
        MEMORY;

    }
}

