/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.todo;

import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.todo.TaskModel;
import org.makagiga.todo.TaskTable;

class Todo
extends TaskTable {
    Todo() {
        for (ActionGroup.Item item : this.getEditActionGroup()) {
            if (item.getType() != ActionGroup.Type.ACTION || "delete-completed".equals(item.getID())) continue;
            item.setShowTextInToolBar(false);
        }
        this.addMouseListener(new MMouseAdapter(){

            @Override
            public void popupTrigger(MouseEvent mouseEvent) {
                Todo.this.getEditActionGroup().createMenu().showPopup(mouseEvent);
            }
        });
    }

    void read(File file) throws Exception {
        try {
            boolean bl = !file.exists() || file.length() == 0L;
            ((TaskModel)this.getModel()).loadFromXML(file, bl);
        }
        catch (FileNotFoundException fileNotFoundException) {
            MLogger.info("todo", "Creating a new to-do file: %s", file);
        }
    }
}

