/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.desktop.internetsearch;

import org.makagiga.MainWindow;
import org.makagiga.commons.Kiosk;
import org.makagiga.commons.MainView;
import org.makagiga.commons.UI;
import org.makagiga.desktop.Widget;
import org.makagiga.desktop.WidgetPlugin;
import org.makagiga.desktop.internetsearch.InternetSearchWidget;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorSearch;
import org.makagiga.internetsearch.InternetSearchPanel;
import org.makagiga.plugins.PluginException;

public final class InternetSearchWidgetPlugin
extends WidgetPlugin {
    @Override
    public Widget create() throws PluginException {
        InternetSearchWidget internetSearchWidget = InternetSearchWidget.getInstance();
        if (internetSearchWidget != null) {
            MainWindow.showWidget(internetSearchWidget, false);
            throw new PluginException(UI._("Internet Search widget already created"));
        }
        return new InternetSearchWidget(this.getInfo());
    }

    @Override
    public void onPostInit() throws PluginException {
        super.onPostInit();
        if (((Boolean)Kiosk.actionInternetSearch.get()).booleanValue()) {
            MainView.bind(new Action());
        }
    }

    private static final class Action
    extends InternetSearchPanel.Action {
        private Action() {
        }

        @Override
        public void onAction() {
            if (!((Boolean)Kiosk.actionInternetSearch.get()).booleanValue()) {
                return;
            }
            InternetSearchWidget internetSearchWidget = InternetSearchWidget.getInstance();
            if (internetSearchWidget != null) {
                InternetSearchPanel internetSearchPanel = internetSearchWidget.getInternetSearchPanel();
                if (internetSearchPanel.isEmpty()) {
                    String string = Editor.getCurrentEditor() instanceof EditorSearch ? ((EditorSearch)EditorSearch.class.cast(Editor.getCurrentEditor())).getDefaultSearchText() : "";
                    internetSearchPanel.setText(string);
                }
                MainWindow.showWidget(internetSearchWidget, false);
            }
        }
    }
}

