/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.db;

import java.lang.ref.WeakReference;
import org.makagiga.commons.ActionGroup;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MV;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.db.DBTable;
import org.makagiga.db.DBTableModel;
import org.makagiga.db.DBView;

public class DBNavigationActionGroup<M extends DBTableModel>
extends ActionGroup {
    private final WeakReference<DBView<M>> viewRef;

    public DBNavigationActionGroup(DBView<M> dBView) {
        this.viewRef = new WeakReference<DBView<M>>(TK.checkNull(dBView));
        MAction mAction = new MAction(UI._("First"), "ui/first"){

            @Override
            public void onAction() {
                DBNavigationActionGroup.this.first();
            }
        };
        this.add("first", mAction);
        this.add("previous", new MAction(MActionInfo.PREVIOUS){

            @Override
            public void onAction() {
                DBNavigationActionGroup.this.previous();
            }
        }).setShowTextInToolBar(true);
        this.add("next", new MAction(MActionInfo.NEXT){

            @Override
            public void onAction() {
                DBNavigationActionGroup.this.next();
            }
        }).setShowTextInToolBar(true);
        MAction mAction2 = new MAction(UI._("Last"), "ui/last"){

            @Override
            public void onAction() {
                DBNavigationActionGroup.this.last();
            }
        };
        this.add("last", mAction2);
    }

    public boolean first() {
        DBTable<M> dBTable = this.getTable();
        if (dBTable == null || dBTable.isEmpty(MV.VIEW)) {
            return false;
        }
        dBTable.selectRow(0);
        return true;
    }

    public boolean last() {
        DBTable<M> dBTable = this.getTable();
        if (dBTable == null || dBTable.isEmpty(MV.VIEW)) {
            return false;
        }
        dBTable.selectRow(dBTable.getRowCount() - 1);
        return true;
    }

    public boolean next() {
        DBTable<M> dBTable = this.getTable();
        if (dBTable == null) {
            return false;
        }
        int n = dBTable.getSelectedRow();
        if (n == dBTable.getRowCount() - 1) {
            return false;
        }
        dBTable.selectRow(n + 1);
        return true;
    }

    public boolean previous() {
        DBTable<M> dBTable = this.getTable();
        if (dBTable == null) {
            return false;
        }
        int n = dBTable.getSelectedRow();
        if (n == 0) {
            return false;
        }
        dBTable.selectRow(n - 1);
        return true;
    }

    @Override
    public void update() {
        DBTable<M> dBTable = this.getTable();
        if (dBTable != null) {
            int n = dBTable.getRowCount();
            boolean bl = n == 0;
            int n2 = dBTable.getSelectedRow();
            if (bl || n2 == -1) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled("first", n2 > 0);
            this.setEnabled("previous", n2 > 0);
            this.setEnabled("next", n2 < n - 1);
            this.setEnabled("last", n2 < n - 1);
        } else {
            this.setEnabled(false);
        }
    }

    private DBTable<M> getTable() {
        DBView dBView = (DBView)this.viewRef.get();
        if (dBView == null) {
            return null;
        }
        DBView.ModelView modelView = dBView.getModelView();
        return modelView instanceof DBTable ? (DBTable)modelView : null;
    }
}

