/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.console;

import java.util.List;
import java.util.Set;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MTextField;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.script.ScriptExecutor;
import org.makagiga.console.Console;
import org.makagiga.console.ConsoleCommand;

public final class ScriptCommand
extends ConsoleCommand {
    private List<ScriptEngineFactory> engineFactories;
    private ScriptEngine calcEngine;
    private ScriptEngine engine;
    private Set<String> calcBlacklist;

    public ScriptCommand() {
        super("script", "Script engine");
        this.setSmallIcon("ui/misc");
    }

    @Override
    public List<String> getAutoCompletionList() {
        StringList stringList = new StringList();
        for (ScriptEngineFactory scriptEngineFactory : this.getEngineFactories()) {
            for (String string : scriptEngineFactory.getExtensions()) {
                stringList.add("\"" + string + "\"");
            }
        }
        return stringList;
    }

    @Override
    public boolean handleUknownCommand(Console console, String string) {
        String string2 = string.trim();
        if (string2.startsWith("=")) {
            if (this.calcEngine == null) {
                this.calcEngine = ScriptExecutor.getEngine("js");
            }
            string2 = string2.substring(1);
            if (this.calcBlacklist == null) {
                this.calcBlacklist = TK.newHashSet("com.", "org.", "sun.", "sunw.", "java.", "javax.");
            }
            String string3 = string2.replaceAll("\\p{Space}+", "");
            for (String string4 : this.calcBlacklist) {
                if (!string3.contains(string4)) continue;
                console.getIO().printError("Illegal Expression: " + string2);
                return true;
            }
            ScriptCommand.eval(console, this.calcEngine, string2);
            return true;
        }
        return false;
    }

    @Override
    public boolean onHighlight(MHighlighter<MTextField> mHighlighter, String string, List<String> list) {
        if (list == null) {
            return false;
        }
        if (list.size() == 2) {
            boolean bl = false;
            String string2 = list.get(1);
            for (ScriptEngineFactory scriptEngineFactory : this.getEngineFactories()) {
                if (!scriptEngineFactory.getExtensions().contains(string2)) continue;
                bl = true;
                break;
            }
            mHighlighter.addHighlight(0, string.length(), bl ? MHighlighter.OK_COLOR : MHighlighter.ERROR_COLOR);
            return true;
        }
        return false;
    }

    @Override
    public Object onCommand(Console console, String ... stringArray) {
        Console.IO iO = console.getIO();
        if (!ScriptExecutor.userScript.get().booleanValue()) {
            iO.printLine("Disabled by the Administrator");
            return null;
        }
        if (stringArray.length != 1) {
            iO.printLine("  Usage: script <identifier>");
            iO.printLine("Example: script js");
            iO.printLine();
            iO.printLine("Available script engines:");
            for (ScriptEngineFactory scriptEngineFactory : this.getEngineFactories()) {
                iO.printLine("\t%s %s (%s %s) Identifiers: %s", scriptEngineFactory.getLanguageName(), scriptEngineFactory.getLanguageVersion(), scriptEngineFactory.getEngineName(), scriptEngineFactory.getEngineVersion(), TK.join(scriptEngineFactory.getExtensions(), " "));
            }
            iO.printLine();
            iO.printLine("Calculator: =<JavaScript Expression>");
            iO.printLine("   Example: =foo=15; 1337*(42+foo)");
            iO.printLine("       See: http://makagiga.blogspot.com/2009/06/console-simple-calculator.html");
        } else {
            String string = stringArray[0];
            this.engine = ScriptExecutor.getEngine(string);
            if (this.engine == null) {
                iO.printError("Script engine not found: " + string);
            } else {
                iO.printLine("Type \"exit\" to return...");
                console.setExclusiveMode(this);
            }
        }
        return null;
    }

    @Override
    public boolean onExclusiveCommand(Console console, String string) {
        if ("exit".equals(string)) {
            this.engine = null;
            console.setExclusiveMode(null);
            return true;
        }
        ScriptCommand.eval(console, this.engine, string);
        return true;
    }

    @Override
    public boolean onHelp(Console console) {
        Console.IO iO = console.getIO();
        iO.printLine("This a simple script interpreter...");
        iO.printLine("Example JavaScript commands:");
        iO.printLine("\t2+2");
        iO.printLine("\tvar x = 5; println(x);");
        return true;
    }

    private static void eval(Console console, ScriptEngine scriptEngine, String string) {
        Console.IO iO = console.getIO();
        try {
            Object object = scriptEngine.eval(string);
            iO.printLine("%s", object);
        }
        catch (ScriptException scriptException) {
            iO.printError(scriptException.getMessage());
        }
    }

    private synchronized List<ScriptEngineFactory> getEngineFactories() {
        if (this.engineFactories == null) {
            ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
            this.engineFactories = scriptEngineManager.getEngineFactories();
        }
        return this.engineFactories;
    }
}

