/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.print;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.UI;

public class PrintableImage
implements MDisposable,
Printable {
    private boolean useDispose = true;
    private Image image;

    public PrintableImage(Image image) {
        this(image, true);
    }

    @Deprecated
    public PrintableImage(Image image, boolean bl) {
        this.image = image;
    }

    public boolean getUseDispose() {
        return this.useDispose;
    }

    public void setUseDispose(boolean bl) {
        this.useDispose = bl;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n > 0) {
            return 1;
        }
        double d = pageFormat.getImageableHeight();
        double d2 = UI.getAutoScale(this.image, new Dimension((int)pageFormat.getImageableWidth(), (int)d));
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        graphics2D.translate(0.0, (double)(-n) * d);
        graphics2D.scale(d2, d2);
        graphics2D.drawImage(this.image, 0, 0, null);
        return 0;
    }

    @Override
    public Object dispose(Object ... objectArray) {
        if (this.useDispose) {
            this.image = null;
        }
        return null;
    }
}

