/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.mv;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JComponent;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.commons.painters.RoundedBackgroundPainter;

public class ColorRenderer<T>
extends MRenderer<T> {
    private boolean flat;
    private Color color;
    private final GlassPainter glassPainter;
    private final RoundedBackgroundPainter roundedBackgroundPainter;

    public ColorRenderer() {
        Insets insets = UI.createInsets(2);
        this.glassPainter = new GlassPainter();
        this.glassPainter.setPainterInsets(insets);
        this.glassPainter.setRoundType(GlassPainter.RoundType.NONE);
        this.roundedBackgroundPainter = new RoundedBackgroundPainter(null, 19, insets);
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public boolean isFlat() {
        return this.flat;
    }

    public void setFlat(boolean bl) {
        this.flat = bl;
    }

    @Override
    protected JComponent createView() {
        MRenderer.OptimizedLabel optimizedLabel = new MRenderer.OptimizedLabel(){

            @Override
            public void paintComponent(Graphics graphics) {
                if (!UI.isA03() && !UI.isSubstance()) {
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                if (ColorRenderer.this.color != null) {
                    RoundedBackgroundPainter roundedBackgroundPainter = ColorRenderer.this.flat || this.isPaintingForPrint() ? ColorRenderer.this.roundedBackgroundPainter : ColorRenderer.this.glassPainter;
                    roundedBackgroundPainter.setPrimaryColor(ColorRenderer.this.color);
                    roundedBackgroundPainter.paint(this, (Graphics2D)graphics);
                }
                super.paintComponent(graphics);
            }
        };
        optimizedLabel.setHorizontalAlignment(0);
        return optimizedLabel;
    }

    @Override
    protected void onRender(T t) {
        MLabel mLabel = this.getLabel();
        if (this.isSelected()) {
            this.color = null;
            mLabel.setOpaque(true);
        } else {
            if (this.color == null) {
                Color color = mLabel.getBackground();
                if (color == null) {
                    color = Color.WHITE;
                }
                mLabel.setForeground(UI.getXorColor(color));
            } else {
                mLabel.setForeground(UI.getXorColor(this.color));
            }
            mLabel.setOpaque(false);
        }
    }
}

