/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons.mods;

import java.util.Iterator;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.PermissionInfo;
import org.makagiga.commons.TK;
import org.makagiga.commons.mods.Mod;
import org.makagiga.commons.security.MPermission;
import org.makagiga.commons.util.CollectionMap;

public final class Mods {
    public static final String DIALOG_CLOSE = "close@org.makagiga.commons.MDialog";
    public static final String DIALOG_EXEC = "exec@org.makagiga.commons.MDialog";
    private static CollectionMap<String, Mod> commandMap = new CollectionMap(CollectionMap.MapType.SYNCHRONIZED_HASH_MAP, CollectionMap.CollectionType.SYNCHRONIZED_ARRAY_LIST);

    public static void add(String string, Mod mod) {
        Mods.validateCommand(string);
        if (!Mods.checkPermission(string)) {
            return;
        }
        commandMap.add(string, mod);
    }

    public static boolean contains(String string) {
        return commandMap.containsKey(string);
    }

    public static void remove(String string, Mod mod) {
        Object object = commandMap.get(string);
        if (object != null) {
            if (!Mods.checkPermission(string)) {
                return;
            }
            object.remove(mod);
        }
    }

    public static void replace(String string, Mod mod) {
        Mods.validateCommand(string);
        if (!Mods.checkPermission(string)) {
            return;
        }
        commandMap.remove(string);
        commandMap.add(string, mod);
    }

    public static Object exec(Object object, String string, Object ... objectArray) {
        Object object2 = commandMap.get(string);
        if (object2 != null) {
            try {
                Object object3 = null;
                Iterator iterator = object2.iterator();
                while (iterator.hasNext()) {
                    Mod mod = (Mod)iterator.next();
                    object3 = mod.exec(object, string, objectArray == null ? TK.EMPTY_STRING_ARRAY : objectArray);
                }
                return object3;
            }
            catch (SecurityException securityException) {
                MLogger.warning("mods", "No permission to execute: " + string);
                return null;
            }
            catch (Exception exception) {
                MLogger.warning("mods", "Failed: " + string);
                MLogger.exception(exception);
                return null;
            }
        }
        return null;
    }

    private Mods() {
    }

    private static boolean checkPermission(String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            try {
                securityManager.checkPermission(new Permission(string));
            }
            catch (SecurityException securityException) {
                MLogger.exception(securityException);
                return false;
            }
        }
        return true;
    }

    private static void validateCommand(String string) {
        if (string == null || string.indexOf(64) == -1) {
            throw new IllegalArgumentException("Mod command must be in format: Command@ClassName (example: exec@org.makagiga.commons.MDialog)");
        }
    }

    public static final class Permission
    extends MPermission {
        @Override
        public String getActions() {
            return super.getActions();
        }

        @Override
        public String getPermissionDescription() {
            return super.getPermissionDescription();
        }

        @Override
        public int getPermissionOptions() {
            return super.getPermissionOptions();
        }

        @Override
        public PermissionInfo.ThreatLevel getThreatLevel() {
            return super.getThreatLevel();
        }

        private Permission(String string) {
            super(string, PermissionInfo.ThreatLevel.HIGH, "User Interface Modifications");
            this.setActions("install");
        }
    }
}

