/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.text.ParseException;
import java.util.List;
import org.makagiga.commons.IntegerProperty;
import org.makagiga.commons.TK;

public class VersionProperty
extends IntegerProperty {
    private String qualifier;

    public VersionProperty() {
        super(65536);
    }

    public VersionProperty(int n) {
        super(n);
    }

    public int getBugfix() {
        return (Integer)this.get() & 0xFF;
    }

    public int getMajor() {
        return (Integer)this.get() >> 16 & 0xFF;
    }

    public int getMinor() {
        return (Integer)this.get() >> 8 & 0xFF;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    @Override
    public void parse(String string) throws ParseException {
        if (TK.isEmpty(string)) {
            this.set(1, 0, 0);
            return;
        }
        try {
            List<String> list;
            int n = string.indexOf(45);
            String string2 = null;
            if (n != -1) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            this.set((list = TK.fastSplit(string, '.')).size() > 0 ? Integer.parseInt(list.get(0)) : 1, list.size() > 1 ? Integer.parseInt(list.get(1)) : 0, list.size() > 2 ? Integer.parseInt(list.get(2)) : 0, string2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }

    public void set(int n, int n2, int n3) {
        this.set(n, n2, n3, null);
    }

    public void set(int n, int n2, int n3, String string) {
        this.qualifier = string;
        int n4 = n << 16;
        n4 += n2 << 8;
        this.set(n4 += n3);
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getMajor()).append('.').append(this.getMinor());
        int n = this.getBugfix();
        if (n != 0) {
            stringBuilder.append('.').append(n);
        }
        if (!TK.isEmpty(this.qualifier)) {
            stringBuilder.append('-').append(this.qualifier);
        }
        return stringBuilder.toString();
    }
}

