/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.UUID;
import java.util.regex.Pattern;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.StringList;
import org.makagiga.commons.ValueEvent;
import org.makagiga.commons.ValueListener;

public final class TK {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    public static final ChangeListener[] EMPTY_CHANGE_LISTENER_ARRAY = new ChangeListener[0];
    public static final char[] EMPTY_CHAR_ARRAY = new char[0];
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    public static final PropertyChangeListener[] EMPTY_PROPERTY_CHANGE_LISTENER_ARRAY = new PropertyChangeListener[0];
    public static final String[] EMPTY_STRING_ARRAY = new String[0];
    public static final int ESCAPE_FILE = 1;
    public static final int ESCAPE_SPACE = 2;
    private static Pattern validateIDPattern = Pattern.compile("(\\w|\\-)+");

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static String buildErrorMessage(Throwable throwable) {
        TK.checkNull(throwable);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        Throwable throwable2 = throwable;
        do {
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            if (n > 0) {
                stringBuilder.append("- ");
            }
            stringBuilder.append(throwable2);
            ++n;
        } while ((throwable2 = throwable2.getCause()) != null);
        return stringBuilder.toString();
    }

    public static String capitalize(String string) {
        if (TK.isEmpty(string)) {
            return string;
        }
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        stringBuilder.append(Character.toUpperCase(string.charAt(0)));
        if (n > 1) {
            stringBuilder.append(string.substring(1));
        }
        return stringBuilder.toString();
    }

    public static <T> T checkNull(T t) {
        if (t == null) {
            throw new NullPointerException();
        }
        return t;
    }

    public static <T> T checkNull(T t, String string) {
        if (t == null) {
            if (string == null) {
                throw new NullPointerException();
            }
            throw new NullPointerException("\"" + string + "\" is \"null\"");
        }
        return t;
    }

    public static String checkNullOrEmpty(String string) {
        if (TK.isEmpty(string)) {
            throw new IllegalArgumentException("String is null or empty");
        }
        return string;
    }

    public static String checkNullOrEmpty(String string, String string2) {
        if (TK.isEmpty(string)) {
            throw new IllegalArgumentException("\"" + string2 + "\" string is null or empty");
        }
        return string;
    }

    public static <T extends Comparable<T>> int compare(T t, T t2, T t3) {
        T t4 = t == null ? t3 : t;
        T t5 = t2 == null ? t3 : t2;
        return t4.compareTo(t5);
    }

    public static int compare(int n, int n2) {
        return n < n2 ? -1 : (n == n2 ? 0 : 1);
    }

    public static int compare(long l, long l2) {
        return l < l2 ? -1 : (l == l2 ? 0 : 1);
    }

    public static <T> T[] copyOf(T[] TArray) {
        if (TArray == null) {
            return null;
        }
        return Arrays.copyOf(TArray, TArray.length);
    }

    public static String createRandomUUID() {
        return "{" + UUID.randomUUID() + "}";
    }

    public static Object deserialize(ObjectInputStream objectInputStream, String string) throws ClassNotFoundException, IOException {
        TK.checkNull(string);
        Object[] objectArray = (Object[])objectInputStream.readObject();
        if (objectArray.length == 2 && objectArray[0].equals(string)) {
            return objectArray[1];
        }
        return null;
    }

    public static <T> T dispose(T t) {
        if (t instanceof MDisposable) {
            ((MDisposable)MDisposable.class.cast(t)).dispose(new Object[0]);
        }
        return null;
    }

    public static String escapeURL(String string) {
        return TK.escapeURL(string, 0);
    }

    public static String escapeURL(String string, int n) {
        try {
            String string2 = URLEncoder.encode(string, "UTF-8");
            if ((n & 1) != 0) {
                string2 = string2.replace("*", "%2A");
            }
            if ((n & 2) != 0) {
                string2 = string2.replace("+", "%20");
            }
            return string2;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MLogger.exception(unsupportedEncodingException);
            return string;
        }
    }

    public static String escapeXML(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n * 2);
        block7: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    stringBuilder.append("&lt;");
                    continue block7;
                }
                case '>': {
                    stringBuilder.append("&gt;");
                    continue block7;
                }
                case '&': {
                    stringBuilder.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    stringBuilder.append("&#039;");
                    continue block7;
                }
                case '\"': {
                    stringBuilder.append("&quot;");
                    continue block7;
                }
                default: {
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String filler(char c, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("\"length\" cannot be less than zero");
        }
        char[] cArray = new char[n];
        Arrays.fill(cArray, c);
        return new String(cArray);
    }

    public static void fireActionPerformed(Object object, ActionListener[] actionListenerArray) {
        if (actionListenerArray.length > 0) {
            ActionEvent actionEvent = new ActionEvent(object, 1001, "");
            for (ActionListener actionListener : actionListenerArray) {
                actionListener.actionPerformed(actionEvent);
            }
        }
    }

    public static void fireStateChanged(Object object, ChangeListener[] changeListenerArray) {
        if (changeListenerArray.length > 0) {
            ChangeEvent changeEvent = new ChangeEvent(object);
            for (ChangeListener changeListener : changeListenerArray) {
                changeListener.stateChanged(changeEvent);
            }
        }
    }

    public static <T> void fireValueChanged(Object object, ValueListener<T>[] valueListenerArray, T t, T t2) {
        TK.fireValueChanged(object, valueListenerArray, t, t2, null);
    }

    public static <T> void fireValueChanged(Object object, ValueListener<T>[] valueListenerArray, T t, T t2, Object object2) {
        if (valueListenerArray.length > 0) {
            ValueEvent<T> valueEvent = new ValueEvent<T>(object, t, t2, object2);
            for (ValueListener<T> valueListener : valueListenerArray) {
                valueListener.valueChanged(valueEvent);
            }
        }
    }

    public static <T> T get(Reference<T> reference) {
        return reference == null ? null : (T)reference.get();
    }

    public static boolean isChange(Object object, Object object2) {
        if (object == null) {
            return object2 != null;
        }
        return !object.equals(object2);
    }

    public static boolean isEmpty(char[] cArray) {
        return cArray == null || cArray.length == 0;
    }

    public static boolean isEmpty(CharSequence charSequence) {
        return charSequence == null || charSequence.length() == 0;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isEmpty(Object[] objectArray) {
        return objectArray == null || objectArray.length == 0;
    }

    public static boolean isEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static boolean isKeyStroke(KeyEvent keyEvent, int n) {
        return TK.isKeyStroke(keyEvent, n, 0);
    }

    public static boolean isKeyStroke(KeyEvent keyEvent, int n, int n2) {
        return keyEvent.getKeyCode() == n && keyEvent.getModifiers() == n2;
    }

    public static <T> Iterable<T> iterable(final Enumeration<?> enumeration) {
        TK.checkNull(enumeration);
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return TK.iterator(enumeration);
            }
        };
    }

    public static <T> Iterator<T> iterator(final Enumeration<?> enumeration) {
        TK.checkNull(enumeration);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration.hasMoreElements();
            }

            @Override
            public T next() {
                return enumeration.nextElement();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Deprecated
    public static String join(Collection<?> collection, String string) {
        if (TK.isEmpty(collection)) {
            return null;
        }
        return TK.toString(collection, string);
    }

    @Deprecated
    public static String join(Object[] objectArray, String string) {
        if (TK.isEmpty(objectArray)) {
            return null;
        }
        return TK.toString(objectArray, string);
    }

    public static int maxLength(Iterable<String> iterable) {
        TK.checkNull(iterable);
        int n = 0;
        for (String string : iterable) {
            n = Math.max(n, string.length());
        }
        return n;
    }

    public static <T> T[] newArray(Class<T> clazz, Object[] objectArray) {
        if (TK.isEmpty(objectArray)) {
            return (Object[])Array.newInstance(clazz, 0);
        }
        Object[] objectArray2 = (Object[])Array.newInstance(clazz, objectArray.length);
        System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
        return objectArray2;
    }

    public static <K, V> Map<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> Map<K, V> newHashMap(int n) {
        return new HashMap(n);
    }

    public static <K, V> Map<K, V> newHashMap(Object ... objectArray) {
        if (objectArray.length % 2 != 0) {
            throw new IllegalArgumentException("Key without value");
        }
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>(objectArray.length / 2);
        for (int i = 0; i < objectArray.length; i += 2) {
            hashMap.put(objectArray[i], objectArray[i + 1]);
        }
        return hashMap;
    }

    public static <T> Set<T> newHashSet(T ... TArray) {
        if (TK.isEmpty(TArray)) {
            return new HashSet();
        }
        HashSet<T> hashSet = new HashSet<T>(TArray.length);
        for (T t : TArray) {
            hashSet.add(t);
        }
        return hashSet;
    }

    public static <T> T newInstance(String string) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(string);
        return (T)clazz.newInstance();
    }

    public static <T> T newInstance(String string, ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = Class.forName(string, true, classLoader);
        return (T)clazz.newInstance();
    }

    public static <K, V> Map<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> Map<K, V> newLinkedHashMap(int n) {
        return new LinkedHashMap(n);
    }

    public static <T> WeakReference<T> newWeakRef(T t) {
        return new WeakReference<T>(t);
    }

    public static <K, V> List<V> order(LinkedHashMap<K, V> linkedHashMap, K ... KArray) {
        MArrayList<Object> mArrayList = new MArrayList<Object>(linkedHashMap.size());
        if (TK.isEmpty(KArray)) {
            mArrayList.addAll(linkedHashMap.values());
            return mArrayList;
        }
        for (K k : KArray) {
            Object v = linkedHashMap.remove(k);
            if (v == null) {
                MLogger.warning("core", "TK.order: \"%s\" key not found", k);
                continue;
            }
            mArrayList.add(v);
        }
        for (Object e : linkedHashMap.values()) {
            mArrayList.add(e);
        }
        return mArrayList;
    }

    public static List<String> parseArguments(String string) throws ParseException {
        if (string == null) {
            return Collections.emptyList();
        }
        int n = string.length();
        if (n == 0) {
            return Collections.emptyList();
        }
        boolean bl = false;
        boolean bl2 = false;
        StringList stringList = new StringList();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case ' ': {
                    if (bl2) {
                        stringBuilder.append(c);
                        break;
                    }
                    if (stringBuilder.length() <= 0) break;
                    stringList.add(stringBuilder.toString());
                    stringBuilder.setLength(0);
                    break;
                }
                case '\\': {
                    if (bl2) {
                        if (bl) {
                            stringBuilder.append('\\');
                            bl = false;
                            break;
                        }
                        bl = true;
                        break;
                    }
                    stringBuilder.append(c);
                    break;
                }
                case '\"': {
                    if (bl2) {
                        if (bl) {
                            stringBuilder.append('\"');
                            bl = false;
                            break;
                        }
                        stringList.add(stringBuilder.toString());
                        stringBuilder.setLength(0);
                        bl2 = false;
                        break;
                    }
                    bl2 = true;
                    break;
                }
                default: {
                    if (bl) {
                        switch (c) {
                            case 'n': {
                                stringBuilder.append('\n');
                                break;
                            }
                            case 't': {
                                stringBuilder.append('\t');
                                break;
                            }
                            default: {
                                TK.throwInvalidEscapeSequence(i);
                            }
                        }
                        bl = false;
                        break;
                    }
                    stringBuilder.append(c);
                }
            }
            if (i != n - 1) continue;
            if (bl) {
                TK.throwInvalidEscapeSequence(i + 1);
            }
            if (bl2) {
                TK.throwMissingQuoteCharacter(i + 1);
            }
            if (stringBuilder.length() <= 0) continue;
            stringList.add(stringBuilder.toString());
        }
        return stringList;
    }

    public static int range(int n, int n2, int n3, int n4) {
        if (n3 > n4) {
            throw new IllegalArgumentException(String.format("minValue (%d) > maxValue (%d)", n3, n4));
        }
        return n < n3 || n > n4 ? n2 : n;
    }

    public static void serialize(ObjectOutputStream objectOutputStream, String string, Object object) throws IOException {
        TK.checkNull(string);
        Object[] objectArray = object instanceof Serializable ? new Object[]{string, object} : EMPTY_OBJECT_ARRAY;
        objectOutputStream.writeObject(objectArray);
    }

    public static boolean sleep(long l) {
        try {
            Thread.sleep(l);
            return true;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return false;
        }
    }

    public static <K extends Comparable<?>, V> Map<K, V> sortByKey(Map<K, V> map, Comparator<K> comparator) {
        TreeMap<K, V> treeMap = new TreeMap<K, V>(comparator);
        treeMap.putAll(map);
        return treeMap;
    }

    public static <K, V> List<V> sortByValue(Map<K, V> map, Comparator<V> comparator) {
        MArrayList<V> mArrayList = new MArrayList<V>(map.values());
        mArrayList.sort(comparator);
        return mArrayList;
    }

    public static boolean startsWith(String string, char c) {
        return !string.isEmpty() && string.charAt(0) == c;
    }

    public static String stripMarkupTags(String string) {
        if (TK.isEmpty(string)) {
            return string;
        }
        boolean bl = false;
        int n = string.length();
        StringBuilder stringBuilder = new StringBuilder(n);
        block4: for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '<': {
                    bl = true;
                    continue block4;
                }
                case '>': {
                    bl = false;
                    continue block4;
                }
                default: {
                    if (bl) continue block4;
                    stringBuilder.append(c);
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String substring(String string, String string2, String string3, boolean bl) throws ParseException {
        int n = string.indexOf(string2);
        if (n == -1) {
            throw new ParseException("\"" + string2 + "\" start substring not found", 0);
        }
        int n2 = string.indexOf(string3);
        if (n2 == -1) {
            throw new ParseException("\"" + string3 + "\" end substring not found", 0);
        }
        if (n2 <= n) {
            throw new ParseException("End index <= start index", 0);
        }
        if (bl) {
            n2 += string3.length();
        } else {
            n += string2.length();
        }
        return string.substring(n, n2);
    }

    public static String toByteHex(int n) {
        return n < 16 ? '0' + Integer.toHexString(n) : Integer.toHexString(n);
    }

    public static String toLowerCase(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static String toString(int n, int n2) {
        String string = KeyEvent.getKeyText(n);
        String string2 = KeyEvent.getKeyModifiersText(n2);
        if (TK.isEmpty(string2)) {
            return string;
        }
        if (TK.isEmpty(string)) {
            return string2;
        }
        return string2 + "+" + string;
    }

    public static String toString(KeyStroke keyStroke) {
        return TK.toString(keyStroke.getKeyCode(), keyStroke.getModifiers());
    }

    public static String toString(Collection<?> collection, String string) {
        if (TK.isEmpty(collection)) {
            return "";
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (Object obj : collection) {
            if (bl) {
                stringBuilder.append(string).append(obj);
            } else {
                stringBuilder.append(obj);
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static String toString(Object[] objectArray, String string) {
        if (TK.isEmpty(objectArray)) {
            return "";
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (Object object : objectArray) {
            if (object == null) continue;
            if (bl) {
                stringBuilder.append(string).append(object);
            } else {
                stringBuilder.append(object);
            }
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static String toString(Object[] objectArray) {
        if (TK.isEmpty(objectArray)) {
            return "";
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder(1024);
        for (Object object : objectArray) {
            if (bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(object.toString());
            bl = true;
        }
        return stringBuilder.toString();
    }

    public static String toUpperCase(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static String unescapeURL(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            MLogger.exception(unsupportedEncodingException);
            return string;
        }
    }

    public static String unescapeXML(String string) {
        if (TK.isEmpty(string)) {
            return string;
        }
        return string.replace("&#039;", "'").replace("&apos;", "'").replace("&quot;", "\"").replace("&lt;", "<").replace("&gt;", ">").replace("&amp;", "&");
    }

    public static <T> Iterator<T> unmodifiableIterator(final Iterator<T> iterator) {
        TK.checkNull(iterator);
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static String validateID(String string) {
        if (TK.isEmpty(string) || !validateIDPattern.matcher(string).matches()) {
            throw new IllegalArgumentException(String.format("Invalid \"id\": \"%s\". Valid IDs are \"%s\".", string, validateIDPattern));
        }
        return string;
    }

    public static String validateID(String string, String string2) {
        if (TK.isEmpty(string) || !string.matches(string2)) {
            throw new IllegalArgumentException(String.format("Invalid \"id\": \"%s\". Valid IDs are \"%s\".", string, string2));
        }
        return string;
    }

    public static String centerSqueeze(String string) {
        return TK.centerSqueeze(string, 50);
    }

    public static String centerSqueeze(String string, int n) {
        if (string == null) {
            return null;
        }
        int n2 = Math.max(3, n);
        if (string.length() <= n2) {
            return string;
        }
        if (n2 == 3 || string.length() < 4) {
            return "...";
        }
        int n3 = string.length() / 2;
        int n4 = (string.length() - n2) / 2;
        return string.substring(0, n3 - n4 - 2) + "..." + string.substring(n3 + n4 + 2);
    }

    public static int compareIgnoreCase(String string, String string2, String string3) {
        String string4 = string == null ? string3 : string;
        String string5 = string2 == null ? string3 : string2;
        return string4.compareToIgnoreCase(string5);
    }

    public static boolean containsIgnoreCase(String string, String string2) {
        return TK.containsIgnoreCase(string, string2, Locale.getDefault());
    }

    public static boolean containsIgnoreCase(String string, String string2, Locale locale) {
        if (string == null || string2 == null) {
            return false;
        }
        return string.toUpperCase(locale).indexOf(string2.toUpperCase(locale)) != -1;
    }

    public static String fastReplace(String string, String string2, String string3) {
        StringBuilder stringBuilder = new StringBuilder(string);
        if (TK.fastReplace(stringBuilder, string2, string3)) {
            return stringBuilder.toString();
        }
        return string;
    }

    public static boolean fastReplace(StringBuilder stringBuilder, String string, String string2) {
        int n;
        int n2 = string.length();
        boolean bl = n2 == (n = string2.length());
        boolean bl2 = false;
        int n3 = 0;
        while ((n3 = stringBuilder.indexOf(string, n3)) != -1) {
            bl2 = true;
            if (bl) {
                stringBuilder.replace(n3, n3 + n, string2);
            } else {
                stringBuilder.delete(n3, n3 + n2);
                stringBuilder.insert(n3, string2);
            }
            n3 += n;
        }
        return bl2;
    }

    public static List<String> fastSplit(String string, char c) {
        if (string == null) {
            return Collections.emptyList();
        }
        int n = string.length();
        if (n == 0) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = 0;
        int n3 = -1;
        while (true) {
            if ((n2 = string.indexOf(c, n2)) == -1) {
                if (n == n3 + 1) {
                    return arrayList;
                }
                if (n3 == -1) {
                    arrayList.add(string);
                } else {
                    arrayList.add(string.substring(n3 + 1, n));
                }
                return arrayList;
            }
            if (n2 == n3 + 1) {
                ++n2;
                ++n3;
                continue;
            }
            if (n3 == -1) {
                arrayList.add(string.substring(0, n2));
            } else {
                arrayList.add(string.substring(n3 + 1, n2));
            }
            n3 = n2++;
        }
    }

    public static String rightSqueeze(String string, int n) {
        if (string == null) {
            return null;
        }
        if (string.length() > n) {
            return string.substring(0, n - 1) + "...";
        }
        return string;
    }

    private TK() {
    }

    private static void throwInvalidEscapeSequence(int n) throws ParseException {
        throw new ParseException("Invalid escape sequence.\nValid escape characters are:\n\t\\\\ - \\ character\n\t\\\" - \" character\n\t\\n - new line\n\t\\t - tab character", n);
    }

    private static void throwMissingQuoteCharacter(int n) throws ParseException {
        throw new ParseException("Missing quote character", n);
    }
}

