/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.makagiga.commons.FS;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.UI;

public class MZip
implements Closeable,
Iterable<ZipEntry> {
    public static final int UNPACK_VALIDATE_ENTRY = 1;
    protected ZipInputStream zipInput;
    protected ZipOutputStream zipOutput;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZipEntry addEntry(String string, File file) throws IOException {
        ZipEntry zipEntry;
        FS.BufferedFileInput bufferedFileInput = null;
        try {
            bufferedFileInput = new FS.BufferedFileInput(file);
            zipEntry = this.addEntry(string, bufferedFileInput);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileInput);
            throw throwable;
        }
        FS.close(bufferedFileInput);
        return zipEntry;
    }

    public ZipEntry addEntry(String string, InputStream inputStream) throws IOException {
        ZipEntry zipEntry = this.beginEntry(string);
        this.copyToEntry(inputStream);
        return zipEntry;
    }

    public ZipEntry addEntry(String string, String string2) throws IOException {
        return this.addEntry(string, new File(string2));
    }

    public ZipEntry beginEntry(String string) throws IOException {
        ZipEntry zipEntry = new ZipEntry(string);
        this.zipOutput.putNextEntry(zipEntry);
        return zipEntry;
    }

    @Override
    public void close() throws IOException {
        if (this.zipInput != null) {
            this.zipInput.close();
        }
        if (this.zipOutput != null) {
            this.zipOutput.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyEntryTo(File file) throws IOException {
        FS.BufferedFileOutput bufferedFileOutput = null;
        try {
            bufferedFileOutput = new FS.BufferedFileOutput(file);
            this.copyEntryTo(bufferedFileOutput);
        }
        catch (Throwable throwable) {
            FS.close(bufferedFileOutput);
            throw throwable;
        }
        FS.close(bufferedFileOutput);
    }

    public void copyEntryTo(OutputStream outputStream) throws IOException {
        FS.copyStream(this.zipInput, outputStream);
    }

    public void copyEntryTo(String string) throws IOException {
        this.copyEntryTo(new File(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyToEntry(InputStream inputStream) throws IOException {
        try {
            FS.copyStream(inputStream, this.zipOutput);
        }
        finally {
            this.zipOutput.closeEntry();
        }
    }

    public ZipInputStream getInputStream() {
        return this.zipInput;
    }

    public ZipOutputStream getOutputStream() {
        return this.zipOutput;
    }

    @Override
    public Iterator<ZipEntry> iterator() {
        return new Iterator<ZipEntry>(){
            private ZipEntry nextZipEntry;

            @Override
            public boolean hasNext() {
                try {
                    this.nextZipEntry = MZip.this.zipInput.getNextEntry();
                    return this.nextZipEntry != null;
                }
                catch (IOException iOException) {
                    MLogger.exception(iOException);
                    return false;
                }
            }

            @Override
            public ZipEntry next() {
                return this.nextZipEntry;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static MZip read(File file) throws FileNotFoundException {
        return new MZip(new FS.BufferedFileInput(file));
    }

    public static MZip read(InputStream inputStream) {
        return new MZip(inputStream);
    }

    public static MZip read(String string) throws FileNotFoundException {
        return new MZip(new FS.BufferedFileInput(string));
    }

    public void unpackTo(String string) throws IOException {
        this.unpackTo(string, 0);
    }

    public void unpackTo(String string, int n) throws IOException {
        Flags flags = new Flags(n);
        for (ZipEntry zipEntry : this) {
            String string2 = zipEntry.getName();
            string2 = string2.replace('/', File.separatorChar);
            if (flags.isSet(1L) && (string2.startsWith(File.separator) || string2.contains(".." + File.separator))) {
                throw new IOException("Zip entry name contains unsafe characters");
            }
            String string3 = FS.makePath(string, string2);
            if (zipEntry.isDirectory()) {
                if (FS.mkdirs(string3) || FS.exists(string3)) continue;
                throw new IOException(UI._("Could not create \"{0}\" directory", string3));
            }
            this.copyEntryTo(string3);
        }
    }

    public static MZip write(File file) throws FileNotFoundException {
        return new MZip(new FS.BufferedFileOutput(file));
    }

    public static MZip write(OutputStream outputStream) {
        return new MZip(outputStream);
    }

    public static MZip write(String string) throws FileNotFoundException {
        return new MZip(new FS.BufferedFileOutput(string));
    }

    protected MZip(InputStream inputStream) {
        this.zipInput = new ZipInputStream(inputStream);
    }

    protected MZip(OutputStream outputStream) {
        this.zipOutput = new ZipOutputStream(outputStream);
    }
}

