/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MCellTip;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MScrollPane;
import org.makagiga.commons.MTreeItem;
import org.makagiga.commons.MTreeModel;
import org.makagiga.commons.MTreeScanner;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class MTree<I extends MTreeItem, M extends MTreeModel<I>>
extends JTree
implements UI.ComponentExtensions {
    public MTree() {
        this((M)new MTreeModel());
    }

    public MTree(M m) {
        super((TreeModel)m);
        ToolTipManager.sharedInstance().registerComponent(this);
        MCellTip.getInstance().install(this);
        StaticHandler staticHandler = new StaticHandler();
        this.addKeyListener(staticHandler);
        this.addMouseListener(staticHandler);
        this.addMouseMotionListener(staticHandler);
    }

    public void focusItem(I i) {
        if (i == null) {
            return;
        }
        new MTreeScanner<I>((MTreeItem)((MTreeModel)this.getModel()).getRootItem(), (MTreeItem)i){
            final /* synthetic */ MTreeItem val$item;
            {
                this.val$item = mTreeItem2;
                super(mTreeItem);
            }

            @Override
            public void processItem(I i) {
                if (i != null && (i == this.val$item || ((MTreeItem)i).matches(this.val$item))) {
                    MTree.this.selectItem(i, true);
                    this.stop();
                }
            }
        };
    }

    public I getItemForLocation(Point point) {
        if (point == null) {
            return null;
        }
        int n = this.getRowForLocation(point);
        if (n == -1) {
            return null;
        }
        I i = this.getItemAtRow(n);
        if (i == null) {
            return null;
        }
        return i;
    }

    public I getItemAtRow(int n) {
        TreePath treePath = this.getPathForRow(n);
        return (I)(treePath == null ? null : (MTreeItem)treePath.getLastPathComponent());
    }

    public M getModel() {
        return (M)((MTreeModel)super.getModel());
    }

    public int getRowForLocation(Point point) {
        return this.getRowForLocation(point.x, point.y);
    }

    public I getSelectedItem() {
        TreePath treePath = this.getSelectionPath();
        return (I)(treePath == null ? null : (MTreeItem)treePath.getLastPathComponent());
    }

    public List<I> getSelection() {
        Object[] objectArray = this.getSelectionPaths();
        if (TK.isEmpty(objectArray)) {
            return Collections.emptyList();
        }
        MArrayList<MTreeItem> mArrayList = new MArrayList<MTreeItem>(objectArray.length);
        for (Object object : objectArray) {
            mArrayList.add((MTreeItem)((TreePath)object).getLastPathComponent());
        }
        return mArrayList;
    }

    @Override
    public Point getToolTipLocation(MouseEvent mouseEvent) {
        int n = this.getRowForLocation(mouseEvent.getPoint());
        if (n == -1) {
            return null;
        }
        Rectangle rectangle = this.getRowBounds(n);
        return new Point(rectangle.x + 10, rectangle.y + rectangle.height + 10);
    }

    public boolean isDropZone(int n) {
        JTree.DropLocation dropLocation = this.getDropLocation();
        return dropLocation != null && dropLocation.getChildIndex() == -1 && this.getRowForPath(dropLocation.getPath()) == n;
    }

    public boolean isExpanded(I i) {
        return this.isExpanded((I)((MTreeItem)i).getTreePath());
    }

    public void setExpanded(I i, boolean bl) {
        if (bl) {
            this.expandPath(((MTreeItem)i).getTreePath());
        } else {
            this.collapsePath(((MTreeItem)i).getTreePath());
        }
    }

    public void selectItem(I i, boolean bl) {
        if (i != null) {
            TreePath treePath = ((MTreeItem)i).getTreePath();
            this.setSelectionPath(treePath);
            if (bl) {
                this.makeVisible(treePath);
                Rectangle rectangle = this.getPathBounds(treePath);
                MScrollPane.scrollToNextItem(this, rectangle);
                if (rectangle != null && this.accessibleContext != null) {
                    this.accessibleContext.firePropertyChange("AccessibleVisibleData", false, true);
                }
            }
        }
    }

    public void repaint(TreePath treePath) {
        Rectangle rectangle;
        if (treePath != null && (rectangle = this.getPathBounds(treePath)) != null) {
            this.repaint(rectangle);
        }
    }

    public void setSingleSelectionMode() {
        this.getSelectionModel().setSelectionMode(1);
    }

    public void stopEditing(boolean bl) {
        if (this.isEditing()) {
            this.stopEditing();
            if (bl) {
                this.requestFocusInWindow();
            }
        }
    }

    public boolean toggleItem(I i) {
        TreePath treePath = ((MTreeItem)i).getTreePath();
        boolean bl = this.isExpanded((I)treePath);
        if (bl) {
            this.collapsePath(treePath);
        } else {
            this.expandPath(treePath);
        }
        return !bl;
    }

    public boolean toggleRow(int n) {
        boolean bl = this.isExpanded((I)n);
        if (bl) {
            this.collapseRow(n);
        } else {
            this.expandRow(n);
        }
        return !bl;
    }

    protected MMenu createContextMenu() {
        return null;
    }

    protected void onAction(InputEvent inputEvent, int n) {
        this.toggleRow(n);
    }

    protected void popupContextMenu(InputEvent inputEvent) {
        MMenu mMenu;
        Point point;
        if (inputEvent != null) {
            point = ((MouseEvent)MouseEvent.class.cast(inputEvent)).getPoint();
            int n = this.getRowForLocation(point);
            if (!this.isRowSelected(n)) {
                this.setSelectionRow(n);
            }
        } else {
            point = new Point();
        }
        if (!this.isSelectionEmpty() && (mMenu = this.createContextMenu()) != null) {
            mMenu.showPopup((Component)this, point);
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        if (keyEvent.getID() == 401 && TK.isKeyStroke(keyEvent, 10)) {
            this.openAtRow(keyEvent, this.getLeadSelectionRow());
            keyEvent.consume();
        } else {
            super.processKeyEvent(keyEvent);
        }
    }

    private void openAtRow(InputEvent inputEvent, int n) {
        if (n == -1) {
            if (inputEvent instanceof MouseEvent) {
                return;
            }
            this.clearSelection();
        } else {
            this.onAction(inputEvent, n);
        }
    }

    private static final class StaticHandler
    extends MMouseAdapter
    implements KeyListener {
        private StaticHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (UI.isPopupTrigger(keyEvent)) {
                MTree mTree = (MTree)keyEvent.getSource();
                mTree.popupContextMenu(null);
            }
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            if ((MAction.isTrigger(mouseEvent) || StaticHandler.isMiddle(mouseEvent)) && !mouseEvent.isControlDown() && !mouseEvent.isShiftDown()) {
                mouseEvent.consume();
                MTree mTree = (MTree)mouseEvent.getSource();
                mTree.openAtRow(mouseEvent, mTree.getRowForLocation(mouseEvent.getPoint()));
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MTree mTree = (MTree)mouseEvent.getSource();
            int n = mTree.getRowForLocation(mouseEvent.getPoint());
            TreeCellRenderer treeCellRenderer = mTree.getCellRenderer();
            if (treeCellRenderer instanceof MRenderer) {
                MRenderer mRenderer = (MRenderer)treeCellRenderer;
                mRenderer.setMouseHover(mTree, mTree.getPathForRow(n));
            }
            mTree.setCursor(Cursor.getPredefinedCursor(n != -1 ? 12 : 0));
        }

        @Override
        public void popupTrigger(MouseEvent mouseEvent) {
            MTree mTree = (MTree)mouseEvent.getSource();
            mTree.popupContextMenu(mouseEvent);
        }
    }
}

