/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Container;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.MFlipPanel;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MThrobber;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.fx.ImageTransition;

public class MTaskPanel<T>
extends MFlipPanel {
    private volatile boolean cancelled;
    private volatile boolean error;
    private StaticThrobber throbber;
    private volatile transient SwingWorker<T, Object> worker;

    public MTaskPanel() {
        this((JComponent)null);
    }

    public MTaskPanel(JComponent jComponent) {
        super(jComponent, null);
        this.setTransitionEffect(new ImageTransition.FadeEffect());
        this.throbber = new StaticThrobber();
        this.setBackComponent(this.throbber);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public void cancel(boolean bl) {
        if (this.worker != null) {
            this.worker.cancel(bl);
            this.worker = null;
        }
    }

    public T getResult() throws Exception {
        return this.worker == null ? null : (T)this.worker.get();
    }

    public MThrobber getThrobber() {
        return this.throbber;
    }

    public SwingWorker<T, Object> getWorker() {
        return this.worker;
    }

    public boolean isActive() {
        return this.worker != null;
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public boolean isError() {
        return this.error;
    }

    public void setErrorMessage(String string) {
        this.error = true;
        this.throbber.setIconName(MMessage.getRandomErrorIconName());
        if (string != null && string.contains("\n")) {
            this.throbber.setMultilineText(string);
        } else {
            this.throbber.setText(string);
        }
        this.throbber.setToolTipText(UI._("Error"));
        this.setFrontVisible(false);
    }

    public void start() {
        this.start(UI._("Please Wait..."));
    }

    public synchronized void start(String string) {
        this.cancel(true);
        this.throbber.setText(string);
        this.throbber.setActive(true);
        this.setFrontVisible(false);
        this.error = false;
        this.worker = new SwingWorker<T, Object>(){

            @Override
            protected T doInBackground() throws Exception {
                return MTaskPanel.this.doInBackground();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void done() {
                try {
                    MTaskPanel.this.cancelled = this.isCancelled();
                    MTaskPanel.this.throbber.setText(null);
                    MTaskPanel.this.throbber.setActive(false);
                    MTaskPanel.this.setFrontVisible(true);
                    MTaskPanel.this.done();
                }
                finally {
                    MTaskPanel.this.worker = null;
                    MTaskPanel.this.fireStateChanged();
                }
            }
        };
        this.worker.execute();
        this.fireStateChanged();
    }

    protected T doInBackground() throws Exception {
        return null;
    }

    protected void done() {
    }

    protected void fireStateChanged() {
        TK.fireStateChanged(this, this.getChangeListeners());
    }

    protected void setError(boolean bl) {
        this.error = bl;
    }

    private static final class StaticThrobber
    extends MThrobber {
        @Override
        public void setActive(boolean bl) {
            super.setActive(bl);
            this.setCursor(bl ? 12 : 0);
        }

        private StaticThrobber() {
            this.makeLargeMessage();
            this.setToolTipText(UI._("Click to abort"));
            this.addMouseListener(new MMouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    StaticThrobber staticThrobber;
                    Container container;
                    if (1.isLeft(mouseEvent) && (container = (staticThrobber = (StaticThrobber)mouseEvent.getSource()).getParent()) instanceof MTaskPanel) {
                        ((MTaskPanel)MTaskPanel.class.cast(container)).cancel(true);
                    }
                }
            });
        }
    }
}

