/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import javax.swing.JSeparator;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.UI;

public class MSeparator
extends JSeparator
implements UI.ComponentExtensions {
    private boolean centered;

    public MSeparator() {
        this(0);
    }

    public MSeparator(int n) {
        super(n);
    }

    public static MSeparator createHorizontal() {
        return new MSeparator(0);
    }

    public static MSeparator createVertical() {
        return new MSeparator(1);
    }

    public boolean isCentered() {
        return this.centered;
    }

    public void setCentered(boolean bl) {
        if (bl != this.centered) {
            this.centered = bl;
            this.repaint();
        }
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        if (this.centered) {
            Color color = this.getForeground();
            if (color == null) {
                color = Color.BLACK;
            }
            color = MColor.deriveAlpha(color, 20);
            Graphics2D graphics2D = (Graphics2D)graphics;
            if (this.getOrientation() == 0) {
                Insets insets;
                Border border;
                int n = this.getHeight() / 2;
                MLabel mLabel = (MLabel)MLabel.getLabel(this);
                if (mLabel != null && (border = mLabel.getBorder()) instanceof EmptyBorder && (insets = ((EmptyBorder)EmptyBorder.class.cast(border)).getBorderInsets()) != null) {
                    n += insets.top / 2;
                }
                graphics2D.setColor(color);
                graphics2D.drawLine(0, n, this.getWidth() - 1, n);
            } else {
                int n = this.getWidth() / 2;
                graphics2D.setColor(color);
                graphics2D.drawLine(n, 0, n, this.getHeight() - 1);
            }
        } else {
            super.paintComponent(graphics);
        }
    }
}

