/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.DesktopManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;
import javax.swing.event.MouseInputAdapter;
import javax.swing.plaf.DesktopIconUI;
import javax.swing.plaf.basic.BasicInternalFrameTitlePane;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MBorderLayout;
import org.makagiga.commons.MDesktopPane;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class MInternalFrame
extends JInternalFrame
implements MBorderLayout,
MIcon.Name {
    private boolean backgroundDraggable;
    private boolean shaped;
    private DragAdapter dragAdapter;

    public MInternalFrame() {
        this(null);
    }

    public MInternalFrame(String string) {
        super(string);
        this.setContentPane(new ContentPane());
        this.setClosable(true);
        this.setDefaultCloseOperation(0);
        this.setIconifiable(true);
        this.setResizable(true);
        this.addInternalFrameListener(new StaticHandler());
    }

    public void close() {
        try {
            this.setClosed(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            MLogger.exception(propertyVetoException);
        }
    }

    @Override
    public String getIconName() {
        return MIcon.getName(this.getFrameIcon());
    }

    @Override
    public void setIconName(String string) {
        this.setFrameIcon(MIcon.stock(string));
    }

    public boolean isBackgroundDraggable() {
        return this.backgroundDraggable;
    }

    public void setBackgroundDraggable(boolean bl) {
        if (this.backgroundDraggable == bl) {
            return;
        }
        this.backgroundDraggable = bl;
        if (this.backgroundDraggable) {
            if (this.dragAdapter == null) {
                this.dragAdapter = new DragAdapter();
                this.dragAdapter.install(this);
            }
        } else if (this.dragAdapter != null) {
            this.dragAdapter.uninstall(this);
            this.dragAdapter = null;
        }
    }

    public boolean isShaped() {
        return this.shaped;
    }

    public void setShaped(boolean bl) {
        if (bl == this.shaped) {
            return;
        }
        this.shaped = bl;
        Container container = this.getContentPane();
        if (container instanceof ContentPane) {
            ((ContentPane)ContentPane.class.cast(container)).setShaped(this.shaped);
        }
        this.getRootPane().setOpaque(!this.shaped);
        this.updateUI();
    }

    @Override
    public void paintBorder(Graphics graphics) {
        if (this.shouldPaintBorder()) {
            super.paintBorder(graphics);
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        if (!this.shaped) {
            super.paintComponent(graphics);
        }
    }

    public void select() {
        try {
            this.setSelected(true);
        }
        catch (PropertyVetoException propertyVetoException) {
            MLogger.warning("core", propertyVetoException.toString());
        }
    }

    @Override
    public void setCursor(Cursor cursor) {
        if (MDesktopPane.isLocked(this)) {
            super.setCursor(Cursor.getDefaultCursor());
        } else {
            super.setCursor(cursor);
        }
    }

    public void setIcon(Icon icon) {
        this.setFrameIcon(icon);
    }

    @Override
    public void setLocation(int n, int n2) {
        JDesktopPane jDesktopPane = this.getDesktopPane();
        if (jDesktopPane != null && jDesktopPane.getDesktopManager() instanceof MDesktopPane.MDesktopManager) {
            int n3 = ((MDesktopPane.MDesktopManager)MDesktopPane.MDesktopManager.class.cast(jDesktopPane.getDesktopManager())).getSnapSize();
            super.setLocation(Math.max(n3, n), Math.max(n3, n2));
        } else {
            super.setLocation(n, n2);
        }
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && MApplication.forceRTL && !this.isVisible()) {
            this.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        super.setVisible(bl);
    }

    public void showContextMenu(MouseEvent mouseEvent) {
        MMenu mMenu = this.onContextMenu(mouseEvent);
        if (mMenu != null) {
            mMenu.showPopup(mouseEvent);
        }
    }

    @Override
    public void addCenter(JComponent jComponent) {
        UI.addCenter(this, jComponent);
    }

    @Override
    public void addEast(JComponent jComponent) {
        this.add((Component)jComponent, "After");
    }

    @Override
    public void addNorth(JComponent jComponent) {
        this.add((Component)jComponent, "First");
    }

    @Override
    public void addSouth(JComponent jComponent) {
        this.add((Component)jComponent, "Last");
    }

    @Override
    public void addWest(JComponent jComponent) {
        this.add((Component)jComponent, "Before");
    }

    protected MMenu.Title addTitle(MMenu mMenu) {
        String string = this.getTitle();
        if (!TK.isEmpty(string)) {
            return mMenu.addTitle(TK.centerSqueeze(string, 25), this.getFrameIcon());
        }
        return null;
    }

    protected boolean canClose() {
        return true;
    }

    protected MAction createCloseAction() {
        boolean bl = MDesktopPane.isLocked(this);
        MAction mAction = new MAction(MActionInfo.CLOSE_NO_KEY_STROKE){

            @Override
            public void onAction() {
                MInternalFrame.this.doDefaultCloseAction();
            }
        };
        mAction.setEnabled(!bl);
        return mAction;
    }

    protected void invalidateUI() {
        this.invalidateUI((DesktopIconUI)UIManager.getUI(this.desktopIcon));
    }

    protected void invalidateUI(DesktopIconUI desktopIconUI) {
        this.invalidate();
        if (this.desktopIcon != null) {
            this.desktopIcon.setUI(desktopIconUI);
            Dimension dimension = this.desktopIcon.getPreferredSize();
            this.desktopIcon.setSize(dimension.width, dimension.height);
            this.desktopIcon.invalidate();
            for (Component component : this.desktopIcon.getComponents()) {
                SwingUtilities.updateComponentTreeUI(component);
            }
        }
    }

    protected void onActivate() {
    }

    protected void onClose() {
    }

    protected MMenu onContextMenu(InputEvent inputEvent) {
        MMenu mMenu = new MMenu();
        this.addTitle(mMenu);
        mMenu.add(this.createCloseAction());
        return mMenu;
    }

    protected void onDeactivate() {
    }

    protected void onDispose() {
    }

    protected void onMinimize() {
    }

    protected boolean shouldPaintBorder() {
        return !this.shaped;
    }

    private static final class StaticHandler
    extends InternalFrameAdapter {
        @Override
        public void internalFrameActivated(InternalFrameEvent internalFrameEvent) {
            MInternalFrame mInternalFrame = (MInternalFrame)internalFrameEvent.getSource();
            mInternalFrame.onActivate();
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent internalFrameEvent) {
            MInternalFrame mInternalFrame = (MInternalFrame)internalFrameEvent.getSource();
            if (mInternalFrame.canClose()) {
                mInternalFrame.onClose();
                mInternalFrame.onDispose();
                mInternalFrame.dispose();
                if (mInternalFrame.dragAdapter != null) {
                    mInternalFrame.dragAdapter.uninstall(mInternalFrame);
                    mInternalFrame.dragAdapter = null;
                }
            }
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent internalFrameEvent) {
            MInternalFrame mInternalFrame = (MInternalFrame)internalFrameEvent.getSource();
            mInternalFrame.onDeactivate();
        }

        @Override
        public void internalFrameDeiconified(InternalFrameEvent internalFrameEvent) {
            MInternalFrame mInternalFrame = (MInternalFrame)internalFrameEvent.getSource();
            mInternalFrame.onActivate();
        }

        @Override
        public void internalFrameIconified(InternalFrameEvent internalFrameEvent) {
            MInternalFrame mInternalFrame = (MInternalFrame)internalFrameEvent.getSource();
            mInternalFrame.onMinimize();
        }

        private StaticHandler() {
        }
    }

    public static class DragAdapter
    extends MouseInputAdapter {
        private Point dragStart = new Point();

        public void install(JComponent jComponent) {
            UI.setStyle("cursor: hand", jComponent);
            jComponent.addMouseListener(this);
            jComponent.addMouseMotionListener(this);
        }

        public void uninstall(JComponent jComponent) {
            UI.setStyle("cursor: default", jComponent);
            jComponent.removeMouseListener(this);
            jComponent.removeMouseMotionListener(this);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (!MMouseAdapter.isLeft(mouseEvent)) {
                return;
            }
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            if (jComponent instanceof JInternalFrame.JDesktopIcon) {
                if (MDesktopPane.isLocked(jComponent)) {
                    return;
                }
                JDesktopPane jDesktopPane = MDesktopPane.getDesktopPane(jComponent);
                if (jDesktopPane != null) {
                    Point point = SwingUtilities.convertPoint(jComponent, mouseEvent.getPoint(), jDesktopPane);
                    point.translate(-this.dragStart.x, -this.dragStart.y);
                    if (jDesktopPane.getDesktopManager() instanceof MDesktopPane.MDesktopManager) {
                        MDesktopPane.MDesktopManager mDesktopManager = (MDesktopPane.MDesktopManager)jDesktopPane.getDesktopManager();
                        mDesktopManager.snap(jDesktopPane, jComponent, point);
                    }
                    jComponent.setLocation(point);
                }
            } else {
                if (MDesktopPane.isLocked(jComponent)) {
                    return;
                }
                JDesktopPane jDesktopPane = MDesktopPane.getDesktopPane(jComponent);
                if (jDesktopPane != null) {
                    DesktopManager desktopManager = jDesktopPane.getDesktopManager();
                    if (jComponent instanceof BasicInternalFrameTitlePane) {
                        jComponent = (JComponent)jComponent.getParent();
                    }
                    Point point = SwingUtilities.convertPoint(jComponent, mouseEvent.getPoint(), jDesktopPane);
                    point.translate(-this.dragStart.x, -this.dragStart.y);
                    desktopManager.dragFrame(jComponent, point.x, point.y);
                }
            }
            mouseEvent.consume();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            JComponent jComponent;
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (this.showContextMenu(mouseEvent)) {
                return;
            }
            if (!MMouseAdapter.isLeft(mouseEvent)) {
                return;
            }
            JComponent jComponent2 = jComponent = (JComponent)mouseEvent.getSource();
            this.dragStart = mouseEvent.getPoint();
            jComponent2.requestFocusInWindow();
            if (jComponent2 instanceof BasicInternalFrameTitlePane) {
                jComponent2 = (JComponent)jComponent2.getParent();
            }
            JDesktopPane jDesktopPane = MDesktopPane.getDesktopPane(jComponent2);
            if (jComponent2 instanceof JInternalFrame.JDesktopIcon) {
                object = (JInternalFrame.JDesktopIcon)jComponent2;
                ((JInternalFrame.JDesktopIcon)object).getInternalFrame().toFront();
            }
            if (!MDesktopPane.isLocked(jComponent2)) {
                UI.setStyle("cursor: move", jComponent);
            } else {
                UI.setStyle("cursor: default", jComponent);
            }
            Object object2 = object = jDesktopPane == null ? null : jDesktopPane.getDesktopManager();
            if (object != null) {
                object.beginDraggingFrame(jComponent2);
            }
            mouseEvent.consume();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            DesktopManager desktopManager;
            if (mouseEvent.isConsumed()) {
                return;
            }
            if (this.showContextMenu(mouseEvent)) {
                return;
            }
            if (!MMouseAdapter.isLeft(mouseEvent)) {
                return;
            }
            JComponent jComponent = (JComponent)mouseEvent.getSource();
            UI.setStyle("cursor: hand", jComponent);
            this.dragStart.setLocation(0, 0);
            JDesktopPane jDesktopPane = MDesktopPane.getDesktopPane(jComponent);
            DesktopManager desktopManager2 = desktopManager = jDesktopPane != null ? jDesktopPane.getDesktopManager() : null;
            if (desktopManager != null) {
                desktopManager.endDraggingFrame(jComponent);
            }
            mouseEvent.consume();
        }

        private boolean showContextMenu(MouseEvent mouseEvent) {
            if (!mouseEvent.isPopupTrigger()) {
                return false;
            }
            JInternalFrame jInternalFrame = MDesktopPane.getInternalFrame((JComponent)mouseEvent.getSource());
            if (jInternalFrame instanceof MInternalFrame) {
                ((MInternalFrame)MInternalFrame.class.cast(jInternalFrame)).showContextMenu(mouseEvent);
                mouseEvent.consume();
                return true;
            }
            return false;
        }
    }

    public static final class ContentPane
    extends MPanel {
        private boolean shaped;

        @Override
        public void paintComponent(Graphics graphics) {
            if (!this.shaped) {
                super.paintComponent(graphics);
            }
        }

        public void setShaped(boolean bl) {
            if (bl != this.shaped) {
                this.shaped = bl;
                this.setOpaque(!this.shaped);
                this.repaint();
            }
        }
    }
}

