/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import org.makagiga.commons.FS;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Item;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MList;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSearchPanel;
import org.makagiga.commons.Property;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.swing.Input;

public class MIconChooser
extends MPanel {
    public static final int SHOW_BROWSE_BUTTON = 1;
    public static final int SHOW_DEFAULT_ICON = 2;
    private final List<IconItem> allIcons;
    private final MList<IconItem> iconList;
    private final MSearchPanel searchPanel;

    public MIconChooser(List<IconItem> list) {
        super(5, 5);
        this.allIcons = list;
        this.iconList = new MList<IconItem>(){

            @Override
            protected void onAction() {
                if (this.getActionType() == MList.ActionType.TRIGGER) {
                    MIconChooser.this.onSelect();
                }
            }
        };
        this.iconList.setLayoutOrientation(2);
        this.iconList.setSingleSelectionMode();
        this.iconList.setVisibleRowCount(-1);
        this.iconList.setCellRenderer((ListCellRenderer<IconItem>)new Item.Renderer<IconItem>(5){

            @Override
            protected void onRender(IconItem iconItem) {
                super.onRender(iconItem);
                this.setToolTipText(iconItem.getText());
                if (iconItem.getIcon() == null) {
                    this.setStyle("font-style: italic");
                }
            }
        });
        int n = MIcon.getUISize();
        this.iconList.setFixedCellHeight(n + 10);
        this.iconList.setFixedCellWidth(n * 4 + 10);
        this.searchPanel = new MSearchPanel(false, MSearchPanel.Type.FILTER){

            @Override
            protected void onChange(DocumentEvent documentEvent) {
                MIconChooser.this.updateIconList(this.getText());
            }
        };
        this.addNorth(this.searchPanel);
        this.addCenter(MPanel.createVLabelPanel(this.iconList, UI._("Icons:")));
        this.updateIconList(null);
    }

    public static File browse(Window window) {
        return Input.getImageFile(window);
    }

    public static File browse(Window window, String string) {
        return Input.getImageFile(window, string);
    }

    public static IconItem fromList(Window window, List<IconItem> list) {
        return MIconChooser.fromList(window, list, 0);
    }

    public static IconItem fromList(Window window, List<IconItem> list, int n) {
        IconItem iconItem;
        Flags flags = new Flags(n);
        int n2 = 71;
        if (flags.isSet(1L)) {
            n2 |= 8;
        }
        final Property property = Property.create();
        MDialog mDialog = new MDialog(window, UI._("Select an Icon"), n2){

            @Override
            protected void onUserClick() {
                String string;
                MIcon mIcon;
                File file = MIconChooser.browse(this, this.getTitle());
                if (file != null && (mIcon = MIcon.fromFileURI(string = FS.toURL(file).toString(), MIcon.getUISize())) != null) {
                    IconItem iconItem = new IconItem(mIcon);
                    iconItem.setValue(string);
                    property.set(iconItem);
                    this.reject();
                }
            }
        };
        if (flags.isSet(1L)) {
            mDialog.changeButton((AbstractButton)mDialog.getUserButton(), UI._("Browse..."), "ui/image");
        }
        MIconChooser mIconChooser = new MIconChooser((List)list){

            @Override
            protected void onSelect() {
                MDialog mDialog = (MDialog)this.getWindowAncestor();
                mDialog.accept();
            }
        };
        if (flags.isSet(2L)) {
            iconItem = new IconItem(null, UI._("Default Icon"));
            mIconChooser.allIcons.add(0, iconItem);
            mIconChooser.updateIconList(null);
        }
        mDialog.addCenter(mIconChooser);
        mDialog.setSize(UI.WindowSize.MEDIUM);
        if (mDialog.exec(mIconChooser.searchPanel)) {
            return mIconChooser.iconList.getSelectedItem();
        }
        iconItem = property.isNull() ? null : (IconItem)property.get();
        property.set(null);
        return iconItem;
    }

    public static IconItem fromStock(Window window) {
        return MIconChooser.fromList(window, MIconChooser.getStockIcons(), 0);
    }

    public static IconItem fromStock(Window window, int n) {
        return MIconChooser.fromList(window, MIconChooser.getStockIcons(), n);
    }

    public static List<IconItem> getStockIcons() {
        ArrayList<IconItem> arrayList = new ArrayList<IconItem>(100);
        InputStream inputStream = MIconChooser.class.getResourceAsStream("/images/stock-index.txt");
        if (inputStream == null) {
            return arrayList;
        }
        try {
            String string = FS.read(inputStream, "UTF8");
            if (!TK.isEmpty(string)) {
                for (String string2 : TK.fastSplit(string, '\n')) {
                    String string3 = string2.startsWith("./") ? string2.substring(2) : string2;
                    IconItem iconItem = new IconItem(MIcon.stock(string3));
                    iconItem.setValue(string3);
                    String string4 = new File(string3).getName();
                    int n = string4.indexOf(".png");
                    if (n != -1) {
                        string4 = string4.substring(0, n);
                    }
                    iconItem.setText(string4);
                    arrayList.add(iconItem);
                }
            }
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
        }
        return arrayList;
    }

    protected void onSelect() {
    }

    protected void updateIconList(String string) {
        if (TK.isEmpty(string)) {
            this.iconList.filter(this.searchPanel, this.allIcons, null);
        } else {
            this.iconList.filter(this.searchPanel, this.allIcons, (RowFilter<List<IconItem>, Integer>)new MList.Filter<IconItem, String>(string){

                @Override
                public boolean include(IconItem iconItem) {
                    return TK.containsIgnoreCase((String)iconItem.value, (String)this.filter);
                }
            });
        }
        if (!this.iconList.isEmpty()) {
            this.iconList.setSelectedIndex(0);
        }
    }

    public static final class IconItem
    extends Item<String> {
        public IconItem(Icon icon) {
            this(icon, (String)null);
        }

        public IconItem(Icon icon, String string) {
            this.setIcon(icon);
            this.setText(string);
        }
    }
}

