/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.View;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MDocumentAdapter;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MText;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;

public class MHighlighter<T extends JTextComponent>
extends DefaultHighlighter {
    public static final Color DEFAULT_COLOR = new Color(0xFFFFB3);
    public static final Color ERROR_COLOR = new Color(0xFFB3B3);
    public static final Color OK_COLOR = new Color(14286771);
    public static final Color SEARCH_COLOR = DEFAULT_COLOR;
    public static final Color WARNING_COLOR = new Color(16767411);
    private boolean disableIfSelection = true;
    private Insets padding = UI.createInsets(0);
    private List<Object> userHighlights;

    public Highlighter.HighlightPainter addHighlight(int n, Color color) {
        return this.addHighlight(n, n + 1, color, false);
    }

    public Highlighter.HighlightPainter addHighlight(int n, Color color, boolean bl) {
        return this.addHighlight(n, n + 1, color, bl);
    }

    public Highlighter.HighlightPainter addHighlight(int n, int n2, Color color) {
        return this.addHighlight(n, n2, color, false);
    }

    public Highlighter.HighlightPainter addHighlight(int n, int n2, Color color, boolean bl) {
        try {
            DefaultHighlighter.DefaultHighlightPainter defaultHighlightPainter;
            if (bl) {
                RoundedPainter roundedPainter = new RoundedPainter(color);
                roundedPainter.padding = this.padding;
                defaultHighlightPainter = roundedPainter;
            } else {
                defaultHighlightPainter = new DefaultHighlighter.DefaultHighlightPainter(color);
            }
            if (this.userHighlights == null) {
                this.userHighlights = new ArrayList<Object>();
            }
            this.userHighlights.add(this.addHighlight(n, n2, defaultHighlightPainter));
            return defaultHighlightPainter;
        }
        catch (BadLocationException badLocationException) {
            MLogger.exception(badLocationException);
            return null;
        }
    }

    public boolean getDisableIfSelection() {
        return this.disableIfSelection;
    }

    public void setDisableIfSelection(boolean bl) {
        this.disableIfSelection = bl;
    }

    public static <T extends JTextComponent> MHighlighter<T> install(T t, UserHighlight<T> userHighlight) {
        MHighlighter<T> mHighlighter = new MHighlighter<T>();
        StaticHandler staticHandler = new StaticHandler(t, userHighlight, null);
        t.addCaretListener(staticHandler);
        t.getDocument().addDocumentListener(staticHandler);
        t.setHighlighter(mHighlighter);
        MHighlighter.update(t, userHighlight);
        return mHighlighter;
    }

    public void removeUserHighlights() {
        if (this.userHighlights != null) {
            for (Object object : this.userHighlights) {
                this.removeHighlight(object);
            }
            this.userHighlights = null;
        }
    }

    public static boolean removeUserHighlights(JTextComponent jTextComponent) {
        Highlighter highlighter = jTextComponent.getHighlighter();
        if (highlighter instanceof MHighlighter) {
            MHighlighter mHighlighter = (MHighlighter)highlighter;
            mHighlighter.removeUserHighlights();
            return true;
        }
        return false;
    }

    public void setPadding(int n) {
        this.padding.set(n, n, n, n);
    }

    public static <T extends JTextComponent> void update(T t, UserHighlight<T> userHighlight) {
        if (MHighlighter.removeUserHighlights(t)) {
            MHighlighter mHighlighter = (MHighlighter)t.getHighlighter();
            if (mHighlighter.disableIfSelection && MText.hasSelection(t)) {
                return;
            }
            String string = MText.getPlainText(t);
            if (TK.isEmpty(string)) {
                return;
            }
            userHighlight.highlight(mHighlighter, t, string);
        }
    }

    static class 1 {
    }

    private static final class StaticHandler<T extends JTextComponent>
    extends MDocumentAdapter<T>
    implements CaretListener {
        private UserHighlight<T> userHighlight;

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            this.doUpdate();
        }

        @Override
        protected void onChange(DocumentEvent documentEvent) {
            this.doUpdate();
        }

        private StaticHandler(T t, UserHighlight<T> userHighlight) {
            super(t);
            this.userHighlight = userHighlight;
        }

        private void doUpdate() {
            Object t = this.getTextComponent();
            if (t != null) {
                MHighlighter.update(t, this.userHighlight);
            }
        }

        /* synthetic */ StaticHandler(JTextComponent jTextComponent, UserHighlight userHighlight, 1 var3_3) {
            this(jTextComponent, userHighlight);
        }
    }

    public static interface UserHighlight<T extends JTextComponent> {
        public void highlight(MHighlighter<T> var1, T var2, String var3);
    }

    public static class RoundedPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        private Insets padding;

        public RoundedPainter(Color color) {
            super(color);
        }

        @Override
        public Shape paintLayer(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent, View view) {
            try {
                Shape shape2 = view.modelToView(n, Position.Bias.Forward, n2, Position.Bias.Backward, shape);
                if (shape2 instanceof Rectangle) {
                    Color color = this.getColor();
                    Color color2 = jTextComponent.getBackground();
                    if (MColor.isDark(color2)) {
                        color = MColor.deriveColor(color, 0.6f);
                    }
                    Graphics2D graphics2D = (Graphics2D)graphics;
                    Rectangle rectangle = new Rectangle((Rectangle)shape2);
                    Object object = UI.setAntialiasing(graphics2D, true);
                    if (rectangle.x > 5) {
                        --rectangle.x;
                    } else {
                        --rectangle.width;
                    }
                    --rectangle.height;
                    if (this.padding != null) {
                        rectangle.grow(this.padding.left, this.padding.top);
                    }
                    graphics2D.setColor(color);
                    graphics2D.fillRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 8, 8);
                    graphics2D.setColor(MColor.deriveColor(color, 0.95f));
                    graphics2D.drawRoundRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 8, 8);
                    graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object);
                    return rectangle;
                }
                return null;
            }
            catch (BadLocationException badLocationException) {
                MLogger.exception(badLocationException);
                return null;
            }
        }
    }
}

