/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Window;
import java.io.IOException;
import java.net.URL;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import org.makagiga.commons.FS;
import org.makagiga.commons.FileCache;
import org.makagiga.commons.MDialog;
import org.makagiga.commons.MFormat;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MProgressBar;
import org.makagiga.commons.MTextLabel;
import org.makagiga.commons.Net;
import org.makagiga.commons.UI;

public class MDownloadDialog
extends MDialog
implements FS.ProgressListener {
    protected IOException error;
    protected MLabel descriptionLabel;
    protected MProgressBar progressBar;
    protected MTextLabel toTextLabel;
    protected Net.DownloadInfo info;
    protected volatile transient SwingWorker<Object, Object> worker;
    private boolean cancelled;
    private boolean toSet;

    @Deprecated
    public MDownloadDialog(Window window, URL uRL, String string, int n) throws IOException {
        this(window, new Net.DownloadInfo(uRL, string, n));
    }

    public MDownloadDialog(Window window, final Net.DownloadInfo downloadInfo) throws IOException {
        super(window, UI._("Downloading..."), "ui/download", 5);
        this.info = downloadInfo;
        MPanel mPanel = MPanel.createVBoxPanel();
        this.descriptionLabel = new MLabel();
        this.descriptionLabel.setStyle("margin-bottom: 5");
        this.descriptionLabel.setVisible(false);
        mPanel.add(this.descriptionLabel);
        String string = downloadInfo.getURL().toString();
        MTextLabel mTextLabel = new MTextLabel(string);
        mTextLabel.setToolTipText(string);
        mPanel.add(MPanel.createHLabelPanel(mTextLabel, UI._("From:")));
        mPanel.addGap();
        this.toTextLabel = new MTextLabel(UI._("<unknown>"));
        mPanel.add(MPanel.createHLabelPanel(this.toTextLabel, UI._("To:")));
        this.addNorth(mPanel);
        this.progressBar = new MProgressBar();
        this.progressBar.setIndeterminate(true);
        this.progressBar.setString("");
        this.progressBar.setStringPainted(true);
        this.addCenter(this.progressBar);
        this.worker = new SwingWorker<Object, Object>(){

            @Override
            public Object doInBackground() throws Exception {
                downloadInfo.setProgressListener(MDownloadDialog.this);
                downloadInfo.startDownload();
                return null;
            }

            @Override
            protected void done() {
                MDownloadDialog.this.worker = null;
                if (this.isCancelled()) {
                    MDownloadDialog.this.cancelled = true;
                    downloadInfo.cancelDownload();
                    MDownloadDialog.this.reject();
                } else {
                    try {
                        this.get();
                        MDownloadDialog.this.accept();
                    }
                    catch (Exception exception) {
                        if (exception.getCause() instanceof IOException) {
                            MDownloadDialog.this.error = (IOException)exception.getCause();
                        } else {
                            MMessage.error((Window)MDownloadDialog.this, exception);
                        }
                        FileCache.getInstance().removeItem(downloadInfo.getURL());
                        MDownloadDialog.this.reject();
                    }
                }
            }
        };
    }

    public static void download(Window window, Net.DownloadInfo downloadInfo) throws IOException {
        MDownloadDialog mDownloadDialog = new MDownloadDialog(window, downloadInfo);
        mDownloadDialog.packFixed();
        mDownloadDialog.exec();
        if (mDownloadDialog.error != null) {
            throw mDownloadDialog.error;
        }
        if (mDownloadDialog.cancelled) {
            throw new CancelException();
        }
        if (mDownloadDialog.info.getFile() == null) {
            throw new IOException(UI._("Download failed"));
        }
    }

    @Deprecated
    public static Net.DownloadInfo download(Window window, URL uRL, String string, int n) throws IOException {
        return MDownloadDialog.download(window, null, uRL, string, n);
    }

    @Deprecated
    public static Net.DownloadInfo download(Window window, String string, URL uRL, String string2, int n) throws IOException {
        MDownloadDialog mDownloadDialog = new MDownloadDialog(window, uRL, string2, n);
        mDownloadDialog.setDescription(string);
        mDownloadDialog.packFixed();
        mDownloadDialog.exec();
        if (mDownloadDialog.error != null) {
            throw mDownloadDialog.error;
        }
        if (mDownloadDialog.info == null) {
            return null;
        }
        if (mDownloadDialog.info.getFile() == null) {
            return null;
        }
        return mDownloadDialog.info;
    }

    @Override
    public boolean exec(JComponent jComponent) {
        if (this.worker != null) {
            this.worker.execute();
        }
        return super.exec(jComponent);
    }

    public void setDescription(String string) {
        this.descriptionLabel.setText(string);
        this.descriptionLabel.setVisible(string != null);
    }

    @Override
    public boolean updateProgress(final long l, final long l2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (l2 == -1L) {
                    MDownloadDialog.this.progressBar.setIndeterminate(true);
                } else if (l > l2) {
                    MDownloadDialog.this.progressBar.setIndeterminate(true);
                    MDownloadDialog.this.progressBar.setString(UI._("Unpacking..."));
                } else {
                    MDownloadDialog.this.progressBar.setIndeterminate(false);
                    MDownloadDialog.this.progressBar.setMaximum((int)l2);
                    MDownloadDialog.this.progressBar.setValue((int)l);
                    MDownloadDialog.this.progressBar.setString(MFormat.toAutoSize(l) + " / " + MFormat.toAutoSize(l2));
                }
                if (!MDownloadDialog.this.toSet) {
                    MDownloadDialog.this.toSet = true;
                    String string = MDownloadDialog.this.info.getDestinationFile() == null ? MDownloadDialog.this.info.getFile().getPath() : MDownloadDialog.this.info.getDestinationFile().getPath();
                    MDownloadDialog.this.toTextLabel.setText(string);
                    MDownloadDialog.this.toTextLabel.setToolTipText(string);
                }
            }
        });
        return true;
    }

    @Override
    protected void onClose() {
        if (this.worker != null) {
            this.worker.cancel(true);
            this.worker = null;
        }
    }

    @Override
    protected boolean onReject() {
        if (this.worker != null) {
            this.worker.cancel(true);
            this.worker = null;
        }
        return true;
    }

    public static final class CancelException
    extends IOException {
        private CancelException() {
            super(UI._("Download cancelled"));
        }
    }
}

