/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MBorderLayout;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MButtonPanel;
import org.makagiga.commons.MFrame;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLinkButton;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MSizeGrip;
import org.makagiga.commons.MSplashScreen;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.MURLButton;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.Mnemonic;
import org.makagiga.commons.TK;
import org.makagiga.commons.TriBoolean;
import org.makagiga.commons.UI;
import org.makagiga.commons.WindowDragAdapter;
import org.makagiga.commons.fx.Reflection;
import org.makagiga.commons.help.Help;
import org.makagiga.commons.help.HelpContext;
import org.makagiga.commons.mods.Mods;
import org.makagiga.commons.validator.ValidatorMessage;
import org.makagiga.commons.validator.ValidatorSupport;

public class MDialog
extends JDialog
implements MBorderLayout {
    public static final int CANCEL_BUTTON = 1;
    public static final int OK_BUTTON = 2;
    public static final int MODAL = 4;
    public static final int USER_BUTTON = 8;
    public static final int URL_BUTTON = 16;
    public static final int LINK_BUTTON = 16;
    public static final int CLOSE_BUTTON = 32;
    public static final int NO_SPECIAL_EFFECTS = 64;
    public static final int FORCE_STANDARD_BORDER = 64;
    public static final int SIDE_BUTTONS = 128;
    public static final int HELP_BUTTON = 256;
    @Deprecated
    public static final int FORCE_CUSTOM_BORDER = 512;
    public static final int APPLY_BUTTON = 1024;
    public static final int CACHED = 2048;
    public static final int NO_DEBUG = 4096;
    @Deprecated
    public static final int CONTENT_MARGIN = 10;
    public static final int SIMPLE_DIALOG = 36;
    public static final int STANDARD_DIALOG = 7;
    public static final String MOD_CLOSE = "close@org.makagiga.commons.MDialog";
    public static final String MOD_EXEC = "exec@org.makagiga.commons.MDialog";
    private boolean closed;
    private boolean code;
    private boolean customBorder;
    private final Dimension screenSize;
    private Flags flags;
    private HelpContext helpContext;
    private MAction acceptAction;
    private MAction helpAction;
    private MAction rejectAction;
    private MButton applyButton;
    private MButton cancelButton;
    private MButton helpButton;
    private MButton okButton;
    private MButton userButton;
    private MButtonPanel okCancelPanel;
    private MLabel titleLabel;
    private MLinkButton linkButton;
    private MPanel buttonsPanel;
    private MPanel contentPane;
    private MPanel mainPanel;
    private MPanel titlePanel;
    private MSizeGrip sizeGrip;
    private MWhatsThis whatsThis;
    private Point defaultLocation;
    private StaticDialogHandler staticDialogHandler;
    private ValidatorMessage validatorMessage;
    private final ValidatorSupport validatorSupport = new ValidatorSupport();
    private WeakReference<JComponent> defaultFocusRef;
    private WeakReference<MToolBar> toolBarRef;
    Mnemonic mnemonic = new Mnemonic();

    public MDialog(Window window, String string) {
        this(window, string, (Icon)null, 7);
    }

    public MDialog(Window window, String string, int n) {
        this(window, string, (Icon)null, n);
    }

    public MDialog(Window window, String string, Icon icon) {
        this(window, string, icon, 7);
    }

    public MDialog(Window window, String string, String string2) {
        this(window, string, MIcon.stock(string2), 7);
    }

    public MDialog(Window window, String string, Icon icon, int n) {
        super(MDialog.checkOwner(window));
        if ((n & 0x20) != 0) {
            n |= 2;
        }
        this.flags = new Flags(n);
        if (MLogger.isDeveloper() && this.flags.isClear(4096L)) {
            boolean bl = false;
            boolean bl2 = false;
            for (Window window2 : Window.getWindows()) {
                if (window2 == this) continue;
                bl2 = true;
                break;
            }
            if (window == null && bl2) {
                MLogger.warning("core", "No window ancestor for \"%s\" dialog", string);
                bl = true;
            }
            if (!SwingUtilities.isEventDispatchThread()) {
                MLogger.warning("core", "EDT rule violation: \"%s\"", string);
                bl = true;
            }
            if (bl) {
                MLogger.trace(15);
            }
        }
        this.screenSize = UI.getScreenSize();
        this.init(string, icon);
    }

    public MDialog(Window window, String string, String string2, int n) {
        this(window, string, MIcon.stock(string2), n);
    }

    public MDialog(Window window, MActionInfo mActionInfo, int n) {
        this(window, mActionInfo.getDialogTitle(), mActionInfo.getIcon(), n);
    }

    public MDialog(Window window, MActionInfo mActionInfo) {
        this(window, mActionInfo.getDialogTitle(), mActionInfo.getIcon());
    }

    public final boolean accept() {
        return this.done(true);
    }

    public void changeButton(AbstractButton abstractButton, MActionInfo mActionInfo) {
        this.changeButton(abstractButton, mActionInfo.getText(), mActionInfo.getIconName());
    }

    public void changeButton(AbstractButton abstractButton, String string) {
        abstractButton.setText(string);
        this.updateMnemonic(abstractButton);
    }

    public void changeButton(AbstractButton abstractButton, String string, Icon icon) {
        if (((Boolean)UI.buttonIcons.get()).booleanValue()) {
            abstractButton.setIcon(icon);
        }
        abstractButton.setText(string);
        this.updateMnemonic(abstractButton);
    }

    public void changeButton(AbstractButton abstractButton, String string, String string2) {
        this.changeButton(abstractButton, string, MIcon.stock(string2));
    }

    public boolean exec() {
        return this.exec(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exec(JComponent jComponent) {
        if (this.defaultFocusRef == null) {
            this.defaultFocusRef = jComponent == null ? null : new WeakReference<JComponent>(jComponent);
        }
        MMenu.hideCurrentPopup();
        MSplashScreen.close();
        Dimension dimension = this.getSize();
        Container container = this.getParent();
        if (this.defaultLocation != null) {
            this.setLocation(this.defaultLocation);
        } else if (container != null && container.getSize().equals(dimension)) {
            this.setLocation(container.getX() + 10, container.getY() + 10);
        } else {
            this.setLocationRelativeTo(container);
        }
        Dimension dimension2 = new Dimension(Math.min(this.screenSize.width, dimension.width), Math.min(this.screenSize.height, dimension.height));
        if (!dimension2.equals(dimension)) {
            this.setSize(dimension2);
            if (this.defaultLocation == null) {
                this.setLocationRelativeTo(container);
            }
        }
        if (!this.isResizable() && MLogger.isDeveloper() && this.customBorder && (this.getWidth() > 800 || this.getHeight() > 600)) {
            MLogger.warning("core", "Non-resizable dialog is larger than 800x600: \"%s\"", this.getTitle());
        }
        Mods.exec(this, MOD_EXEC, new Object[0]);
        this.validatorSupport.validate(this);
        if (this.isModal() && container instanceof MDialog) {
            MDialog mDialog = (MDialog)container;
            Component component = mDialog.getFocusOwner();
            if (component instanceof JRootPane) {
                component = null;
            }
            TriBoolean triBoolean = this.disableButton(mDialog.getApplyButton());
            TriBoolean triBoolean2 = this.disableButton(mDialog.getCancelButton());
            TriBoolean triBoolean3 = this.disableButton(mDialog.getHelpButton());
            TriBoolean triBoolean4 = this.disableButton(mDialog.getOKButton());
            TriBoolean triBoolean5 = this.disableButton(mDialog.getURLButton());
            TriBoolean triBoolean6 = this.disableButton(mDialog.getUserButton());
            try {
                this.setVisible(true);
            }
            finally {
                this.enableButton(mDialog.getApplyButton(), triBoolean);
                this.enableButton(mDialog.getCancelButton(), triBoolean2);
                this.enableButton(mDialog.getHelpButton(), triBoolean3);
                this.enableButton(mDialog.getOKButton(), triBoolean4);
                this.enableButton(mDialog.getURLButton(), triBoolean5);
                this.enableButton(mDialog.getUserButton(), triBoolean6);
                if (component != null) {
                    component.requestFocusInWindow();
                }
            }
        } else {
            this.setVisible(true);
        }
        return this.code;
    }

    public MButton getApplyButton() {
        return this.applyButton;
    }

    public MPanel getButtonsPanel() {
        return this.buttonsPanel;
    }

    public MButton getCancelButton() {
        return this.cancelButton;
    }

    public MPanel getCenterPanel() {
        return this.getMainPanel();
    }

    public MButton getHelpButton() {
        return this.helpButton;
    }

    public HelpContext getHelpContext() {
        return this.helpContext;
    }

    public void setHelpContext(HelpContext helpContext) {
        this.helpContext = helpContext;
        if (this.helpButton != null) {
            if (this.helpContext == null || this.helpContext.getType() != HelpContext.Type.URI) {
                this.helpButton.setToolTipText(MActionInfo.HELP.getText());
            } else {
                this.helpButton.setToolTipText(MURLButton.getLinkToolTipText(this.helpContext.getID()));
            }
        }
    }

    public MButton getOKButton() {
        return this.okButton;
    }

    public MLabel getTitleLabel() {
        return this.titleLabel;
    }

    public MPanel getTitlePanel() {
        return this.titlePanel;
    }

    public MToolBar getToolBar() {
        return this.toolBarRef == null ? null : (MToolBar)this.toolBarRef.get();
    }

    public void setToolBar(MToolBar mToolBar) {
        this.toolBarRef = TK.newWeakRef(mToolBar);
        mToolBar.setOpaque(false);
        if (mToolBar.getOrientation() == 0) {
            if (this.titlePanel != null) {
                if (this.customBorder) {
                    this.titlePanel.setMargin(0, 0, 10, 0);
                }
                this.titlePanel.addSouth(mToolBar);
            } else {
                this.addNorth(mToolBar);
            }
        } else {
            this.addEast(mToolBar);
        }
    }

    public MLinkButton getLinkButton() {
        return this.linkButton;
    }

    public MURLButton getURLButton() {
        return this.linkButton;
    }

    public MButton getUserButton() {
        return this.userButton;
    }

    @Deprecated
    public ValidatorMessage getValidatorMessage() {
        return this.validatorMessage;
    }

    public void setValidatorMessage(ValidatorMessage validatorMessage) {
        this.validatorMessage = validatorMessage;
        if (validatorMessage != null) {
            validatorMessage.setVisible(false);
        }
    }

    public ValidatorSupport getValidatorSupport() {
        return this.validatorSupport;
    }

    public ValidatorMessage installValidatorMessage() {
        ValidatorMessage validatorMessage = new ValidatorMessage();
        this.setValidatorMessage(validatorMessage);
        this.getLayeredPane().add((Component)validatorMessage, JLayeredPane.POPUP_LAYER);
        return this.validatorMessage;
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void packFixed() {
        this.pack();
        this.setResizable(false);
    }

    public void packFixed(int n) {
        Dimension dimension = new Dimension(n, this.getHeight());
        this.setMaximumSize(dimension);
        this.setMinimumSize(dimension);
        this.packFixed();
    }

    public void packFixed(UI.WindowSize windowSize) {
        this.packFixed(windowSize.getDimension().width);
    }

    public final void reject() {
        this.done(false);
    }

    public void removeContentMargin() {
        MPanel mPanel = this.getMainPanel();
        if ((this.customBorder || UI.isSeaGlass()) && this.flags.isClear(128L) && (UI.isNimbus() || UI.isSeaGlass() || UI.isSubstance())) {
            int n = UI.isSubstance() ? 10 : 0;
            mPanel.setMargin(n, 0, 10, 0);
        }
    }

    public void setDefault(JButton jButton) {
        jButton.setDefaultCapable(true);
        this.getRootPane().setDefaultButton(jButton);
    }

    public void setDefaultFocus(JComponent jComponent) {
        this.defaultFocusRef = new WeakReference<JComponent>(jComponent);
    }

    public void setDefaultLocation(Point point) {
        this.defaultLocation = point == null ? null : new Point(point);
    }

    public void setHeight(int n) {
        this.setSize(this.getWidth(), n);
    }

    @Override
    public void setResizable(boolean bl) {
        super.setResizable(bl);
        if (this.sizeGrip != null) {
            this.sizeGrip.setVisible(this.isResizable());
        }
    }

    public void setSize(UI.WindowSize windowSize) {
        this.setSize(windowSize.getDimension());
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl && MApplication.forceRTL && !this.isVisible()) {
            this.applyComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
        }
        super.setVisible(bl);
    }

    public void setWidth(int n) {
        this.setSize(n, this.getHeight());
    }

    public void updateMnemonic(AbstractButton abstractButton) {
        this.mnemonic.update(abstractButton);
    }

    @Override
    public void addCenter(JComponent jComponent) {
        if (jComponent instanceof JTabbedPane) {
            this.removeContentMargin();
        }
        UI.addCenter(this.getMainPanel(), jComponent);
    }

    @Override
    public void addEast(JComponent jComponent) {
        this.getMainPanel().add((Component)jComponent, "After");
    }

    @Override
    public void addNorth(JComponent jComponent) {
        this.getMainPanel().add((Component)jComponent, "First");
    }

    @Override
    public void addSouth(JComponent jComponent) {
        this.getMainPanel().add((Component)jComponent, "Last");
    }

    @Override
    public void addWest(JComponent jComponent) {
        this.getMainPanel().add((Component)jComponent, "Before");
    }

    protected void applyMnemonic(Container container) {
        this.mnemonic.apply(container);
    }

    protected void bind(int n, Action action) {
        MAction.connect((JComponent)this.contentPane, n, action);
    }

    protected void bind(int n, int n2, Action action) {
        MAction.connect(this.contentPane, n, n2, action);
    }

    protected boolean done(boolean bl) {
        this.code = bl;
        if (this.code) {
            if (!this.onAccept()) {
                return false;
            }
        } else {
            if (this.cancelButton != null && !this.cancelButton.isEnabled()) {
                return false;
            }
            if (!this.onReject()) {
                return false;
            }
        }
        this.onClose();
        this.closed = true;
        Mods.exec(this, MOD_CLOSE, new Object[0]);
        this.dispose();
        if (this.flags.isSet(2048L)) {
            return true;
        }
        this.validatorSupport.removeAll();
        this.uninstallComponents();
        return true;
    }

    protected MPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = MPanel.createBorderPanel(5);
            if (this.customBorder) {
                int n = UI.isSubstance() ? 10 : 0;
                this.mainPanel.setMargin(n, 10, 10, 10);
            } else {
                this.mainPanel.setContentMargin();
            }
            this.mainPanel.setOpaque(false);
            this.add((Component)this.mainPanel, "Center");
        }
        return this.mainPanel;
    }

    protected boolean onAccept() {
        return true;
    }

    protected void onClose() {
    }

    protected void onHelpClick() {
        if (Help.show(this, this.helpContext)) {
            return;
        }
        if (this.whatsThis == null) {
            this.whatsThis = new MWhatsThis(this);
            this.setGlassPane(this.whatsThis);
            this.whatsThis.setVisible(true);
        } else {
            MFrame.clearGlassPane(this);
            this.whatsThis = null;
        }
    }

    protected void onLinkClick() {
        this.onURLClick();
    }

    protected boolean onReject() {
        return true;
    }

    protected void onURLClick() {
        if (this.linkButton != null) {
            this.linkButton.doOpen();
        }
    }

    protected void onUserClick() {
    }

    @Deprecated
    protected void setCancelButton(MButton mButton) {
        this.cancelButton = mButton;
    }

    @Deprecated
    protected void setOKButton(MButton mButton) {
        this.okButton = mButton;
    }

    private static Window checkOwner(Window window) {
        return window instanceof Dialog || window instanceof Frame ? window : null;
    }

    private TriBoolean disableButton(MButton mButton) {
        TriBoolean triBoolean;
        TriBoolean triBoolean2 = triBoolean = mButton == null ? TriBoolean.UNDEFINED : TriBoolean.from(mButton.isEnabled());
        if (triBoolean.isTrue()) {
            mButton.setEnabled(false);
        }
        return triBoolean;
    }

    private void doCancel() {
        if (this.cancelButton != null && this.cancelButton.isEnabled() && this.cancelButton.isVisible()) {
            this.cancelButton.doClick();
        } else {
            this.reject();
        }
    }

    private boolean doClick(MButton mButton) {
        if (mButton != null && mButton.hasFocus() && mButton.isEnabled() && mButton.isVisible()) {
            mButton.doClick();
            return true;
        }
        return false;
    }

    private void enableButton(MButton mButton, TriBoolean triBoolean) {
        if (triBoolean.isTrue()) {
            mButton.setEnabled(true);
        }
    }

    private void init(String string, Icon icon) {
        this.setDefaultCloseOperation(0);
        this.setModal(this.flags.isSet(4L));
        Dimension dimension = new Dimension(64, 64);
        this.setMinimumSize(dimension);
        this.setSize(dimension);
        this.setTitle(string);
        this.contentPane = MPanel.createBorderPanel();
        this.setBackground(this.contentPane.getBackground());
        this.setContentPane(this.contentPane);
        if (this.flags.isSet(2L) || this.flags.isSet(1L) || this.flags.isSet(1024L)) {
            Serializable serializable;
            this.buttonsPanel = this.flags.isSet(128L) ? MPanel.createVBoxPanel() : MPanel.createHBoxPanel();
            this.buttonsPanel.setOpaque(false);
            if (this.flags.isSet(256L)) {
                this.helpButton = new MButton(){

                    @Override
                    protected void onClick() {
                        MDialog mDialog = (MDialog)this.getWindowAncestor();
                        mDialog.onHelpClick();
                    }
                };
                if (UI.isMac()) {
                    this.helpButton.setText("?");
                    this.helpButton.putClientProperty("JButton.buttonType", "help");
                } else if (UI.isQuaqua()) {
                    this.helpButton.setText("?");
                    this.helpButton.putClientProperty("Quaqua.Button.style", "help");
                } else if (((Boolean)UI.buttonIcons.get()).booleanValue()) {
                    this.helpButton.setIconName(MActionInfo.HELP.getIconName());
                } else {
                    this.helpButton.setText("?");
                }
                this.helpButton.setToolTipText(MActionInfo.HELP.getText());
                this.buttonsPanel.add(this.helpButton);
            }
            if (this.flags.isSet(8L)) {
                this.userButton = new MButton(){

                    @Override
                    protected void onClick() {
                        MDialog mDialog = (MDialog)this.getWindowAncestor();
                        mDialog.onUserClick();
                    }
                };
                if (this.flags.isSet(256L)) {
                    this.buttonsPanel.addContentGap();
                }
                this.buttonsPanel.add(this.userButton);
            }
            if (this.flags.isSet(16L)) {
                this.linkButton = new MLinkButton(){

                    @Override
                    protected void onClick() {
                        MDialog mDialog = (MDialog)this.getWindowAncestor();
                        mDialog.onLinkClick();
                    }
                };
                if (this.flags.isSet(256L) || this.flags.isSet(8L)) {
                    this.buttonsPanel.addContentGap();
                }
                this.buttonsPanel.add(this.linkButton);
            }
            if (this.flags.isSet(2L)) {
                this.okButton = new MButton(){

                    @Override
                    protected void onClick() {
                        MDialog mDialog = (MDialog)this.getWindowAncestor();
                        if (mDialog != null) {
                            mDialog.accept();
                        }
                    }
                };
                this.okButton.setMinimumWidth(100);
                if (this.flags.isSet(32L)) {
                    this.okButton.setIconNameUI("ui/close");
                    this.okButton.setText(this.mnemonic.apply(this.okButton, UI._("&Close")));
                } else {
                    this.okButton.setIconNameUI("ui/ok");
                    this.okButton.setText(this.mnemonic.apply(this.okButton, UI._("&OK")));
                }
            }
            if (this.flags.isSet(1L)) {
                if (UI.isRetro()) {
                    this.cancelButton = new MButton(){

                        @Override
                        protected void onClick() {
                            MDialog mDialog = (MDialog)this.getWindowAncestor();
                            if (mDialog != null) {
                                mDialog.reject();
                            }
                        }
                    };
                    this.cancelButton.setIconNameUI("ui/cancel");
                } else {
                    this.cancelButton = new MURLButton(){

                        @Override
                        protected void onClick() {
                            MDialog mDialog = (MDialog)this.getWindowAncestor();
                            if (mDialog != null) {
                                mDialog.reject();
                            }
                        }
                    };
                    this.cancelButton.setHorizontalAlignment(0);
                }
                this.cancelButton.setText(this.mnemonic.apply(this.cancelButton, UI._("&Cancel")));
            }
            if (this.flags.isSet(1024L)) {
                this.applyButton = new MButton(){

                    @Override
                    protected void onClick() {
                        MDialog mDialog = (MDialog)this.getWindowAncestor();
                        mDialog.onAccept();
                    }
                };
                this.applyButton.setIconNameUI("ui/apply");
                this.applyButton.setText(this.mnemonic.apply(this.applyButton, UI._("&Apply")));
            }
            int n = this.flags.isSet(128L) ? 2 : 1;
            this.okCancelPanel = new MButtonPanel(n, this.okButton, this.applyButton, this.cancelButton);
            if (this.okCancelPanel.getPainter() == null) {
                this.okCancelPanel.setMargin(0);
            }
            if (this.cancelButton instanceof MURLButton) {
                serializable = UI.getForeground(this.okCancelPanel);
                MURLButton mURLButton = (MURLButton)this.cancelButton;
                mURLButton.setLinkColor((Color)serializable);
                mURLButton.setHoverLinkColor((Color)serializable);
            }
            serializable = MPanel.createBorderPanel(10);
            if (this.flags.isSet(128L)) {
                ((MPanel)serializable).setMargin(10, 0, 10, 10);
            } else {
                ((MPanel)serializable).setContentMargin();
            }
            ((JComponent)serializable).setOpaque(false);
            if (this.flags.isSet(128L)) {
                ((MPanel)serializable).addNorth(this.buttonsPanel);
                ((MPanel)serializable).addSouth(this.okCancelPanel);
            } else {
                ((MPanel)serializable).addWest(this.buttonsPanel);
                ((MPanel)serializable).addEast(this.okCancelPanel);
            }
            this.add((Component)serializable, this.flags.isSet(128L) ? "After" : "Last");
            if (this.flags.isSet(2L)) {
                this.setDefault(this.okButton);
            }
        }
        this.installComponents();
        this.titlePanel = MPanel.createBorderPanel();
        this.titlePanel.setOpaque(false);
        this.add((Component)this.titlePanel, "First");
        if (this.flags.isClear(64L) && !UI.isSeaGlass()) {
            this.customBorder = true;
            UI.setStyle("border-style: outset", this.getRootPane());
            this.setUndecorated(true);
            this.initTitle(icon);
            this.titlePanel.addNorth(this.titleLabel);
            this.sizeGrip = new MSizeGrip(this);
            this.sizeGrip.setVisible(this.isResizable());
            this.getLayeredPane().add((Component)this.sizeGrip, JLayeredPane.DEFAULT_LAYER + 1);
            this.sizeGrip.moveToCorner();
        }
    }

    private void initTitle(Icon icon) {
        boolean bl = this.screenSize.height < 768;
        this.titleLabel = new MLabel(this.getTitle());
        this.titleLabel.setIconTextGap(10);
        String string = "font-size: x-large; font-weight: bold";
        string = string + "; margin: " + (bl ? 5 : 10);
        if (icon != null) {
            if (!bl && icon instanceof ImageIcon && ((ImageIcon)ImageIcon.class.cast(icon)).getImage() != null) {
                Reflection reflection = new Reflection();
                reflection.setBlur(true);
                reflection.setGradientAlpha(0.6f);
                reflection.setReflectionSize(0.5f);
                this.titleLabel.setIcon(reflection.createIcon((ImageIcon)icon));
            } else {
                this.titleLabel.setIcon(icon);
            }
        }
        this.titleLabel.setStyle(string);
        new WindowDragAdapter(this.titleLabel);
    }

    private void installComponents() {
        this.acceptAction = new MAction("MDialog.accept"){

            @Override
            public void onAction() {
                MDialog mDialog = (MDialog)this.getSourceWindow();
                if (mDialog.doClick(mDialog.applyButton)) {
                    return;
                }
                if (mDialog.doClick(mDialog.cancelButton)) {
                    return;
                }
                if (mDialog.doClick(mDialog.okButton)) {
                    return;
                }
                if (mDialog.doClick(mDialog.userButton)) {
                    return;
                }
                if (mDialog.doClick(mDialog.linkButton)) {
                    return;
                }
                if (mDialog.doClick(mDialog.helpButton)) {
                    return;
                }
                if (mDialog.okButton == null) {
                    mDialog.accept();
                } else {
                    mDialog.okButton.doClick();
                }
            }
        };
        this.bind(1, 10, this.acceptAction);
        this.rejectAction = new MAction("MDialog.reject"){

            @Override
            public void onAction() {
                MDialog mDialog = (MDialog)this.getSourceWindow();
                mDialog.doCancel();
            }
        };
        this.bind(1, 27, this.rejectAction);
        this.helpAction = new MAction("MDialog.help"){

            @Override
            public void onAction() {
                MDialog mDialog = (MDialog)this.getSourceWindow();
                if (mDialog.helpButton != null) {
                    mDialog.helpButton.doClick();
                } else {
                    mDialog.onHelpClick();
                }
            }
        };
        this.bind(2, 112, this.helpAction);
        this.staticDialogHandler = new StaticDialogHandler();
        this.addComponentListener(this.staticDialogHandler);
        this.addPropertyChangeListener(this.staticDialogHandler);
        this.addWindowListener(this.staticDialogHandler);
    }

    private void uninstallComponents() {
        if (this.contentPane != null) {
            if (this.acceptAction != null) {
                this.acceptAction.disconnect(this.contentPane, 1);
                this.acceptAction = null;
            }
            if (this.rejectAction != null) {
                this.rejectAction.disconnect(this.contentPane, 1);
                this.rejectAction = null;
            }
            if (this.helpAction != null) {
                this.helpAction.disconnect(this.contentPane, 2);
                this.helpAction = null;
            }
            this.contentPane = null;
        }
        this.buttonsPanel = null;
        this.mainPanel = null;
        this.sizeGrip = null;
        this.titlePanel = null;
        if (this.staticDialogHandler != null) {
            this.removeComponentListener(this.staticDialogHandler);
            this.removePropertyChangeListener(this.staticDialogHandler);
            this.removeWindowListener(this.staticDialogHandler);
            this.staticDialogHandler = null;
        }
        if (this.okCancelPanel != null) {
            this.okCancelPanel.removeAll();
            this.okCancelPanel = null;
        }
        this.applyButton = null;
        this.cancelButton = null;
        this.helpButton = null;
        this.linkButton = null;
        this.okButton = null;
        this.userButton = null;
        if (this.whatsThis != null) {
            MFrame.clearGlassPane(this);
            this.whatsThis = null;
        }
    }

    private static final class StaticDialogHandler
    extends WindowAdapter
    implements ComponentListener,
    PropertyChangeListener {
        private StaticDialogHandler() {
        }

        @Override
        public void componentHidden(ComponentEvent componentEvent) {
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
        }

        @Override
        public void componentResized(ComponentEvent componentEvent) {
            MDialog mDialog = (MDialog)componentEvent.getSource();
            if (mDialog.sizeGrip != null) {
                mDialog.sizeGrip.moveToCorner();
            }
        }

        @Override
        public void componentShown(ComponentEvent componentEvent) {
            MDialog mDialog = (MDialog)componentEvent.getSource();
            mDialog.mnemonic.apply(mDialog);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            MDialog mDialog = (MDialog)propertyChangeEvent.getSource();
            if (mDialog.titleLabel != null && "title".equals(propertyChangeEvent.getPropertyName())) {
                mDialog.titleLabel.setText(propertyChangeEvent.getNewValue() == null ? null : propertyChangeEvent.getNewValue().toString());
            }
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
            MDialog mDialog = (MDialog)windowEvent.getSource();
            if (mDialog.defaultFocusRef != null) {
                JComponent jComponent = (JComponent)mDialog.defaultFocusRef.get();
                if (jComponent != null) {
                    UI.requestFocus(jComponent);
                }
                mDialog.defaultFocusRef.clear();
                mDialog.defaultFocusRef = null;
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            MDialog mDialog = (MDialog)windowEvent.getSource();
            mDialog.doCancel();
        }
    }
}

