/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.ConstructorProperties;
import java.io.Serializable;
import java.text.DateFormatSymbols;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.FocusManager;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.makagiga.commons.CoolHeader;
import org.makagiga.commons.ItemStatus;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MApplication;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MButton;
import org.makagiga.commons.MCalendar;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MDataAction;
import org.makagiga.commons.MDate;
import org.makagiga.commons.MDateSpinner;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.MLineBorder;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.MRenderer;
import org.makagiga.commons.MSmallButton;
import org.makagiga.commons.MTimer;
import org.makagiga.commons.Mnemonic;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.ValueListener;
import org.makagiga.commons.it.I;
import org.makagiga.commons.swing.ValueChooser;
import org.makagiga.commons.transition.MoveTransition;
import org.makagiga.commons.transition.Transition;
import org.makagiga.commons.transition.TransitionPanel;

public class MCalendarPanel
extends MPanel
implements ValueChooser<Date> {
    private boolean animationEnabled = true;
    private boolean clearTime = true;
    private transient boolean inUpdate;
    private transient boolean sameMonthAndYear;
    private final Border defaultBorder = UI.createEmptyBorder(2);
    private final Border selectedBorder;
    private final Border todayBorder = BorderFactory.createLineBorder(MColor.RED, 2);
    private CoolHeader infoLabel;
    private static Font monthMenuItemFont;
    private int lastAutoUpdateDay = -1;
    private transient int selectedDay;
    private transient int todayDay;
    private static List<MCalendarPanel> calendarPanelList;
    private final MArrayList<DayButton> dayButtons = new MArrayList(31);
    private MCalendar calendar;
    private MDateSpinner dateSpinner;
    private MPanel daysPanel;
    private MSmallButton monthMenuButton;
    private MSmallButton todayButton;
    private MTimer autoUpdateTimer;
    private static Renderer globalRenderer;
    private Renderer renderer;
    private TransitionPanel transitionPanel;
    private static Updater globalUpdater;

    public MCalendarPanel() {
        this(MDate.now());
    }

    @ConstructorProperties(value={"selectedDate"})
    public MCalendarPanel(Date date) {
        Color color = MApplication.getLightBrandColor();
        this.selectedBorder = BorderFactory.createLineBorder(color, 2);
        this.setBackground(Color.WHITE);
        this.setMargin(5);
        this.calendar = MCalendar.now();
        int n = this.calendar.getFirstDayOfWeek();
        if (n != 2 && n != 1) {
            this.calendar.setFirstDayOfWeek(2);
        }
        this.infoLabel = new CoolHeader(MIcon.stock("ui/calendar"));
        this.infoLabel.setColor(color, Color.BLACK);
        this.infoLabel.setCursor(12);
        this.infoLabel.setTextAntialiasing(true);
        this.infoLabel.setToolTipText(UI._("Today"));
        this.infoLabel.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                if (MAction.isTrigger(keyEvent)) {
                    MCalendarPanel.this.setTodayDate();
                    MCalendarPanel.this.doUserUpdate();
                    keyEvent.consume();
                }
            }
        });
        this.infoLabel.addMouseListener(new MMouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                MCalendarPanel.this.setTodayDate();
                MCalendarPanel.this.doUserUpdate();
                mouseEvent.consume();
            }
        });
        this.addNorth(this.infoLabel);
        this.addCenter(this.createMainPanel());
        if (date != null) {
            this.setSelectedDate(date);
        }
    }

    public void addMonth(int n) {
        Date date = this.getSelectedDate();
        this.calendar.add(2, n);
        this.update(date, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addNotify() {
        super.addNotify();
        Class<MCalendarPanel> clazz = MCalendarPanel.class;
        synchronized (MCalendarPanel.class) {
            calendarPanelList.add(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNotify() {
        super.removeNotify();
        Class<MCalendarPanel> clazz = MCalendarPanel.class;
        synchronized (MCalendarPanel.class) {
            calendarPanelList.remove(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized List<MCalendarPanel> getCalendarPanelList() {
        return Collections.unmodifiableList(calendarPanelList);
    }

    public boolean getClearTime() {
        return this.clearTime;
    }

    public void setClearTime(boolean bl) {
        this.clearTime = bl;
    }

    public int getMonth() {
        return this.calendar.getMonth();
    }

    public void setMonth(int n) {
        if (n != this.getMonth()) {
            Date date = this.getSelectedDate();
            this.calendar.setMonth(n);
            this.update(date, false);
        }
    }

    @Override
    public void addValueListener(ValueListener<Date> valueListener) {
        this.listenerList.add(ValueListener.class, valueListener);
    }

    @Override
    public ValueListener<Date>[] getValueListeners() {
        return (ValueListener[])this.listenerList.getListeners(ValueListener.class);
    }

    @Override
    public void removeValueListener(ValueListener<Date> valueListener) {
        this.listenerList.remove(ValueListener.class, valueListener);
    }

    public Calendar getCalendar() {
        if (this.clearTime) {
            MDate.clearTime(this.calendar);
        }
        return this.calendar;
    }

    public MDateSpinner getDateSpinner() {
        return this.dateSpinner;
    }

    public MPanel getDaysPanel() {
        return this.daysPanel;
    }

    public static Renderer getGlobalRenderer() {
        return globalRenderer;
    }

    public static void setGlobalRenderer(Renderer renderer) {
        globalRenderer = renderer;
    }

    public static Updater getGlobalUpdater() {
        return globalUpdater;
    }

    public static void setGlobalUpdater(Updater updater) {
        globalUpdater = updater;
    }

    public CoolHeader getInfoLabel() {
        return this.infoLabel;
    }

    public Renderer getRenderer() {
        return this.renderer;
    }

    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    public Date getSelectedDate() {
        return new MDate(this.getCalendar());
    }

    public void setSelectedDate(Date date) {
        Date date2 = this.getSelectedDate();
        this.calendar.setTime(TK.checkNull(date, "value"));
        this.lastAutoUpdateDay = this.calendar.get(5);
        this.update(date2, false);
    }

    public boolean getShowInfo() {
        return this.infoLabel.isVisible();
    }

    public void setShowInfo(boolean bl) {
        this.infoLabel.setVisible(bl);
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setAnimationEnabled(boolean bl) {
        this.animationEnabled = bl;
    }

    public boolean isAutoUpdate() {
        return this.autoUpdateTimer != null;
    }

    public void setAutoUpdate(boolean bl) {
        if (bl) {
            if (this.autoUpdateTimer == null) {
                this.autoUpdateTimer = new MTimer(MTimer.Format.MINUTES, 1){

                    @Override
                    protected boolean onTimeout() {
                        MCalendarPanel.this.doAutoUpdate();
                        return true;
                    }
                };
                this.autoUpdateTimer.start();
            }
        } else if (this.autoUpdateTimer != null) {
            this.autoUpdateTimer.stop();
            this.autoUpdateTimer = null;
        }
    }

    public boolean isMonthMenuButtonVisible() {
        return this.monthMenuButton.isVisible();
    }

    public void setMonthMenuButtonVisible(boolean bl) {
        this.monthMenuButton.setVisible(bl);
    }

    public boolean isTodayButtonVisible() {
        return this.todayButton.isVisible();
    }

    public void setTodayButtonVisible(boolean bl) {
        this.todayButton.setVisible(bl);
    }

    public void setTodayDate() {
        this.setSelectedDate(MDate.now());
    }

    public void updateRenderer(int n, int n2) {
        int n3 = 0;
        for (DayButton dayButton : this.dayButtons) {
            this.applyRenderer(dayButton, n, n2 + 1, ++n3);
        }
    }

    @Override
    public Date getValue() {
        return this.getSelectedDate();
    }

    @Override
    public void setValue(Date date) {
        this.setSelectedDate(date);
    }

    protected void fireValueChanged(Date date, Date date2, ValueChangeReason valueChangeReason) {
        TK.fireValueChanged(this, this.getValueListeners(), date, date2, (Object)valueChangeReason);
    }

    protected MMenu onClick(int n) {
        return null;
    }

    protected void onUserUpdate() {
    }

    private void applyRenderer(DayButton dayButton, int n, int n2, int n3) {
        this.applyRenderer(globalRenderer, this.calendar, dayButton, n, n2, n3);
        this.applyRenderer(this.renderer, this.calendar, dayButton, n, n2, n3);
    }

    private void applyRenderer(Renderer renderer, Calendar calendar, DayButton dayButton, int n, int n2, int n3) {
        if (renderer == null) {
            return;
        }
        renderer.day = n3;
        renderer.month = n2;
        renderer.year = n;
        renderer.onRender(calendar);
        boolean bl = this.selectedDay == n3;
        boolean bl2 = this.todayDay == n3 && this.sameMonthAndYear;
        MLabel mLabel = renderer.getLabel();
        if (mLabel.isBackgroundSet()) {
            dayButton.setBackground(mLabel.getBackground());
        } else if (bl) {
            dayButton.setBackground(MApplication.getLightBrandColor());
        } else {
            dayButton.setBackground(Color.WHITE);
        }
        if (mLabel.isForegroundSet()) {
            dayButton.setForeground(mLabel.getForeground());
        } else {
            dayButton.setForeground(MColor.BLACK);
        }
        Border border = bl ? this.selectedBorder : (bl2 ? this.todayBorder : this.defaultBorder);
        dayButton.setBorder(border);
        if (mLabel.isFontSet()) {
            dayButton.setFont(mLabel.getFont());
        } else if (bl2) {
            dayButton.setStyle("font-style: italic; font-weight: bold");
        } else {
            dayButton.setFont(null);
        }
        dayButton.setIcon(mLabel.getIcon());
        dayButton.setToolTipText(mLabel.getToolTipText());
        if (TK.isEmpty(dayButton.getToolTipText())) {
            if (bl2) {
                dayButton.setToolTipText(UI._("Today"));
            } else if (bl) {
                dayButton.setToolTipText(UI._("Selected Date"));
            } else {
                dayButton.setToolTipText(null);
            }
        }
    }

    private MPanel createHeaderPanel() {
        MPanel mPanel = MPanel.createBorderPanel();
        mPanel.setMargin(5);
        mPanel.setOpaque(false);
        this.todayButton = new MSmallButton(MActionInfo.CURRENT_DATE_AND_TIME.getSmallIcon(), UI._("Today")){

            @Override
            protected void onClick() {
                MCalendarPanel.this.setTodayDate();
                MCalendarPanel.this.doUserUpdate();
            }
        };
        mPanel.addWest(this.todayButton);
        this.dateSpinner = new MDateSpinner(false);
        this.dateSpinner.setSimpleFormat("MMMM yyyy");
        this.dateSpinner.setToolTipText(UI._("Date"));
        this.dateSpinner.addChangeListener(new ChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (!MCalendarPanel.this.inUpdate) {
                    try {
                        MCalendarPanel.this.inUpdate = true;
                        MCalendarPanel.this.setSelectedDate(MCalendarPanel.this.dateSpinner.getSelectedDate());
                        MCalendarPanel.this.doUserUpdate();
                    }
                    finally {
                        MCalendarPanel.this.inUpdate = false;
                    }
                }
            }
        });
        mPanel.addCenter(this.dateSpinner);
        MPanel mPanel2 = MPanel.createHBoxPanel();
        mPanel2.setOpaque(false);
        MSmallButton mSmallButton = new MSmallButton(MIcon.small("ui/previous"), UI._("Previous Month")){

            @Override
            protected void onClick() {
                MCalendarPanel.this.addMonth(-1);
                MCalendarPanel.this.doUserUpdate();
            }
        };
        mPanel2.add(mSmallButton);
        this.monthMenuButton = new MSmallButton(MIcon.small("ui/down"), UI._("Select a Month")){

            @Override
            protected MMenu onPopupMenu() {
                return MCalendarPanel.this.createMonthMenu();
            }
        };
        this.monthMenuButton.setPopupMenuArrowPainted(false);
        this.monthMenuButton.setPopupMenuEnabled(true);
        mPanel2.add(this.monthMenuButton);
        MSmallButton mSmallButton2 = new MSmallButton(MIcon.small("ui/next"), UI._("Next Month")){

            @Override
            protected void onClick() {
                MCalendarPanel.this.addMonth(1);
                MCalendarPanel.this.doUserUpdate();
            }
        };
        mPanel2.add(mSmallButton2);
        mPanel.addEast(mPanel2);
        mPanel.limitHeight(this.dateSpinner);
        return mPanel;
    }

    private MPanel createMainPanel() {
        MPanel mPanel = MPanel.createBorderPanel();
        mPanel.setOpaque(false);
        mPanel.addNorth(this.createHeaderPanel());
        MPanel mPanel2 = MPanel.createBorderPanel();
        mPanel2.setOpaque(false);
        MPanel mPanel3 = MPanel.createGridPanel(1, 8);
        mPanel3.add(new EmptyCell());
        mPanel3.setOpaque(false);
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance();
        String[] stringArray = dateFormatSymbols.getShortWeekdays();
        String[] stringArray2 = dateFormatSymbols.getWeekdays();
        if (this.calendar.getFirstDayOfWeek() == 2) {
            Label label;
            for (int i = 2; i < stringArray.length; ++i) {
                label = new Label(stringArray[i]);
                label.setToolTipText(stringArray2[i]);
                mPanel3.add(label);
            }
            label = new Label(stringArray[1]);
            label.setToolTipText(stringArray2[1]);
            mPanel3.add(label);
        } else {
            for (int i = 1; i < stringArray.length; ++i) {
                Label label = new Label(stringArray[i]);
                label.setToolTipText(stringArray2[i]);
                mPanel3.add(label);
            }
        }
        mPanel2.addNorth(mPanel3);
        this.daysPanel = new MPanel(null){

            @Override
            public void setComponentOrientation(ComponentOrientation componentOrientation) {
                super.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
            }
        };
        Mnemonic.setExcluded(this.daysPanel, true);
        this.daysPanel.setBackground(Color.WHITE);
        this.daysPanel.setOpaque(true);
        this.transitionPanel = new TransitionPanel();
        mPanel2.addCenter(this.transitionPanel);
        mPanel.addCenter(mPanel2);
        return mPanel;
    }

    private MMenu createMonthMenu() {
        MMenu mMenu = new MMenu();
        DateFormatSymbols dateFormatSymbols = DateFormatSymbols.getInstance();
        int n = this.getMonth();
        for (I<String> i : I.of(dateFormatSymbols.getMonths())) {
            if (TK.isEmpty(i.v())) continue;
            int n2 = i.i() + 1;
            mMenu.addRadioButton(new MonthAction(i.toString(), n2), n2 == n);
        }
        return mMenu;
    }

    private void doAutoUpdate() {
        if (MMenu.getCurrentPopup() != null) {
            return;
        }
        MDate mDate = MDate.now();
        int n = mDate.getCalendar().get(5);
        if (n != this.lastAutoUpdateDay) {
            MLogger.debug("calendar", "Auto update");
            Date date = this.getSelectedDate();
            this.setSelectedDate(mDate);
            this.fireValueChanged(date, this.getSelectedDate(), ValueChangeReason.AUTO_UPDATE);
            this.doUserUpdate();
        }
    }

    private void doUserUpdate() {
        if (globalUpdater != null) {
            globalUpdater.onUpdate(this);
        }
        this.onUserUpdate();
    }

    private void update(Date date, boolean bl) {
        int n;
        Serializable serializable;
        int n2;
        MCalendar mCalendar = MCalendar.now();
        mCalendar.setFirstDayOfWeek(this.calendar.getFirstDayOfWeek());
        mCalendar.setTime(date);
        if (this.daysPanel.getComponentCount() > 0 && mCalendar.isSameDate(this.calendar) && !mCalendar.isSameTime(this.calendar, false)) {
            this.updateDateSpinner();
            return;
        }
        Component component = FocusManager.getCurrentManager().getFocusOwner();
        int n3 = n2 = component instanceof DayButton ? ((DayButton)DayButton.class.cast(component)).day : -1;
        if (bl) {
            this.requestFocusInWindow();
        }
        int n4 = this.calendar.get(1);
        int n5 = this.getMonth() - 1;
        MCalendar mCalendar2 = MCalendar.now();
        mCalendar2.setFirstDayOfWeek(this.calendar.getFirstDayOfWeek());
        boolean bl2 = this.animationEnabled && this.calendar.get(2) != mCalendar.get(2);
        this.sameMonthAndYear = mCalendar2.get(2) == n5 && mCalendar2.get(1) == n4;
        Date date2 = this.getSelectedDate();
        this.transitionPanel.removeAll();
        if (bl2 && this.daysPanel.getWidth() > 0 && this.daysPanel.getHeight() > 0) {
            serializable = new MLabel(MComponent.createScreenshot(this.daysPanel, MColor.WHITE));
            this.transitionPanel.add((Component)serializable, "old");
        }
        this.daysPanel.removeAll();
        this.daysPanel.setLayout(new GridLayout(6, 8));
        serializable = new GregorianCalendar(n4, n5, 1);
        ((Calendar)serializable).setFirstDayOfWeek(this.calendar.getFirstDayOfWeek());
        int n6 = this.calendar.getFirstDayOfWeek() == 1 ? 1 : 0;
        switch (((Calendar)serializable).get(7)) {
            case 2: {
                break;
            }
            case 3: {
                ++n6;
                break;
            }
            case 4: {
                n6 += 2;
                break;
            }
            case 5: {
                n6 += 3;
                break;
            }
            case 6: {
                n6 += 4;
                break;
            }
            case 7: {
                n6 += 5;
                break;
            }
            case 1: {
                n6 += 6;
            }
        }
        int n7 = this.calendar.getActualMaximum(5);
        int n8 = 1;
        int n9 = 1;
        int n10 = ((Calendar)serializable).get(3);
        WeekLabel weekLabel = new WeekLabel(n10);
        this.daysPanel.add(weekLabel);
        if (n6 == 0 || n6 == 7) {
            for (n = 0; n < 7; ++n) {
                this.daysPanel.add(new EmptyCell());
            }
            n8 = 1;
            ++n9;
            weekLabel.setText(null);
        } else {
            for (n = 0; n < n6; ++n) {
                this.daysPanel.add(new EmptyCell());
                ++n8;
            }
        }
        this.selectedDay = this.calendar.getDay();
        this.todayDay = mCalendar2.getDay();
        this.dayButtons.clear();
        for (n = 1; n <= n7; ++n) {
            if (n8 == 1) {
                n10 = new GregorianCalendar(n4, n5, n).get(3);
                this.daysPanel.add(new WeekLabel(n10));
            }
            DayButton dayButton = new DayButton(n, n9 - 1);
            this.dayButtons.add(dayButton);
            this.daysPanel.add(dayButton);
            if (bl && n2 != -1 && n2 == n) {
                dayButton.requestFocusInWindow();
            }
            if (n8 == 7) {
                n8 = 1;
                ++n9;
                continue;
            }
            ++n8;
        }
        while (n9 < 7) {
            this.daysPanel.add(new EmptyCell());
            if (n8 == 7) {
                n8 = 1;
                ++n9;
                continue;
            }
            ++n8;
        }
        this.updateDateSpinner();
        MDate mDate = MDate.now();
        String string = UI.isRTL(this.infoLabel) ? "<font size=\"+1\">{1}</font>&nbsp;&nbsp;<font size=\"+10\">{0}</font>" : "<font size=\"+10\">{0}</font>&nbsp;&nbsp;<font size=\"+1\">{1}</font>";
        this.infoLabel.setHTML("<b>" + MessageFormat.format(string, mDate.format("d"), mDate.format("EEEE")) + "</b>");
        UI.setStyle("margin: 2", this.dayButtons.toArray(DayButton.class));
        this.updateRenderer(n4, n5);
        this.daysPanel.validate();
        this.transitionPanel.add((Component)this.daysPanel, "new");
        this.validate();
        this.repaint();
        this.fireValueChanged(date, date2, ValueChangeReason.UPDATE);
        if (!bl2) {
            this.transitionPanel.setTransition(Transition.NO_TRANSITION);
            this.transitionPanel.showCard("new");
        } else {
            if (globalUpdater != null) {
                globalUpdater.onUpdate(this);
            }
            this.transitionPanel.setTransition(new MoveTransition(date2.after(date) ? MoveTransition.Direction.LEFT : MoveTransition.Direction.RIGHT));
            this.transitionPanel.showNextCard();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDateSpinner() {
        if (!this.inUpdate) {
            try {
                this.inUpdate = true;
                this.dateSpinner.setSelectedDate(this.calendar.getTime());
            }
            finally {
                this.inUpdate = false;
            }
        }
    }

    static {
        calendarPanelList = MArrayList.create();
    }

    private static final class WeekLabel
    extends Label {
        private WeekLabel(int n) {
            super(Integer.toString(n), false, MLineBorder.Position.RIGHT);
            this.setToolTipText(UI._("Week: {0}", this.getText()));
        }
    }

    private static final class SeparatorBorder
    extends MLineBorder {
        private SeparatorBorder(MLineBorder.Position position) {
            super(position);
            this.getStyle(position).setColor(MColor.getDarker(MColor.WHITE));
        }
    }

    private final class MonthAction
    extends MDataAction<Integer> {
        @Override
        public void onAction() {
            MCalendarPanel.this.setMonth((Integer)this.getData());
            MCalendarPanel.this.doUserUpdate();
        }

        private MonthAction(String string, int n) {
            super(Integer.valueOf(n), string);
            if (monthMenuItemFont == null) {
                monthMenuItemFont = new Font("Dialog", 1, UI.getDefaultFontSize());
            }
            int n2 = monthMenuItemFont.getSize();
            ItemStatus.Icon icon = new ItemStatus.Icon(Integer.toString(n), UI.getBackground(MCalendarPanel.this.infoLabel), new Dimension(n2 * 2, n2 + 2), monthMenuItemFont);
            this.setSmallIcon(icon);
        }
    }

    private static class Label
    extends MLabel {
        private Label(String string) {
            this(string, true, MLineBorder.Position.BOTTOM);
        }

        private Label(String string, boolean bl, MLineBorder.Position position) {
            super(string);
            Font font = UI.getFont(this);
            this.setFont(font.deriveFont(bl ? 1 : 0, font.getSize() - 1));
            this.setHorizontalAlignment(0);
            this.setBorder(new SeparatorBorder(position));
            this.setOpaque(true);
            this.setBackground(MColor.WHITE);
            this.setForeground(Color.BLACK);
        }
    }

    private static final class EmptyCell
    extends MLabel {
        private EmptyCell() {
            this.setBackground(Color.WHITE);
            this.setOpaque(true);
        }
    }

    private final class DayButton
    extends MButton {
        private final int day;
        private final int row;

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(32, this.getFont().getSize() + 4);
        }

        @Override
        public void setBackground(Color color) {
            Color color2 = color;
            if (color2 != null && this.row % 2 != 0) {
                color2 = MColor.getDarker(color2);
            }
            super.setBackground(color2);
        }

        @Override
        public void updateUI() {
            this.setUI(UI.getSimpleButtonUI());
        }

        @Override
        protected void onClick() {
            if (this.day == 0) {
                return;
            }
            Date date = MCalendarPanel.this.getSelectedDate();
            MCalendarPanel.this.calendar.set(5, this.day);
            MCalendarPanel.this.update(date, true);
            MCalendarPanel.this.doUserUpdate();
            MMenu mMenu = MCalendarPanel.this.onClick(this.day);
            if (mMenu != null) {
                DayButton dayButton = (DayButton)MCalendarPanel.this.dayButtons.get(this.day - 1);
                mMenu.showPopup((Component)dayButton.getParent(), dayButton);
            }
        }

        private DayButton(int n, int n2) {
            this.day = n;
            this.row = n2;
            this.setCursor(12);
            this.setOpaque(true);
            if (n == 0) {
                this.setText("");
            } else {
                this.setText(Integer.toString(n));
            }
            this.addMouseListener(new MMouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    DayButton.this.setPopupMenuArrowPainted(true);
                    DayButton.this.setPopupMenuEnabled(true);
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    DayButton.this.setPopupMenuArrowPainted(false);
                    DayButton.this.setPopupMenuEnabled(false);
                }

                @Override
                public void popupTrigger(MouseEvent mouseEvent) {
                    TK.fireActionPerformed(DayButton.this, DayButton.this.getActionListeners());
                }
            });
        }
    }

    public static abstract class Updater {
        protected abstract void onUpdate(MCalendarPanel var1);
    }

    public static abstract class Renderer
    extends MRenderer<Calendar> {
        private int day;
        private int month;
        private int year;

        public int getDay() {
            return this.day;
        }

        public int getMonth() {
            return this.month;
        }

        public int getYear() {
            return this.year;
        }

        public void setSpecialColor(Color color, Color color2) {
            MLabel mLabel = this.getLabel();
            mLabel.setBackground(color);
            mLabel.setForeground(color2);
        }

        protected abstract void onRender();

        @Override
        protected final void onRender(Calendar calendar) {
            MLabel mLabel = this.getLabel();
            mLabel.setBackground(null);
            mLabel.setForeground(null);
            mLabel.setFont(null);
            mLabel.setIcon(null);
            mLabel.setToolTipText(null);
            this.onRender();
        }
    }

    public static enum ValueChangeReason {
        AUTO_UPDATE,
        UPDATE;

    }
}

