/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Container;
import java.awt.GridLayout;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.FocusManager;
import org.makagiga.commons.Flags;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.MPanel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.painters.GlassPainter;

public class MButtonPanel
extends MPanel {
    public static final int HORIZONTAL = 1;
    public static final int VERTICAL = 2;
    public static final int NO_REVERSE = 4;
    private boolean vertical;
    private static KeyAdapter keyAdapter;

    public MButtonPanel(int n, AbstractButton ... abstractButtonArray) {
        super(null);
        if (TK.isEmpty(abstractButtonArray)) {
            throw new IllegalArgumentException("\"buttons\" array is null or empty");
        }
        MArrayList<AbstractButton> mArrayList = MArrayList.create(abstractButtonArray.length);
        for (AbstractButton abstractButton : abstractButtonArray) {
            if (abstractButton == null) continue;
            mArrayList.add(abstractButton);
        }
        Flags flags = new Flags(n);
        this.vertical = flags.isSet(2L);
        if (this.vertical) {
            this.setLayout(new GridLayout(mArrayList.size(), 1, 0, 15));
        } else {
            this.setLayout(new GridLayout(1, mArrayList.size(), 15, 0));
        }
        if (UI.OKCancelLayout.isReversed() && flags.isClear(4L) && !this.vertical) {
            Collections.reverse(mArrayList);
        }
        for (AbstractButton abstractButton : mArrayList) {
            this.addButton(abstractButton);
        }
        this.setMargin(5);
        this.setOpaque(false);
        if (UI.isMetal() || UI.isNimbus()) {
            this.setPainter(new GlassPainter());
        }
        this.limitHeight();
    }

    private void addButton(AbstractButton abstractButton) {
        if (abstractButton != null) {
            if (keyAdapter == null) {
                keyAdapter = new StaticHandler();
            }
            this.add(abstractButton);
            abstractButton.addKeyListener(keyAdapter);
        }
    }

    private static void selectButton(KeyEvent keyEvent, boolean bl, boolean bl2) {
        AbstractButton abstractButton = (AbstractButton)keyEvent.getSource();
        Container container = abstractButton.getParent();
        if (container instanceof MButtonPanel) {
            if (((MButtonPanel)MButtonPanel.class.cast((Object)container)).vertical != bl2) {
                return;
            }
            FocusManager focusManager = FocusManager.getCurrentManager();
            if (bl) {
                focusManager.focusNextComponent();
            } else {
                focusManager.focusPreviousComponent();
            }
        }
    }

    private static final class StaticHandler
    extends KeyAdapter {
        private StaticHandler() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    MButtonPanel.selectButton(keyEvent, false, false);
                    break;
                }
                case 39: {
                    MButtonPanel.selectButton(keyEvent, true, false);
                    break;
                }
                case 38: {
                    MButtonPanel.selectButton(keyEvent, false, true);
                    break;
                }
                case 40: {
                    MButtonPanel.selectButton(keyEvent, true, true);
                }
            }
        }
    }
}

