/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import org.makagiga.commons.MColor;
import org.makagiga.commons.MComponent;
import org.makagiga.commons.MGraphics2D;
import org.makagiga.commons.TK;

public class ItemStatus
extends MComponent {
    private final Icon icon = new Icon();

    public ItemStatus(Font font) {
        this.setOpaque(false);
        this.icon.font = font.deriveFont(1, Math.max(10, font.getSize() - 1));
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        if (TK.isEmpty(this.icon.text)) {
            return new Dimension();
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.icon.font);
        Dimension dimension = new Dimension(fontMetrics.stringWidth(this.icon.text), fontMetrics.getHeight());
        int n = 2;
        dimension.width += n * 2;
        dimension.height += n * 2;
        return dimension;
    }

    public String getText() {
        return this.icon.text;
    }

    public void setText(String string) {
        if (TK.isChange(this.icon.text, string)) {
            this.icon.text = string;
            this.revalidate();
            this.repaint();
        }
    }

    public void setText(int n, Color color) {
        this.setText(Integer.toString(n), color);
    }

    public void setText(String string, Color color) {
        Color color2 = color;
        if (color2 == null) {
            color2 = MColor.WHITE;
        }
        color2 = MColor.deriveColor(color2, 0.98f);
        if (TK.isChange(this.icon.background, color2)) {
            this.icon.background = color2;
            this.icon.foreground = null;
            this.repaint();
        }
        this.setText(string);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.icon.size.setSize(this.getWidth(), this.getHeight());
        this.icon.paintIcon(this, graphics, 0, 0);
    }

    public static final class Icon
    implements javax.swing.Icon {
        private Color background;
        private Color foreground;
        private final Dimension size = new Dimension();
        private Font font;
        private String text;

        public Icon(String string, Color color, Dimension dimension, Font font) {
            this.text = string;
            this.background = color;
            this.size.setSize(dimension);
            this.font = TK.checkNull(font);
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            if (TK.isEmpty(this.text)) {
                return;
            }
            int n3 = this.getIconWidth();
            int n4 = this.getIconHeight();
            MGraphics2D mGraphics2D = new MGraphics2D(graphics);
            mGraphics2D.setAntialiasing(true);
            mGraphics2D.setTextAntialiasing(null);
            mGraphics2D.setColor(this.background);
            graphics.fillRoundRect(n, n2, n3, n4, 9, 9);
            if (this.foreground == null) {
                this.foreground = MColor.getContrast(this.background);
            }
            mGraphics2D.setColor(this.foreground);
            mGraphics2D.setFont(this.font);
            mGraphics2D.drawStringCentered(this.text, n, n2, n3, n4);
        }

        @Override
        public int getIconWidth() {
            return this.size.width;
        }

        @Override
        public int getIconHeight() {
            return this.size.height;
        }

        private Icon() {
        }
    }
}

