/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.text.ParseException;
import org.makagiga.commons.NumberProperty;
import org.makagiga.commons.PropertyAccess;

public class IntegerProperty
extends NumberProperty<Integer> {
    public IntegerProperty() {
        super(0);
    }

    public IntegerProperty(int n) {
        super(n);
    }

    public IntegerProperty(String string) throws ParseException {
        this.parse(string);
        this.setDefaultValue(this.get());
    }

    @Override
    public Class<Integer> getType() {
        return Integer.class;
    }

    public int normalize(int n, int n2) {
        return IntegerProperty.normalize(this, n, n2);
    }

    public static int normalize(PropertyAccess<Integer> propertyAccess, int n, int n2) {
        int n3 = propertyAccess.get();
        if (n3 < n || n3 > n2) {
            propertyAccess.reset();
        }
        return propertyAccess.get();
    }

    @Override
    public void parse(String string) throws ParseException {
        try {
            this.set(Integer.valueOf(string));
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException.getMessage(), 0);
        }
    }

    @Deprecated
    public String toHexString() {
        return Integer.toHexString((Integer)this.get());
    }
}

