/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import javax.swing.Icon;
import org.makagiga.commons.MHighlighter;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLabel;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.fx.Blend;
import org.makagiga.commons.painters.GlassPainter;
import org.makagiga.commons.painters.Painter;

public class CoolHeader
extends MLabel {
    private boolean backgroundPainted = true;
    private Direction direction = Direction.NONE;
    private FocusListener focusListener;
    private final GlassPainter painter = new GlassPainter();

    public CoolHeader() {
        this((String)null, (Icon)null);
    }

    public CoolHeader(Icon icon) {
        this(null, icon);
    }

    public CoolHeader(String string) {
        this(string, (Icon)null);
    }

    public CoolHeader(String string, Icon icon) {
        super(string, icon);
        this.setBorder(UI.createEmptyBorder(5));
        this.setIconTextGap(5);
    }

    public Color getColor() {
        return this.getBackground();
    }

    public void setColor(Color color, Color color2) {
        this.setColor(color, color2, false);
    }

    public void setColor(Color color, Color color2, boolean bl) {
        if (bl) {
            Blend.animateBackground(this, null, color == null ? UI.getColor("Label.background") : color);
        } else {
            this.setBackground(color);
        }
        this.setForeground(color2);
    }

    public Direction getDirection() {
        return this.direction;
    }

    public void setDirection(Direction direction) {
        if (direction != this.direction) {
            this.direction = direction;
            if (this.direction == Direction.NONE) {
                this.setIcon(null);
            } else {
                this.setIcon(MIcon.unscaled("ui/" + TK.toLowerCase(this.direction.name()) + "arrow"));
            }
        }
    }

    public Painter getPainter() {
        return this.painter;
    }

    public GlassPainter.RoundType getRoundType() {
        return this.painter.getRoundType();
    }

    public void setRoundType(GlassPainter.RoundType roundType) {
        if (TK.isChange((Object)this.painter.getRoundType(), (Object)roundType)) {
            this.painter.setRoundType(roundType);
            this.repaint();
        }
    }

    public boolean isBackgroundPainted() {
        return this.backgroundPainted;
    }

    public void setBackgroundPainted(boolean bl) {
        if (bl != this.backgroundPainted) {
            this.backgroundPainted = bl;
            this.repaint();
        }
    }

    @Override
    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.backgroundPainted) {
            this.painter.setPrimaryColor(this.getBackground());
            this.painter.paint(this, graphics2D);
        }
        super.paintComponent(graphics2D);
        if (this.isFocusOwner()) {
            UI.paintFocus(this, graphics2D, 1);
        }
    }

    public void setErrorMessage(String string) {
        this.setMessage(string, MIcon.medium("ui/error"), MHighlighter.ERROR_COLOR);
    }

    @Override
    public void setFocusable(boolean bl) {
        super.setFocusable(bl);
        if (this.focusListener != null) {
            this.removeFocusListener(this.focusListener);
            this.focusListener = null;
        }
        if (bl) {
            this.focusListener = new StaticFocusHandler();
            this.addFocusListener(this.focusListener);
        }
    }

    public void setInfoMessage(String string) {
        this.setMessage(string, MIcon.medium("ui/info"), Color.WHITE);
    }

    public void setMessage(String string, Icon icon, Color color) {
        this.setColor(color, Color.BLACK, true);
        this.setIcon(icon);
        this.setText(string);
    }

    public void setOKMessage(String string) {
        this.setMessage(string, MIcon.medium("ui/ok"), MHighlighter.OK_COLOR);
    }

    public void setWarningMessage(String string) {
        this.setMessage(string, MIcon.medium("ui/warning"), MHighlighter.WARNING_COLOR);
    }

    private static final class StaticFocusHandler
    implements FocusListener,
    Serializable {
        private StaticFocusHandler() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            CoolHeader coolHeader = (CoolHeader)focusEvent.getSource();
            coolHeader.repaint();
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            CoolHeader coolHeader = (CoolHeader)focusEvent.getSource();
            coolHeader.repaint();
        }
    }

    public static enum Direction {
        NONE,
        TOP,
        LEFT,
        BOTTOM,
        RIGHT;

    }
}

