/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.makagiga.commons.AbstractIterator;
import org.makagiga.commons.ContainerScanner;
import org.makagiga.commons.MArrayList;
import org.makagiga.commons.Property;

public class ContainerIterator<T extends Component>
extends AbstractIterator<T>
implements Iterable<T>,
Serializable {
    private final List<T> list;

    public ContainerIterator(Container container, Class<T> clazz) {
        int n = container.getComponentCount();
        this.list = new ArrayList<T>(n);
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Component component = container.getComponent(i);
                if (clazz != null && !clazz.isAssignableFrom(component.getClass())) continue;
                this.list.add(component);
            }
        }
    }

    public static <T extends Component> ContainerIterator<T> create(Container container, Class<T> clazz) {
        return new ContainerIterator<T>(container, clazz);
    }

    public static <T extends Component> List<T> findAll(Container container, final Class<T> clazz) {
        final MArrayList mArrayList = MArrayList.create();
        new ContainerScanner(container){

            @Override
            public void processComponent(Container container, Component component) {
                if (clazz == null || clazz.isAssignableFrom(component.getClass())) {
                    mArrayList.add(component);
                }
            }
        };
        return mArrayList;
    }

    public static Component findName(Container container, final String string) {
        final Property property = new Property();
        new ContainerScanner(container){

            @Override
            public void processComponent(Container container, Component component) {
                if (string.equals(component.getName())) {
                    property.set(component);
                    this.stop();
                }
            }
        };
        return (Component)property.get();
    }

    @Override
    public T getObjectAt(int n) {
        return (T)((Component)this.list.get(n));
    }

    @Override
    public int getObjectCount() {
        return this.list.size();
    }

    @Override
    public Iterator<T> iterator() {
        return this;
    }
}

