/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MDisposable;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MToggleButton;
import org.makagiga.commons.MToolBar;
import org.makagiga.commons.TK;
import org.makagiga.commons.WTFError;

public class ActionGroup
implements Iterable<Item>,
MDisposable,
Serializable {
    private int genericID;
    private final Map<String, Item> map = TK.newLinkedHashMap();
    private String groupID;
    private String groupName;

    public ActionGroup() {
    }

    public ActionGroup(String string, String string2) {
        this.groupID = TK.validateID(string);
        this.groupName = string2;
    }

    public Item add(String string, Action action) {
        TK.validateID(string);
        Item item = new Item(string, action, Type.ACTION);
        this.map.put(string, item);
        return item;
    }

    public Item addCheckBox(String string, Action action) {
        TK.validateID(string);
        Item item = new Item(string, action, Type.CHECK_BOX);
        this.map.put(string, item);
        return item;
    }

    public Item addSeparator() {
        Item item = new Item(null, null, Type.SEPARATOR);
        this.map.put(Type.SEPARATOR.name() + "." + this.genericID++, item);
        return item;
    }

    public Item addStretch() {
        Item item = new Item(null, null, Type.STRETCH);
        this.map.put(Type.STRETCH.name() + "." + this.genericID++, item);
        return item;
    }

    public void clear() {
        this.map.clear();
    }

    public void connect(String string, JComponent jComponent, int n) {
        MAction.connect(jComponent, n, this.getAction(string));
    }

    public void connect(String string, JComponent jComponent, String string2) {
        MAction.connect(jComponent, string2, this.getAction(string));
    }

    public void disconnect(String string, JComponent jComponent, int n) {
        Object t = this.getAction(string);
        if (!(t instanceof MAction)) {
            throw new IllegalArgumentException("\"MAction\" class expected: " + string);
        }
        ((MAction)MAction.class.cast(t)).disconnect(jComponent, n);
    }

    public MMenu createMenu() {
        MMenu mMenu = new MMenu();
        this.updateMenu(mMenu);
        return mMenu;
    }

    public MMenu createMenu(String string) {
        MMenu mMenu = new MMenu(string);
        this.updateMenu(mMenu);
        return mMenu;
    }

    public JPopupMenu createPopupMenu() {
        MMenu mMenu = this.createMenu();
        return mMenu.getPopupMenu();
    }

    public MToolBar createToolBar() {
        return this.createToolBar(0);
    }

    public MToolBar createToolBar(int n) {
        MToolBar mToolBar = new MToolBar(n);
        this.updateToolBar(mToolBar);
        return mToolBar;
    }

    public void fire(String string) {
        this.fire(string, MAction.NO_SOURCE);
    }

    public void fire(String string, Object object) {
        MAction.fire(this.getAction(string), object);
    }

    public <T extends Action> T getAction(String string) {
        return (T)this.map.get(string).action;
    }

    public Item getItem(String string) {
        return this.map.get(string);
    }

    public String getID() {
        return this.groupID;
    }

    public String getName() {
        return this.groupName;
    }

    public void setEnabled(boolean bl) {
        for (Item item : this) {
            if (item.action == null) continue;
            item.action.setEnabled(bl);
        }
    }

    public JPopupMenu installPopupMenu(JComponent jComponent) {
        JPopupMenu jPopupMenu = this.createPopupMenu();
        jComponent.setComponentPopupMenu(jPopupMenu);
        return jPopupMenu;
    }

    public boolean isEnabled(String string) {
        return this.getAction(string).isEnabled();
    }

    public void setEnabled(String string, boolean bl) {
        this.getAction(string).setEnabled(bl);
    }

    public boolean isSelected(String string) {
        return MAction.getValue(this.getAction(string), "SwingSelectedKey", false);
    }

    public void setSelected(String string, boolean bl) {
        this.getAction(string).putValue("SwingSelectedKey", bl);
    }

    public void update() {
    }

    public void updateMenu(MMenu mMenu) {
        block5: for (Item item : this) {
            if (!item.visibleInMenu) continue;
            switch (item.type) {
                case ACTION: {
                    mMenu.add(item.action);
                    continue block5;
                }
                case CHECK_BOX: {
                    mMenu.addCheckBox(item.action);
                    continue block5;
                }
                case SEPARATOR: 
                case STRETCH: {
                    mMenu.addSeparator();
                    continue block5;
                }
            }
            throw new WTFError(item.type);
        }
    }

    public void updateToolBar(MToolBar mToolBar) {
        block6: for (Item item : this) {
            if (!item.visibleInToolBar) continue;
            switch (item.type) {
                case ACTION: {
                    mToolBar.add(item.action, item.showTextInToolBar ? 1 : 0);
                    continue block6;
                }
                case CHECK_BOX: {
                    MToggleButton mToggleButton = new MToggleButton(item.action);
                    mToolBar.addButton(mToggleButton, item.showTextInToolBar ? 1 : 0);
                    continue block6;
                }
                case SEPARATOR: {
                    mToolBar.addSeparator();
                    continue block6;
                }
                case STRETCH: {
                    mToolBar.addStretch();
                    continue block6;
                }
            }
            throw new WTFError(item.type);
        }
    }

    @Override
    public Iterator<Item> iterator() {
        return this.map.values().iterator();
    }

    @Override
    public Object dispose(Object ... objectArray) {
        this.clear();
        return null;
    }

    public static final class Item
    implements Serializable {
        private final Action action;
        private boolean showTextInToolBar;
        private boolean visibleInMenu = true;
        private boolean visibleInToolBar = true;
        private final String id;
        private final Type type;

        public Action getAction() {
            return this.action;
        }

        public String getID() {
            return this.id;
        }

        public boolean getShowTextInToolBar() {
            return this.showTextInToolBar;
        }

        public void setShowTextInToolBar(boolean bl) {
            this.showTextInToolBar = bl;
        }

        public Type getType() {
            return this.type;
        }

        public boolean isVisibleInMenu() {
            return this.visibleInMenu;
        }

        public void setVisibleInMenu(boolean bl) {
            this.visibleInMenu = bl;
        }

        public boolean isVisibleInToolBar() {
            return this.visibleInToolBar;
        }

        public void setVisibleInToolBar(boolean bl) {
            this.visibleInToolBar = bl;
        }

        private Item(String string, Action action, Type type) {
            this.id = string;
            this.action = action;
            this.type = type;
        }
    }

    public static enum Type {
        ACTION,
        SEPARATOR,
        STRETCH,
        CHECK_BOX;

    }
}

