/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.Dimension;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerModel;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MText;
import org.makagiga.commons.UI;
import org.makagiga.commons.autocompletion.AutoCompletion;

public abstract class AbstractSpinner<M extends SpinnerModel, T>
extends JSpinner
implements MouseWheelListener,
MText.TextFieldExtensions,
UI.MouseWheelEventsControl {
    private boolean mouseWheelEventsEnabled = true;
    private int maximumWidth = -1;
    private JTextField textField;

    @Deprecated
    public AbstractSpinner() {
        this.addMouseWheelListener(this);
    }

    public AbstractSpinner(M m) {
        super((SpinnerModel)m);
        this.addMouseWheelListener(this);
    }

    public int getMaximumWidth() {
        return this.maximumWidth;
    }

    public void setMaximumWidth(int n) {
        if (n != this.maximumWidth) {
            this.maximumWidth = n;
            this.revalidate();
        }
    }

    @Override
    public Dimension getMaximumSize() {
        int n = this.maximumWidth == -1 ? super.getMaximumSize().width : this.maximumWidth;
        return new Dimension(n, this.getPreferredSize().height + 4);
    }

    public M getModel() {
        return (M)super.getModel();
    }

    @Override
    public boolean getMouseWheelEventsEnabled() {
        return this.mouseWheelEventsEnabled;
    }

    @Override
    public void setMouseWheelEventsEnabled(boolean bl) {
        this.mouseWheelEventsEnabled = bl;
    }

    public JTextField getTextField() {
        if (this.textField == null) {
            JComponent jComponent = this.getEditor();
            this.textField = jComponent instanceof JSpinner.DefaultEditor ? ((JSpinner.DefaultEditor)JSpinner.DefaultEditor.class.cast(jComponent)).getTextField() : new JTextField();
        }
        return this.textField;
    }

    @Override
    @Deprecated
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.mouseWheelEventsEnabled && this.isEnabled()) {
            MAction.fire(mouseWheelEvent, "increment", "decrement", this);
        }
    }

    @Override
    public void requestFocus() {
        if (this.getTextField() == null) {
            super.requestFocus();
        } else {
            this.getTextField().requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.getTextField() == null) {
            return super.requestFocusInWindow();
        }
        return this.getTextField().requestFocusInWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValue(Object object) {
        AutoCompletion autoCompletion = this.getAutoCompletion();
        if (autoCompletion == null) {
            super.setValue(object);
        } else {
            boolean bl = (Boolean)autoCompletion.enabled.get();
            try {
                autoCompletion.enabled.no();
                super.setValue(object);
            }
            finally {
                autoCompletion.enabled.set(bl);
            }
        }
    }

    @Override
    public void clear() {
        this.setText(null);
    }

    @Override
    public boolean isEmpty() {
        return this.getTextField().getDocument().getLength() == 0;
    }

    @Override
    public void makeDefault() {
        this.requestFocusInWindow();
    }

    @Override
    public AutoCompletion getAutoCompletion() {
        return MText.getAutoCompletion(this.getTextField());
    }

    @Override
    public void saveAutoCompletion() {
        MText.saveAutoCompletion(this.getTextField());
    }

    @Override
    public void setAutoCompletion(String string) {
        MText.installAutoCompletion(this.getTextField(), string);
        this.getAutoCompletion().setShowPopupOnUpDownKeyPress(false);
    }

    @Override
    public String getText() {
        return this.getTextField().getText();
    }

    @Override
    public void setText(String string) {
        this.getTextField().setText(string);
    }

    @Override
    public void setEnterPressAction(Action action) {
        MText.setEnterPressAction(this.getTextField(), action);
    }

    protected void setupEditor() {
        JTextField jTextField = this.getTextField();
        MText.commonSetup(jTextField);
    }
}

