/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.TK;

public abstract class AbstractSelection<T>
implements ClipboardOwner,
Transferable {
    private DataFlavor[] flavors;
    private T data;

    public static DataFlavor createDataFlavor(String string, String string2) {
        try {
            return new DataFlavor(String.format("%s; class=%s", string, string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            MLogger.exception(classNotFoundException);
            return null;
        }
    }

    public abstract Object getContents(DataFlavor var1);

    public synchronized T getData() {
        return this.data;
    }

    @Deprecated
    public synchronized void setData(T t) {
        this.data = t;
    }

    @Deprecated
    public synchronized void setFlavors(DataFlavor ... dataFlavorArray) {
        this.flavors = TK.copyOf(dataFlavorArray);
    }

    @Override
    public synchronized void lostOwnership(Clipboard clipboard, Transferable transferable) {
        this.data = null;
    }

    @Override
    public synchronized Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        if (this.data == null) {
            return null;
        }
        return this.getContents(dataFlavor);
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return TK.copyOf(this.flavors);
    }

    @Override
    public synchronized boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        for (DataFlavor dataFlavor2 : this.flavors) {
            if (!dataFlavor2.equals(dataFlavor)) continue;
            return true;
        }
        return false;
    }

    protected AbstractSelection(T t, DataFlavor ... dataFlavorArray) {
        this.setData(t);
        this.setFlavors(dataFlavorArray);
    }
}

