/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga.commons;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.makagiga.commons.FS;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.RegExp;
import org.makagiga.commons.SimpleXMLReader;
import org.makagiga.commons.StringList;
import org.makagiga.commons.TK;
import org.makagiga.commons.XMLBuilder;

public abstract class AbstractFileCache<K, I extends Item>
implements Iterable<Map.Entry<K, I>>,
Serializable {
    private File directory;
    private File indexFile;
    private int version = 1;
    private Map<K, I> items = new HashMap<K, I>(1000);
    private String name;
    protected MLogger log;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        AbstractFileCache abstractFileCache = this;
        synchronized (abstractFileCache) {
            if (!this.indexFile.exists()) {
                return;
            }
            FS.deleteDir(this.directory, false);
            this.items.clear();
        }
        this.doWriteIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void fixCacheDirectory() {
        StringList stringList = new StringList(this.getItemCount());
        File[] fileArray = this;
        synchronized (this) {
            void var4_7;
            for (Map.Entry<K, I> entry : this) {
                stringList.add(((Item)entry.getValue()).getFileName());
            }
            // ** MonitorExit[fileArray] (shouldn't be in output)
            fileArray = FS.listFiles(this.getDirectory());
            int n = fileArray.length;
            boolean bl = false;
            while (var4_7 < n) {
                File file = fileArray[var4_7];
                if (!file.equals(this.getIndexFile()) && !stringList.contains(file.getName())) {
                    this.log.infoFormat("Removing broken cache entry: %s", file.getName());
                    file.delete();
                }
                ++var4_7;
            }
            return;
        }
    }

    public synchronized File getDirectory() {
        return this.directory;
    }

    public synchronized File getIndexFile() {
        return this.indexFile;
    }

    public synchronized I getItem(K k) {
        return (I)((Item)this.items.get(k));
    }

    public synchronized int getItemCount() {
        return this.items.size();
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized int getVersion() {
        return this.version;
    }

    public synchronized boolean isEmpty() {
        return this.items.isEmpty();
    }

    public void putItem(K k, I i) {
        this.putItem(k, i, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putItem(K k, I i, boolean bl) {
        AbstractFileCache abstractFileCache = this;
        synchronized (abstractFileCache) {
            this.items.put(k, i);
        }
        if (bl) {
            this.doWriteIndex();
        }
    }

    public void removeItem(K k) {
        this.removeItem(k, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(K k, boolean bl) {
        I i = this.getItem(k);
        if (i != null) {
            AbstractFileCache abstractFileCache = this;
            synchronized (abstractFileCache) {
                this.log.debugFormat("Removing \"%s\"...", k);
                this.items.remove(k);
            }
            this.doWriteIndex();
            if (bl) {
                this.removeItemFile(i);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeItem(RegExp regExp) {
        this.log.debugFormat("Removing \"%s\"...", regExp);
        boolean bl = false;
        AbstractFileCache abstractFileCache = this;
        synchronized (abstractFileCache) {
            Iterator<Map.Entry<K, I>> iterator = this.iterator();
            while (iterator.hasNext()) {
                Map.Entry<K, I> entry = iterator.next();
                if (!regExp.matches(entry.getKey().toString())) continue;
                this.removeItemFile((Item)entry.getValue());
                iterator.remove();
                bl = true;
            }
        }
        if (bl) {
            this.doWriteIndex();
        }
    }

    @Override
    public synchronized Iterator<Map.Entry<K, I>> iterator() {
        return this.items.entrySet().iterator();
    }

    protected AbstractFileCache(String string, File file) {
        this(string, file, null);
    }

    protected AbstractFileCache(String string, File file, String string2) {
        this.name = TK.validateID(string);
        this.log = MLogger.get(string);
        this.directory = file == null ? FS.makeConfigFile(string, 1) : file;
        this.indexFile = new File(FS.makePath(this.directory.getPath(), string2 == null ? "index.xml" : string2));
        try {
            this.readIndex();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp(int n) {
        AbstractFileCache abstractFileCache = this;
        synchronized (abstractFileCache) {
            int n2 = this.items.size();
            if (n2 <= n) {
                return;
            }
            Collection<I> collection = this.items.values();
            List<Item> list = TK.sortByValue(this.items, null);
            list.subList(0, n /= 2).clear();
            for (Item item : list) {
                collection.remove(item);
                this.removeItemFile(item);
            }
            this.log.debugFormat("Clean up: %d -> %d", n2, this.items.size());
        }
        this.fixCacheDirectory();
        this.doWriteIndex();
    }

    protected synchronized File createItemFile(String string) throws IOException {
        return FS.createUniqueFile(this.directory, string);
    }

    protected void doWriteIndex() {
        try {
            this.writeIndex();
        }
        catch (IOException iOException) {
            MLogger.exception(iOException);
        }
    }

    protected synchronized File getItemFile(I i) {
        return new File(FS.makePath(this.directory.getPath(), ((Item)i).getFileName()));
    }

    protected void removeItemFile(I i) {
        File file = this.getItemFile(i);
        file.delete();
    }

    protected abstract void readIndex() throws IOException;

    protected Map.Entry<K, I> readXMLEntry(SimpleXMLReader simpleXMLReader) {
        throw new UnsupportedOperationException();
    }

    protected void readXMLIndex(final String string, final String string2) throws IOException {
        SimpleXMLReader simpleXMLReader = new SimpleXMLReader(){
            private boolean inList;
            private boolean inRoot;
            private Map.Entry<K, I> entry;

            @Override
            protected void onStart(String string3) {
                if (!this.inRoot && string.equals(string3)) {
                    this.inRoot = true;
                    this.inList = string2 == null;
                } else if (this.inRoot && !this.inList && string2.equals(string3)) {
                    this.inList = true;
                } else if (this.inList) {
                    this.entry = AbstractFileCache.this.readXMLEntry(this);
                }
            }

            @Override
            protected void onEnd(String string3) {
                if (this.inRoot && string.equals(string3)) {
                    this.inRoot = false;
                    this.inList = false;
                } else if (this.inRoot && this.inList && string2 != null && string2.equals(string3)) {
                    this.inList = false;
                } else if (this.inList && this.entry != null) {
                    AbstractFileCache.this.putItem(this.entry.getKey(), (Item)this.entry.getValue(), false);
                    this.entry = null;
                }
            }
        };
        simpleXMLReader.read(this.getIndexFile());
    }

    protected synchronized void setVersion(int n) {
        this.version = n;
    }

    protected abstract void writeIndex() throws IOException;

    protected void writeXMLEntry(XMLBuilder xMLBuilder, Map.Entry<K, I> entry) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeXMLIndex(String string, String string2) throws IOException {
        XMLBuilder xMLBuilder = new XMLBuilder();
        AbstractFileCache abstractFileCache = this;
        synchronized (abstractFileCache) {
            xMLBuilder.beginTag(string, "version", this.version);
            if (string2 != null) {
                xMLBuilder.beginTag(string2);
            }
            for (Map.Entry<K, I> entry : this) {
                this.writeXMLEntry(xMLBuilder, entry);
            }
        }
        if (string2 != null) {
            xMLBuilder.endTag(string2);
        }
        xMLBuilder.endTag(string);
        abstractFileCache = this;
        synchronized (abstractFileCache) {
            xMLBuilder.save(this.getIndexFile().getPath());
        }
    }

    public static class Item
    implements Comparable<Item>,
    Serializable {
        private int usage = 1;
        private String fileName;

        public Item() {
        }

        public Item(String string) {
            this.fileName = TK.checkNull(string, "fileName");
        }

        @Override
        public synchronized int compareTo(Item item) {
            return TK.compare(this.usage, item.getUsage()) * -1;
        }

        public synchronized String getFileName() {
            return this.fileName;
        }

        public synchronized void setFileName(String string) {
            this.fileName = TK.checkNull(string, "value");
        }

        public synchronized int getUsage() {
            return this.usage;
        }

        public synchronized void incUsage() {
            ++this.usage;
        }

        public synchronized void setUsage(int n) {
            this.usage = n;
        }

        public synchronized String toString() {
            return this.fileName == null ? "" : this.fileName;
        }
    }
}

