/*
 * Decompiled with CFR 0.152.
 */
package org.makagiga;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.KeyStroke;
import org.makagiga.MainWindow;
import org.makagiga.Sidebar;
import org.makagiga.Vars;
import org.makagiga.commons.ClipboardException;
import org.makagiga.commons.Flags;
import org.makagiga.commons.Focusable;
import org.makagiga.commons.MAction;
import org.makagiga.commons.MActionInfo;
import org.makagiga.commons.MClipboard;
import org.makagiga.commons.MIcon;
import org.makagiga.commons.MLogger;
import org.makagiga.commons.MMenu;
import org.makagiga.commons.MMenuAdapter;
import org.makagiga.commons.MMessage;
import org.makagiga.commons.MMouseAdapter;
import org.makagiga.commons.MStatusBar;
import org.makagiga.commons.MTabbedPane;
import org.makagiga.commons.MWhatsThis;
import org.makagiga.commons.MainView;
import org.makagiga.commons.Mnemonic;
import org.makagiga.commons.PassiveException;
import org.makagiga.commons.TK;
import org.makagiga.commons.UI;
import org.makagiga.commons.WTFError;
import org.makagiga.editors.Designer;
import org.makagiga.editors.Editor;
import org.makagiga.editors.EditorConfig;
import org.makagiga.editors.EditorDesigner;
import org.makagiga.editors.EditorPlugin;
import org.makagiga.fs.FSAction;
import org.makagiga.fs.FSHelper;
import org.makagiga.fs.MetaInfo;
import org.makagiga.fs.MetaInfoAction;
import org.makagiga.fs.trash.TrashFS;
import org.makagiga.plugins.PluginManager;
import org.makagiga.tabs.DesktopTab;
import org.makagiga.tools.SessionManager;

public final class Tabs
extends MTabbedPane<Editor<?>> {
    public static final int REMOVE_TAB = 1;
    public static final int SAVE_TO_FILE = 2;
    public static final int NORMAL_SAVE = 1;
    public static final int QUIET_SAVE = 2;
    private final KeyStroke historyKeyStroke = KeyStroke.getKeyStroke(84, MAction.getMenuMask() | 1);
    private final LinkedList<MetaInfo> recentlyClosedTabs = new LinkedList();
    private static Tabs _instance;
    private final CloseAction closeAction = new CloseAction();
    private final CloseAllAction closeAllAction = new CloseAllAction();
    private final CloseAllOthersAction closeAllOthersAction = new CloseAllOthersAction();
    boolean removingTab;

    public void addEditor(Editor<?> editor) {
        MetaInfo metaInfo = editor.getMetaInfo();
        if (metaInfo != null) {
            metaInfo.setOpen(true);
        }
        this.recentlyClosedTabs.remove(metaInfo);
        this.addTab((String)null, editor);
        int n = this.indexOfComponent(editor);
        if (n == -1) {
            MLogger.error("editor", "Tabs.indexOfComponent(editor) == -1");
        } else {
            MTabbedPane.TabComponent tabComponent = new MTabbedPane.TabComponent(this){

                @Override
                protected void onClick() {
                    int n = this.getIndex();
                    Editor editor = (Editor)Tabs.this.getTabAt(n);
                    if (editor != null && editor.isCloseable()) {
                        Tabs.this.close(n);
                    } else {
                        Tabs.this.selectEditorAt(n);
                    }
                }
            };
            UI.setHTMLEnabled(tabComponent.getTextLabel(), false);
            if (!editor.isCloseable()) {
                MTabbedPane.TabIcon tabIcon = tabComponent.getTabIcon();
                tabIcon.setSafeAction(false);
                tabIcon.setToolTipText(null);
            }
            this.setTabComponentAt(n, tabComponent);
        }
        this.setTabInfo(metaInfo);
        this.setSelectedComponent(editor);
        if (editor instanceof Focusable) {
            ((Focusable)Focusable.class.cast(editor)).focus();
        }
        if (metaInfo != null) {
            metaInfo.refresh(false);
        }
        if (editor instanceof EditorConfig) {
            ((EditorConfig)EditorConfig.class.cast(editor)).loadConfig(metaInfo.getConfig());
        }
    }

    public void addRecentlyClosedTab(MetaInfo metaInfo) {
        if (!metaInfo.isAnyFile()) {
            return;
        }
        this.recentlyClosedTabs.remove(metaInfo);
        this.recentlyClosedTabs.addFirst(metaInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeEditorAt(int n, int n2) {
        Editor editor = (Editor)this.getTabAt(n);
        if (editor == null) {
            return;
        }
        if (!editor.isCloseable()) {
            return;
        }
        Flags flags = new Flags(n2);
        if (flags.isSet(2L) && !this.saveEditor(editor, 1)) {
            return;
        }
        if (!editor.onBeforeClose()) {
            return;
        }
        if (flags.isSet(1L)) {
            try {
                this.removingTab = true;
                this.removeTabAt(n);
            }
            finally {
                this.removingTab = false;
            }
            this.fireStateChanged();
        }
        MetaInfo metaInfo = editor.getMetaInfo();
        metaInfo.setOpen(false);
        editor.destroy();
        metaInfo.refresh(false);
        this.addRecentlyClosedTab(metaInfo);
    }

    public MMenu createRecentlyClosedTabsMenu() {
        MMenu mMenu = new MMenu(UI._("History"));
        mMenu.addMenuListener(new MMenuAdapter(true){

            @Override
            protected void onSelect(MMenu mMenu) {
                mMenu.removeAll();
                Tabs.this.updateRecentlyClosedTabsMenu(mMenu);
            }
        });
        return mMenu;
    }

    public MMenu createTabsMenu() {
        MMenu mMenu = new MMenu(UI._("Tabs"));
        MetaInfo metaInfo = this.getCurrentMetaInfo();
        if (metaInfo != null) {
            mMenu.addTitle(metaInfo.toString());
        }
        mMenu.add(this.closeAction);
        mMenu.add(this.closeAllAction);
        mMenu.add(this.closeAllOthersAction);
        PluginManager.updateMenu(mMenu, "TABS_MENU", false);
        return mMenu;
    }

    public void deletePrivateData() {
        this.recentlyClosedTabs.clear();
    }

    public <T extends Editor<?>> T findEditor(Class<T> clazz) {
        for (Editor editor : this) {
            if (editor == null || !editor.getClass().equals(clazz)) continue;
            return (T)editor;
        }
        return null;
    }

    public int findEditor(MetaInfo metaInfo) {
        return metaInfo == null ? -1 : this.findEditor(metaInfo.getFilePath());
    }

    public int findEditor(String string) {
        if (TK.isEmpty(string)) {
            return -1;
        }
        for (Editor editor : this) {
            if (editor == null || !editor.getMetaInfo().getFilePath().equals(string)) continue;
            return this.indexOfComponent(editor);
        }
        return -1;
    }

    @Override
    public void fireStateChanged() {
        super.fireStateChanged();
    }

    public MAction getCloseAction() {
        return this.closeAction;
    }

    public MAction getCloseAllAction() {
        return this.closeAllAction;
    }

    public MetaInfo getCurrentMetaInfo() {
        Editor editor = (Editor)this.getSelectedTab();
        if (editor == null) {
            return null;
        }
        return editor.getMetaInfo();
    }

    public static synchronized Tabs getInstance() {
        if (_instance == null) {
            Tabs tabs = new Tabs();
            tabs.restoreBorderContentInsets();
        }
        return _instance;
    }

    public List<MetaInfo> getRecentlyClosedTabs() {
        return this.recentlyClosedTabs;
    }

    public Editor<?> getTabAt(MetaInfo metaInfo) {
        int n = this.findEditor(metaInfo);
        return n == -1 ? null : (Editor)this.getTabAt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean openEditor(MetaInfo metaInfo) {
        Editor<?> editor;
        if (metaInfo == null) {
            MLogger.trace();
            MLogger.error("editor", "Null meta info");
            return false;
        }
        if (TrashFS.isInTrash(metaInfo)) {
            MStatusBar.warning(UI._("Cannot open file from the Trash"));
            return false;
        }
        int n = this.findEditor(metaInfo);
        if (n != -1) {
            this.selectEditorAt(n);
            return true;
        }
        try {
            editor = EditorPlugin.createEditorForPath(metaInfo.getFilePath());
            if (editor == null) {
                MStatusBar.warning(UI._("Could not open \"{0}\" file (disabled or missing plugin): {1}", metaInfo.getExtension(), metaInfo.getNicePath()));
                return false;
            }
            if (editor.getCore() == null) {
                throw new Exception(editor.getClass().getName() + ": getCore() == null");
            }
        }
        catch (Exception exception) {
            MMessage.error(null, exception, UI._("Could not open file"));
            return false;
        }
        editor.setMetaInfo(metaInfo);
        MLogger.info("editor", "Loading \"%s\"...", metaInfo.getFilePath());
        MStatusBar.message(UI._("Loading..."));
        UI.setWaitCursor(true);
        try {
            editor.loadFromFile();
            metaInfo.setLastOpenTime();
            boolean bl = !metaInfo.canModify();
            editor.setLocked(bl);
            if (editor instanceof EditorDesigner) {
                ((Designer)((EditorDesigner)EditorDesigner.class.cast(editor)).getEditorDesigner()).setLocked(bl);
            }
            editor.setModified(metaInfo.getFile().length() == 0L);
            this.addEditor(editor);
            if (editor instanceof EditorDesigner) {
                ((EditorDesigner)EditorDesigner.class.cast(editor)).updateEditorDesigner();
            }
            MStatusBar.ready();
            boolean bl2 = true;
            return bl2;
        }
        catch (PassiveException passiveException) {
            MMessage.error(null, passiveException, UI._("Could not open file"));
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            MStatusBar.ready();
            MMessage.error(null, exception, UI._("Could not open file"));
            boolean bl = false;
            return bl;
        }
        finally {
            UI.setWaitCursor(false);
        }
    }

    public void saveAllEditors(int n) {
        for (Editor editor : this) {
            this.saveEditor(editor, n);
        }
    }

    public boolean saveEditor(Editor<?> editor, int n) {
        if (editor == null) {
            return false;
        }
        boolean bl = (n & 2) != 0;
        return editor.sync(bl);
    }

    public void selectEditor(Editor<?> editor) {
        if (editor == null) {
            return;
        }
        int n = this.indexOfComponent(editor);
        if (n != -1) {
            this.setSelectedIndex(n);
            UI.requestFocus(editor);
        }
    }

    public void selectEditorAt(int n) {
        this.selectEditor((Editor)this.getTabAt(n));
    }

    public void setTabInfo(MetaInfo metaInfo) {
        int n = this.findEditor(metaInfo);
        if (n == -1) {
            return;
        }
        this.setColors(metaInfo, n);
        MTabbedPane.TabComponent tabComponent = (MTabbedPane.TabComponent)this.getTabComponentAt(n);
        MIcon mIcon = metaInfo.getSmallIcon();
        if (mIcon == null) {
            mIcon = MIcon.small("ui/file");
        }
        tabComponent.setIcon(mIcon);
        if (UI.isA03()) {
            tabComponent.setText(TK.rightSqueeze(metaInfo.toString(), 50));
        } else {
            tabComponent.setText(metaInfo.toString());
        }
    }

    public void updateState() {
        Editor editor = (Editor)this.getSelectedTab();
        boolean bl = editor != null;
        this.closeAction.setEnabled(bl && editor.isCloseable());
        this.closeAllAction.setEnabled(bl && this.getTabCount() > 1);
        this.closeAllOthersAction.setEnabled(bl && this.getTabCount() > 1);
        this.updateColors();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Editor editor2;
            Mnemonic.setExcluded(editor2, (editor2 = (Editor)iterator.next()) instanceof DesktopTab || editor2 != editor);
        }
        new Mnemonic(this);
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (UI.isGTK()) {
            this.setBorder(null);
        }
    }

    protected void close(int n) {
        this.closeEditorAt(n, 3);
        boolean bl = false;
        Sidebar sidebar = Sidebar.getInstance();
        if (sidebar.isDesignerSelected()) {
            if (this.getSelectedTab() instanceof EditorDesigner) {
                sidebar.goTo(Sidebar.Tab.DESIGNER, bl);
            } else {
                sidebar.goTo(Sidebar.Tab.TREE, bl);
            }
        } else if (sidebar.isSummarySelected()) {
            sidebar.goTo(Sidebar.Tab.SUMMARY, bl);
        } else {
            sidebar.goTo(Sidebar.Tab.TREE, bl);
        }
    }

    private Tabs() {
        if (_instance != null) {
            throw new WTFError("org.makagiga.Tabs already created");
        }
        _instance = this;
        MWhatsThis.set(this, UI._("Tabs - All the open documents are here"));
        if (UI.isMetal()) {
            Tabs.setBorderContentInsets(Tabs.createBorderContentInsetsForPlacement(this.getTabPlacement()));
            this.updateUI();
        }
        this.setTabLayoutPolicy(1);
        this.addMouseListener(new MMouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                int n = Tabs.this.indexAtLocation(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                if (3.isLeft(mouseEvent) && 3.isDoubleClick(mouseEvent)) {
                    Tabs.this.rename();
                } else if (3.isMiddle(mouseEvent)) {
                    Tabs.this.close(n);
                }
            }

            @Override
            public void popupTrigger(MouseEvent mouseEvent) {
                Tabs.this.popupContextMenu(mouseEvent.getPoint());
            }
        });
        MainView.bind(new HistoryMenuAction(), new TabsMenuAction());
    }

    private void close() {
        this.close(this.getSelectedIndex());
    }

    private void closeAll() {
        if (this.isEmpty()) {
            return;
        }
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            this.closeEditorAt(i, 3);
        }
        Sidebar sidebar = Sidebar.getInstance();
        if (sidebar.isDesignerSelected()) {
            sidebar.goTo(Sidebar.Tab.TREE, false);
        }
    }

    private void closeAllOthers() {
        if (this.getTabCount() < 2) {
            return;
        }
        int n = this.getSelectedIndex();
        for (int i = this.getTabCount() - 1; i >= 0; --i) {
            if (i == n) continue;
            this.closeEditorAt(i, 3);
        }
    }

    private void popupContextMenu(Point point) {
        int n;
        if (point == null) {
            n = -1;
            point = this.getTabComponentAt(this.getSelectedIndex()).getLocation();
        } else {
            n = this.indexAtLocation(point);
        }
        try {
            if (n != -1) {
                this.setSelectedIndex(n);
            }
            final MetaInfo metaInfo = this.getCurrentMetaInfo();
            MMenu mMenu = this.createTabsMenu();
            mMenu.addSeparator();
            MAction mAction = new MAction(UI._("Copy Name"), MActionInfo.COPY.getIconName()){

                @Override
                public void onAction() {
                    try {
                        MClipboard.setString(metaInfo.toString());
                    }
                    catch (ClipboardException clipboardException) {
                        MMessage.error(null, clipboardException);
                    }
                }
            };
            mAction.setEnabled(metaInfo != null);
            mMenu.add(mAction);
            MAction mAction2 = new MAction(UI._("Copy File Location"), MActionInfo.COPY.getIconName()){

                @Override
                public void onAction() {
                    try {
                        MClipboard.setString(metaInfo.getFilePath());
                    }
                    catch (ClipboardException clipboardException) {
                        MMessage.error(null, clipboardException);
                    }
                }
            };
            mAction2.setEnabled(metaInfo != null && metaInfo.isFile());
            mMenu.add(mAction2);
            mMenu.addSeparator();
            MAction mAction3 = new MAction(UI._("Rename...")){

                @Override
                public void onAction() {
                    Tabs.this.rename();
                }
            };
            mAction3.setEnabled((Boolean)Vars.treeReadOnly.get() == false && metaInfo != null && metaInfo.isPermission(FSAction.RENAME));
            mMenu.add(mAction3);
            mMenu.showPopup((Component)this, point);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            MLogger.exception(indexOutOfBoundsException);
        }
    }

    private void rename() {
        MetaInfo metaInfo = this.getCurrentMetaInfo();
        if (metaInfo != null) {
            FSHelper.renameUI(UI.windowFor(this), metaInfo);
        }
    }

    private void setColors(MetaInfo metaInfo, int n) {
        MTabbedPane.TabComponent tabComponent = (MTabbedPane.TabComponent)this.getTabComponentAt(n);
        if (tabComponent != null) {
            tabComponent.setColor(metaInfo.getColor());
        }
    }

    private void updateColors() {
        for (Editor editor : this) {
            this.setColors(editor.getMetaInfo(), this.indexOfComponent(editor));
        }
    }

    private void updateRecentlyClosedTabsMenu(MMenu mMenu) {
        int n = 10;
        if (this.recentlyClosedTabs.size() > n) {
            this.recentlyClosedTabs.subList(n, this.recentlyClosedTabs.size()).clear();
        }
        boolean bl = true;
        boolean bl2 = true;
        Iterator iterator = this.recentlyClosedTabs.iterator();
        while (iterator.hasNext()) {
            MetaInfo metaInfo = (MetaInfo)iterator.next();
            if (metaInfo.getParent() == null || metaInfo.getParent().getParent() == null) {
                iterator.remove();
                continue;
            }
            MetaInfoAction metaInfoAction = new MetaInfoAction(metaInfo, false);
            mMenu.add(metaInfoAction);
            bl = false;
            if (!bl2) continue;
            bl2 = false;
            metaInfoAction.setAcceleratorKey(this.historyKeyStroke);
        }
        if (bl) {
            mMenu.addTitle(UI._("No Items"));
        } else {
            mMenu.addSeparator();
            mMenu.add(new MAction(MActionInfo.CLEAR_HISTORY){

                @Override
                public void onAction() {
                    Tabs.this.deletePrivateData();
                    SessionManager.deletePrivateData();
                }
            });
        }
    }

    private final class TabsMenuAction
    extends MAction {
        @Override
        public void onAction() {
            if (!Tabs.this.isEmpty()) {
                Tabs.this.popupContextMenu(null);
            }
        }

        private TabsMenuAction() {
            super(UI._("Select next link/Show tabs menu"), 84, TabsMenuAction.getMenuMask());
        }
    }

    private final class HistoryMenuAction
    extends MAction {
        @Override
        public void onAction() {
            if (!((Boolean)Vars.tabsRecentlyClosedTabs.get()).booleanValue()) {
                return;
            }
            MMenu mMenu = new MMenu();
            mMenu.addTitle(this.getName());
            Tabs.this.updateRecentlyClosedTabsMenu(mMenu);
            mMenu.showPopup(MainWindow.getInstance().getRootPane());
        }

        private HistoryMenuAction() {
            super(UI._("History"));
            this.setAcceleratorKey(Tabs.this.historyKeyStroke);
        }
    }

    private final class CloseAllOthersAction
    extends MAction {
        CloseAllOthersAction() {
            super(UI._("Close All Others"));
            this.setEnabled(false);
            this.setHTMLHelp(UI._("Closes all other tabs."));
        }

        @Override
        public void onAction() {
            Tabs.this.closeAllOthers();
        }
    }

    private final class CloseAllAction
    extends MAction {
        CloseAllAction() {
            super(UI._("Close All"), 87, CloseAllAction.getMenuMask() | 1);
            this.setEnabled(false);
            this.setHTMLHelp(UI._("Closes all tabs."));
        }

        @Override
        public void onAction() {
            Tabs.this.closeAll();
        }
    }

    private static final class CloseAction
    extends MAction {
        @Override
        public void onAction() {
            Tabs.getInstance().close();
        }

        private CloseAction() {
            super(MActionInfo.CLOSE);
            this.setEnabled(false);
            this.setHTMLHelp(UI._("Closes the current tab."));
        }
    }
}

