/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.AbstractBufferedImageOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;

public class CompoundFilter<F1 extends BufferedImageOp, F2 extends BufferedImageOp>
extends AbstractBufferedImageOp {
    private F1 filter1;
    private F2 filter2;

    public CompoundFilter(F1 F1, F2 F2) {
        this.filter1 = F1;
        this.filter2 = F2;
    }

    @Override
    public BufferedImage filter(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        BufferedImage bufferedImage3 = this.filter1.filter(bufferedImage, bufferedImage2);
        bufferedImage3 = this.filter2.filter(bufferedImage3, bufferedImage2);
        return bufferedImage3;
    }

    public F1 getFilter1() {
        return this.filter1;
    }

    public F2 getFilter2() {
        return this.filter2;
    }

    public String toString() {
        return this.filter1 + " + " + this.filter2;
    }
}

