/*
 * Decompiled with CFR 0.152.
 */
package jreepad.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import jreepad.JreepadNode;
import jreepad.JreepadTreeModel;
import jreepad.io.JreepadWriter;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XmlWriter
implements JreepadWriter {
    public static final String NODE_TAG = "node";
    public static final String TITLE_ATTRIBUTE = "title";
    public static final String TYPE_ATTRIBUTE = "type";
    public static final String NSU = "";
    private AttributesImpl attributes = new AttributesImpl();

    public XmlWriter() {
        this.attributes.addAttribute(NSU, NSU, TITLE_ATTRIBUTE, NSU, NSU);
        this.attributes.addAttribute(NSU, NSU, TYPE_ATTRIBUTE, NSU, NSU);
    }

    public void write(OutputStream out, JreepadTreeModel document) throws IOException {
        TransformerHandler handler;
        StreamResult result = new StreamResult(out);
        SAXTransformerFactory factory = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
        try {
            handler = factory.newTransformerHandler();
            handler.getTransformer().setOutputProperty("indent", "yes");
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e.toString());
        }
        handler.setResult(result);
        try {
            this.write(handler, document);
        }
        catch (SAXException e) {
            throw new IOException(e.toString());
        }
    }

    private void write(ContentHandler handler, JreepadTreeModel document) throws SAXException {
        handler.startDocument();
        this.writeNode(handler, document.getRootNode());
        handler.endDocument();
    }

    private void writeNode(ContentHandler handler, JreepadNode node) throws SAXException {
        String type;
        switch (node.getArticle().getArticleMode()) {
            case 2: {
                type = "text/html";
                break;
            }
            case 4: {
                type = "text/textile";
                break;
            }
            case 3: {
                type = "text/csv";
                break;
            }
            default: {
                type = "text/plain";
            }
        }
        this.attributes.setValue(0, node.getTitle());
        this.attributes.setValue(1, type);
        handler.startElement(NSU, NODE_TAG, NODE_TAG, this.attributes);
        String content = node.getContent();
        handler.characters(content.toCharArray(), 0, content.length());
        Enumeration<TreeNode> kids = node.children();
        while (kids.hasMoreElements()) {
            this.writeNode(handler, (JreepadNode)kids.nextElement());
        }
        handler.endElement(NSU, NODE_TAG, NODE_TAG);
    }
}

