/*
 * Decompiled with CFR 0.152.
 */
package jreepad;

import java.awt.Cursor;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jreepad.JreepadNode;
import jreepad.JreepadTreeModel;

public class TreeView
extends JTree {
    private JreepadTreeModel treeModel;

    public TreeView(JreepadTreeModel treeModel) {
        super(treeModel);
        this.treeModel = treeModel;
        this.getSelectionModel().setSelectionMode(1);
        this.setExpandsSelectedPaths(true);
        this.setInvokesStopCellEditing(true);
        this.setEditable(true);
        DefaultTreeCellRenderer renderer = new DefaultTreeCellRenderer();
        renderer.setOpenIcon(null);
        renderer.setClosedIcon(null);
        renderer.setLeafIcon(null);
        this.setCellRenderer(renderer);
        this.addMouseListener(new TreeViewMouseListener());
    }

    public void moveNode(JreepadNode node, JreepadNode newParent) {
        if (node.isNodeDescendant(newParent)) {
            return;
        }
        JreepadNode oldParent = node.getParentNode();
        boolean thisOnesExpanded = this.isExpanded(this.getSelectionPath());
        if (thisOnesExpanded) {
            Enumeration<TreePath> enumer = this.getExpandedDescendants(this.getSelectionPath());
            Vector<TreePath> expanded = new Vector<TreePath>();
            while (enumer.hasMoreElements()) {
                expanded.add(enumer.nextElement());
            }
        }
        newParent.add(node);
        this.treeModel.reload(oldParent);
        this.treeModel.reload(newParent);
    }

    public void expandAll(JreepadNode thisNode, TreePath tp) {
        this.expandPath(tp);
        Enumeration<TreeNode> getKids = thisNode.children();
        while (getKids.hasMoreElements()) {
            JreepadNode thisKid = (JreepadNode)getKids.nextElement();
            this.expandAll(thisKid, tp.pathByAddingChild(thisKid));
        }
    }

    public void collapseAll(JreepadNode thisNode, TreePath tp) {
        Enumeration<TreeNode> getKids = thisNode.children();
        while (getKids.hasMoreElements()) {
            JreepadNode thisKid = (JreepadNode)getKids.nextElement();
            this.collapseAll(thisKid, tp.pathByAddingChild(thisKid));
        }
        this.collapsePath(tp);
    }

    public TreePath[] getAllExpandedPaths() {
        JreepadNode root = (JreepadNode)this.treeModel.getRoot();
        if (root.getChildCount() == 0) {
            return new TreePath[]{new TreePath(root)};
        }
        Enumeration<TreePath> getPaths = this.getExpandedDescendants(new TreePath(root));
        Vector<TreePath> allPaths = new Vector<TreePath>();
        while (getPaths.hasMoreElements()) {
            TreePath thisKid = getPaths.nextElement();
            allPaths.add(thisKid);
        }
        TreePath[] ret = new TreePath[allPaths.size()];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = (TreePath)allPaths.get(i);
        }
        return ret;
    }

    public void expandPaths(TreePath[] paths) {
        for (int i = 0; i < paths.length; ++i) {
            this.expandPath(paths[i]);
        }
    }

    private class TreeViewMouseListener
    extends MouseAdapter {
        private JreepadNode currentDragDropNode;

        private TreeViewMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            TreePath selPath = TreeView.this.getPathForLocation(e.getX(), e.getY());
            if (selPath != null) {
                this.currentDragDropNode = (JreepadNode)selPath.getLastPathComponent();
                TreeView.this.setCursor(Cursor.getPredefinedCursor(12));
            }
        }

        public void mouseReleased(MouseEvent e) {
            TreePath selPath = TreeView.this.getPathForLocation(e.getX(), e.getY());
            if (selPath != null && this.currentDragDropNode != null && this.currentDragDropNode.getParentNode() != null && this.currentDragDropNode.getParentNode() != (JreepadNode)selPath.getLastPathComponent() && this.currentDragDropNode != (JreepadNode)selPath.getLastPathComponent()) {
                TreeView.this.moveNode(this.currentDragDropNode, (JreepadNode)selPath.getLastPathComponent());
                TreeView.this.setSelectionPath(selPath.pathByAddingChild(this.currentDragDropNode));
            }
            TreeView.this.setCursor(Cursor.getDefaultCursor());
            this.currentDragDropNode = null;
        }

        public void mouseClicked(MouseEvent e) {
            TreePath selPath = TreeView.this.getPathForLocation(e.getX(), e.getY());
            if (selPath != null && e.isPopupTrigger()) {
                System.out.println("Context menu would be launched here!");
            }
        }
    }
}

