/*
 * Decompiled with CFR 0.152.
 */
package com.lightdev.app.allday.ui;

import com.lightdev.app.allday.action.AbstractAction;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Hashtable;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

public class ResourceMenu {
    private static final String labelSuffix = "Label";
    private static final String actionSuffix = "Action";
    public static final String imageSuffix = "Image";
    public static final String toolTipSuffix = "Tip";
    public static final String selectedIconSuffix = "SelectedIcon";
    public static final String menuSeparatorKey = "-";
    private Hashtable menuItems = new Hashtable();
    private Hashtable commands = new Hashtable();
    private Hashtable menus = new Hashtable();

    public JMenuBar createMenubar(ResourceBundle resources, String name) {
        JMenuBar mb = new JMenuBar();
        String[] menuKeys = this.tokenize(this.getResourceString(resources, name), " ");
        int i = 0;
        while (i < menuKeys.length) {
            JMenu m = this.createMenu(resources, menuKeys[i]);
            if (m != null) {
                mb.add(m);
            }
            ++i;
        }
        return mb;
    }

    public void addAction(String cmd, Action action) {
        this.commands.put(cmd, action);
    }

    public JMenu createMenu(ResourceBundle resources, String key) {
        JMenu menu = null;
        String def = this.getResourceString(resources, key);
        if (def == null) {
            def = "";
        }
        String[] itemKeys = this.tokenize(def, " ");
        menu = new JMenu(this.getResourceString(resources, key + labelSuffix));
        int i = 0;
        while (i < itemKeys.length) {
            if (itemKeys[i].equals(menuSeparatorKey)) {
                menu.addSeparator();
            } else {
                JMenuItem mi = this.createMenuItem(resources, itemKeys[i]);
                menu.add(mi);
            }
            ++i;
        }
        menu.addMenuListener(new DynamicMenuListener());
        menu.setRequestFocusEnabled(false);
        menu.setFocusable(false);
        this.menus.put(key, menu);
        return menu;
    }

    public JMenu getMenu(String cmd) {
        return (JMenu)this.menus.get(cmd);
    }

    public JMenuItem getMenuItem(String cmd) {
        return (JMenuItem)this.menuItems.get(cmd);
    }

    public Action getAction(String cmd) {
        return (Action)this.commands.get(cmd);
    }

    public JMenuItem createMenuItem(ResourceBundle resources, String cmd) {
        JMenuItem mi = new JMenuItem(this.getResourceString(resources, cmd + labelSuffix));
        String astr = this.getResourceString(resources, cmd + actionSuffix);
        if (astr == null) {
            astr = cmd;
        }
        mi.setActionCommand(astr);
        Action a = this.getAction(astr);
        if (a != null) {
            Object aKey = a.getValue("AcceleratorKey");
            if (aKey != null) {
                mi.setAccelerator((KeyStroke)aKey);
            }
            mi.addActionListener(a);
            a.addPropertyChangeListener(this.createActionChangeListener(mi));
            Icon icon = (Icon)a.getValue("SmallIcon");
            if (icon != null) {
                mi.setHorizontalTextPosition(4);
                mi.setIcon(icon);
            }
            mi.setEnabled(a.isEnabled());
        } else {
            mi.setEnabled(false);
        }
        mi.setRequestFocusEnabled(false);
        mi.setFocusable(false);
        this.menuItems.put(cmd, mi);
        return mi;
    }

    public String getResourceString(ResourceBundle resources, String nm) {
        String str = null;
        try {
            str = resources.getString(nm);
        }
        catch (MissingResourceException mre) {}
        return str;
    }

    public JToolBar createToolBar(ResourceBundle resources, String nm) {
        Dimension buttonSize = new Dimension(24, 24);
        Dimension separatorSize = new Dimension(3, 20);
        String[] itemKeys = this.tokenize(this.getResourceString(resources, nm), " ");
        JToolBar toolBar = new JToolBar();
        toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        int i = 0;
        while (i < itemKeys.length) {
            if (itemKeys[i].equals(menuSeparatorKey)) {
                JSeparator separator = new JSeparator(1);
                toolBar.add(separator);
            } else {
                Action action = this.getAction(itemKeys[i]);
                JButton newButton = toolBar.add(action);
                newButton.setMinimumSize(buttonSize);
                newButton.setPreferredSize(buttonSize);
                newButton.setMaximumSize(buttonSize);
                newButton.setFocusPainted(false);
            }
            ++i;
        }
        return toolBar;
    }

    private String[] tokenize(String input, String delim) {
        Vector<String> v = new Vector<String>();
        StringTokenizer t = new StringTokenizer(input, delim);
        while (t.hasMoreTokens()) {
            v.addElement(t.nextToken());
        }
        String[] result = new String[v.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)v.elementAt(i);
            ++i;
        }
        return result;
    }

    public Icon getIconForCommand(ResourceBundle resources, String cmd) {
        return this.getIconForName(resources, cmd + imageSuffix);
    }

    public Icon getIconForName(ResourceBundle resources, String name) {
        ImageIcon icon = null;
        URL url = this.getResource(resources, name);
        if (url != null) {
            icon = new ImageIcon(url);
        }
        return icon;
    }

    public URL getResource(ResourceBundle resources, String key) {
        String name = this.getResourceString(resources, key);
        if (name != null) {
            URL url = this.getClass().getResource(name);
            return url;
        }
        return null;
    }

    private PropertyChangeListener createActionChangeListener(JMenuItem b) {
        return new ActionChangedListener(b);
    }

    private class DynamicMenuListener
    implements MenuListener {
        public void menuSelected(MenuEvent e) {
            Component[] items = ((JMenu)e.getSource()).getMenuComponents();
            int i = 0;
            while (i < items.length) {
                Action action;
                if (!(items[i] instanceof JPopupMenu.Separator) && items[i] instanceof JMenuItem && (action = ResourceMenu.this.getAction(((JMenuItem)items[i]).getActionCommand())) instanceof AbstractAction) {
                    ((AbstractAction)action).update();
                }
                ++i;
            }
        }

        public void menuDeselected(MenuEvent e) {
        }

        public void menuCanceled(MenuEvent e) {
        }
    }

    private class ActionChangedListener
    implements PropertyChangeListener {
        JMenuItem menuItem;

        ActionChangedListener(JMenuItem mi) {
            this.menuItem = mi;
        }

        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if (e.getPropertyName().equals("Name")) {
                String text = (String)e.getNewValue();
                this.menuItem.setText(text);
            } else if (propertyName.equals("enabled")) {
                Boolean enabledState = (Boolean)e.getNewValue();
                this.menuItem.setEnabled(enabledState);
            }
        }
    }
}

