/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.Timer;
import javax.swing.border.TitledBorder;

public final class SearchPanel
extends JPanel {
    final String[] modeStrings = new String[]{"Contains", "Exact", "At Beginning", "At End", "Greater", "Greater/equal", "Less", "Less/equal"};
    final String allFieldsTag = "Any Field";
    final int SEARCH_CONTAINS = 0;
    final int SEARCH_EXACT = 1;
    final int SEARCH_BEGINS = 2;
    final int SEARCH_ENDS = 3;
    final int SEARCH_GT = 4;
    final int SEARCH_GTEQ = 5;
    final int SEARCH_LT = 6;
    final int SEARCH_LTEQ = 7;
    String[] additionalFields = new String[]{"balance", "shareBalance"};
    final String prefix = "db_";
    PLCash parent;
    Account defaultAccount;
    AccountDisplay defaultAccountDisplay;
    String[] fieldNames;
    String[] headerNames;
    boolean globalSearch = false;
    boolean searchForward = true;
    int globalPointer = 0;
    int globalCounter = 0;
    int globalTotal = 0;
    ThreadAccountRecord threadReply = null;
    Timer timer = null;
    Thread searchThread = null;
    int timerInterval = 250;
    private JTextField searchTextField;
    private JButton searchGlobalButton;
    private JButton firstButton;
    private JComboBox modeComboBox;
    private JComboBox fieldComboBox;
    private JProgressBar progressBar;
    private JButton closeButton;
    private JCheckBox reverseCheckBox;
    private JButton nextButton;
    private JButton helpButton;
    private JCheckBox caseCheckBox;

    public SearchPanel(PLCash pLCash) {
        this.parent = pLCash;
        this.initComponents();
    }

    public void init(Account account) {
        this.globalPointer = 0;
        this.globalSearch = false;
        this.defaultAccount = account;
        this.defaultAccountDisplay = account.accountDisplay;
        this.setup(new Transaction(this.parent), "db_");
    }

    private void setup(Object object, String string) {
        int n;
        this.globalSearch = false;
        this.setGlobalButton();
        this.fieldNames = this.parent.dataFileManager.getFieldNames(object.getClass().getFields(), string);
        this.headerNames = this.parent.dataFileManager.getHeaderNames(this.fieldNames, string);
        Vector<String> vector = new Vector<String>(Arrays.asList(this.fieldNames));
        Vector<String> vector2 = new Vector<String>(Arrays.asList(this.headerNames));
        for (n = 0; n < this.additionalFields.length; ++n) {
            StringBuffer stringBuffer = new StringBuffer(this.additionalFields[n]);
            vector.add(stringBuffer.toString());
            stringBuffer.setCharAt(0, Character.toUpperCase(stringBuffer.charAt(0)));
            vector2.add(stringBuffer.toString());
        }
        this.fieldNames = vector.toArray(new String[0]);
        this.headerNames = vector2.toArray(new String[0]);
        this.fieldComboBox.addItem("Any Field");
        for (n = 0; n < this.headerNames.length; ++n) {
            this.fieldComboBox.addItem(this.headerNames[n]);
        }
        for (n = 0; n < this.modeStrings.length; ++n) {
            this.modeComboBox.addItem(this.modeStrings[n]);
        }
        this.fieldComboBox.setSelectedIndex(this.parent.programValues.db_SearchField);
        this.searchTextField.setText(this.parent.programValues.db_CurrentSearchString);
        this.modeComboBox.setSelectedIndex(this.parent.programValues.db_SearchMode);
        this.caseCheckBox.setSelected(this.parent.programValues.db_CaseSensitiveAccountSearch);
        this.reverseCheckBox.setSelected(this.parent.programValues.db_SearchInReverse);
    }

    public void saveSearchValues() {
        this.parent.programValues.db_SearchField = this.fieldComboBox.getSelectedIndex();
        this.parent.programValues.db_CurrentSearchString = this.searchTextField.getText();
        this.parent.programValues.db_SearchMode = this.modeComboBox.getSelectedIndex();
        this.parent.programValues.db_CaseSensitiveAccountSearch = this.caseCheckBox.isSelected();
        this.parent.programValues.db_SearchInReverse = this.reverseCheckBox.isSelected();
    }

    public void makeVisible() {
        this.setVisible(true);
        this.defaultAccountDisplay.revalidate();
        this.searchTextField.requestFocus();
    }

    private void closeThis() {
        this.saveSearchValues();
        this.parent.closeSearchWindow();
    }

    private String selectedSearchField() {
        String string = (String)this.fieldComboBox.getSelectedItem();
        if (string == null) {
            string = "";
        }
        return string;
    }

    private int selectedSearchIndex() {
        return this.fieldComboBox.getSelectedIndex();
    }

    private void processFindKey(JTextField jTextField, KeyEvent keyEvent) {
        char c = keyEvent.getKeyChar();
        if (c == '\n') {
            this.performSearch(true);
        } else if (c == '+' || c == '-') {
            String string = this.selectedSearchField();
            if (string.equals("Date")) {
                this.parent.commonCode.handleDateFieldKey(keyEvent, false);
            } else if (string.equals("Number")) {
                this.parent.commonCode.handleCheckNumberField(keyEvent, false);
            }
        } else {
            this.processKey(keyEvent);
        }
    }

    private void processKey(KeyEvent keyEvent) {
        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(keyEvent);
        if (keyStroke.equals(KeyStroke.getKeyStroke(70, 2))) {
            this.closeThis();
        } else if (keyEvent.getKeyCode() == 114) {
            this.performSearch(false);
        }
    }

    private boolean setCurrentAccount() {
        this.defaultAccount = this.parent.displayHandler.getSelectedAccount();
        return this.defaultAccount != null;
    }

    private void searchFirst() {
        if (this.setCurrentAccount()) {
            this.performSearch(true);
        }
    }

    private void searchNext() {
        if (this.setCurrentAccount()) {
            this.performSearch(false);
        }
    }

    private void setGlobalButton() {
        this.searchGlobalButton.setEnabled(!this.globalSearch);
        this.firstButton.setEnabled(!this.globalSearch);
    }

    public void newGlobalSearch() {
        this.searchForward = !this.reverseCheckBox.isSelected();
        this.globalSearch = true;
        this.setGlobalButton();
        this.globalCounter = 0;
        this.globalTotal = 0;
        this.globalPointer = this.parent.accountHandler.indexForAccount(this.defaultAccount);
        this.performSearchGlobal();
    }

    public void performSearchGlobal() {
        final Account account = this.defaultAccount;
        if (this.searchThread != null && this.searchThread.isAlive()) {
            this.parent.beep();
            return;
        }
        this.searchThread = new Thread(){

            @Override
            public void run() {
                SearchPanel.this.performSearchGlobalInThread(account);
            }
        };
        this.searchThread.start();
        this.setupTimer();
    }

    private void setupTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.timer = null;
        }
        this.timer = new Timer(this.timerInterval, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.handleThreadReply();
            }
        });
        this.timer.start();
    }

    private void handleThreadReply() {
        if (this.threadReply != null) {
            this.timer.stop();
            this.timer = null;
            this.parent.displayHandler.addTest(this.threadReply.acc, this.threadReply.record);
            this.parent.beep();
            ++this.globalTotal;
            this.threadReply = null;
        }
    }

    public void performSearchGlobalInThread(Account account) {
        int n = 0;
        String[] stringArray = this.parent.accountHandler.getAccountFileNames();
        int n2 = stringArray.length;
        while (this.globalCounter < stringArray.length && n == 0) {
            int n3 = this.globalPointer % n2;
            Account account2 = this.parent.accountHandler.getAccountByFileName(stringArray[n3]);
            ++this.globalPointer;
            n = this.performSearchInThread(account2, account, true);
            ++this.globalCounter;
        }
        if (this.globalCounter >= n2) {
            this.globalCounter = 0;
            this.globalSearch = false;
            this.setGlobalButton();
            JOptionPane.showMessageDialog(this.defaultAccountDisplay, "Searched " + n2 + " accounts,\nfound " + this.globalTotal + " case(s) of \"" + this.searchTextField.getText() + "\"", "Finished search", 1);
        }
    }

    public void performSearch(boolean bl) {
        if (this.globalSearch) {
            this.performSearchGlobal();
        } else {
            this.searchForward = !this.reverseCheckBox.isSelected();
            this.performSearch(this.defaultAccount, bl);
        }
    }

    private void performSearch(final Account account, final boolean bl) {
        final Account account2 = this.defaultAccount;
        if (this.searchThread != null && this.searchThread.isAlive()) {
            this.parent.beep();
            return;
        }
        this.searchThread = new Thread(){

            @Override
            public void run() {
                SearchPanel.this.performSearchInThread(account, account2, bl);
            }
        };
        this.searchThread.start();
        this.setupTimer();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int performSearchInThread(Account account, Account account2, boolean bl) {
        String string = this.searchTextField.getText();
        if (string.length() == 0) {
            this.parent.beep();
            JOptionPane.showMessageDialog(account2.accountDisplay, "Please enter some text\n to search for.", "No Text Entered", 2);
            return -1;
        }
        this.saveSearchValues();
        int n = this.modeComboBox.getSelectedIndex();
        int n2 = 0;
        int n3 = account.size();
        if (!this.globalSearch && (n2 = account.getAccountDisplay().getSelectedRecord()) == -1) {
            n2 = this.searchForward ? 0 : n3 - 1;
        }
        int n4 = n2;
        this.startProgressBar(0L, n3, n2);
        if (bl) {
            n2 += this.searchForward ? -1 : 1;
        }
        boolean bl2 = this.isCaseSensitive();
        String string2 = this.isCaseSensitive() ? string : string.toLowerCase();
        boolean bl3 = false;
        boolean bl4 = true;
        do {
            if ((n2 += this.searchForward ? 1 : -1) == n3) {
                if (this.globalSearch) {
                    n2 = -1;
                } else {
                    int n5 = JOptionPane.showConfirmDialog(account2.accountDisplay, "Reached end of account.\nContinue at beginning?", "Reached End", 0);
                    if (n5 != 0) return 0;
                    n2 = -1;
                }
            } else if (n2 == -1) {
                if (this.globalSearch) {
                    n2 = n3;
                } else {
                    int n6 = JOptionPane.showConfirmDialog(account2.accountDisplay, "Reached beginning of account.\nContinue at end?", "Reached Beginning", 0);
                    if (n6 != 0) return 0;
                    n2 = n3;
                }
            } else if (n2 == n4 && !bl4) {
                if (this.globalSearch) {
                    return 0;
                }
                JOptionPane.showMessageDialog(account2.accountDisplay, "Finished searching for \"" + string2 + "\".", "End Search", 1);
                return 0;
            }
            bl4 = false;
            Transaction transaction = account.getTransaction(n2);
            this.updateProgressBar(n2);
            bl3 = this.searchTransaction(transaction, string2, n, bl2);
            if (!bl3) continue;
            this.threadReply = new ThreadAccountRecord(account, n2);
        } while (!bl3);
        this.stopProgressBar();
        return 1;
    }

    private boolean searchTransaction(Transaction transaction, String string, int n, boolean bl) {
        boolean bl2;
        boolean bl3 = false;
        String[] stringArray = new String[]{""};
        String string2 = this.selectedSearchField();
        stringArray = string2.equals("Any Field") ? this.fieldNames : new String[]{this.fieldNames[this.selectedSearchIndex() - 1]};
        long l = this.parent.commonCode.timeForDisplayDateLenient(string);
        long l2 = 0L;
        boolean bl4 = l > 0L;
        double d = 0.0;
        double d2 = 0.0;
        Double d3 = this.parent.commonCode.safeParseDouble(string);
        boolean bl5 = bl2 = d3 != null;
        if (bl2) {
            d = d3;
        }
        try {
            block14: for (int i = 0; i < stringArray.length && !bl3; ++i) {
                Field field = transaction.getClass().getField(stringArray[i]);
                String string3 = this.parent.commonCode.getFieldValueAsString(field, transaction);
                if (!bl) {
                    string3 = string3.toLowerCase();
                }
                boolean bl6 = false;
                if (bl4 && (bl6 = stringArray[i].equals("db_Date"))) {
                    l2 = this.parent.commonCode.timeForDbDate(string3);
                }
                boolean bl7 = false;
                if (bl2 && (bl7 = field.getType().isAssignableFrom(Double.TYPE))) {
                    try {
                        d2 = (Double)field.get(transaction);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (bl7) {
                    // empty if block
                }
                switch (n) {
                    case 0: {
                        bl3 = string3.indexOf(string) != -1;
                        continue block14;
                    }
                    case 1: {
                        if (bl6) {
                            bl3 = l2 == l;
                            continue block14;
                        }
                        if (bl7) {
                            bl3 = d2 == d;
                            continue block14;
                        }
                        bl3 = string3.equals(string);
                        continue block14;
                    }
                    case 2: {
                        bl3 = string3.indexOf(string) == 0;
                        continue block14;
                    }
                    case 3: {
                        bl3 = string3.indexOf(string) == string3.length() - string.length();
                        continue block14;
                    }
                    case 4: {
                        if (bl6) {
                            bl3 = l2 > l;
                            continue block14;
                        }
                        if (bl7) {
                            bl3 = d2 > d;
                            continue block14;
                        }
                        bl3 = string3.compareTo(string) > 0;
                        continue block14;
                    }
                    case 5: {
                        if (bl6) {
                            bl3 = l2 >= l;
                            continue block14;
                        }
                        if (bl7) {
                            bl3 = d2 >= d;
                            continue block14;
                        }
                        bl3 = string3.compareTo(string) >= 0;
                        continue block14;
                    }
                    case 6: {
                        if (bl4) {
                            bl3 = l2 < l;
                            continue block14;
                        }
                        if (bl7) {
                            bl3 = d2 < d;
                            continue block14;
                        }
                        bl3 = string3.compareTo(string) < 0;
                        continue block14;
                    }
                    case 7: {
                        bl3 = bl4 ? l2 <= l : (bl7 ? d2 <= d : string3.compareTo(string) <= 0);
                    }
                }
            }
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
        }
        return bl3;
    }

    private void setCaseSensitive() {
        this.parent.programValues.db_CaseSensitiveAccountSearch = this.isCaseSensitive();
    }

    private boolean isCaseSensitive() {
        return this.parent.programValues.db_CaseSensitiveAccountSearch;
    }

    public void startProgressBar(long l, long l2, long l3) {
        this.progressBar.setMinimum((int)l);
        this.progressBar.setMaximum((int)l2);
        this.progressBar.setValue((int)l2);
    }

    public void updateProgressBar(long l) {
        this.progressBar.setValue((int)l);
    }

    public void stopProgressBar() {
        this.progressBar.setValue(this.progressBar.getMinimum());
    }

    private void help_accountsearch() {
        this.parent.launchHelp("AdvancedOperations.html#Searching_for_transactions");
    }

    private void initComponents() {
        this.searchTextField = new JTextField();
        this.fieldComboBox = new JComboBox();
        this.modeComboBox = new JComboBox();
        this.caseCheckBox = new JCheckBox();
        this.reverseCheckBox = new JCheckBox();
        this.firstButton = new MyJButton();
        this.nextButton = new MyJButton();
        this.searchGlobalButton = new MyJButton();
        this.closeButton = new MyJButton();
        this.helpButton = new MyJButton();
        this.progressBar = new JProgressBar();
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder("Search in account"));
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SearchPanel.this.formKeyPressed(keyEvent);
            }
        });
        this.searchTextField.setToolTipText("What to search for");
        this.searchTextField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                SearchPanel.this.searchTextFieldKeyTyped(keyEvent);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SearchPanel.this.searchTextFieldKeyPressed(keyEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.searchTextField, gridBagConstraints);
        this.fieldComboBox.setToolTipText("Where to search");
        this.fieldComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SearchPanel.this.fieldComboBoxKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.fieldComboBox, gridBagConstraints);
        this.modeComboBox.setToolTipText("How to search");
        this.modeComboBox.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SearchPanel.this.modeComboBoxKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.modeComboBox, gridBagConstraints);
        this.caseCheckBox.setText("Case");
        this.caseCheckBox.setToolTipText("Make search case sensitive");
        this.caseCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                SearchPanel.this.caseCheckBoxItemStateChanged(itemEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add((Component)this.caseCheckBox, gridBagConstraints);
        this.reverseCheckBox.setText("Reverse");
        this.reverseCheckBox.setToolTipText("Search in reverse");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        this.add((Component)this.reverseCheckBox, gridBagConstraints);
        this.firstButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRStop.png")));
        this.firstButton.setToolTipText("Find first match");
        this.firstButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.firstButtonActionPerformed(actionEvent);
            }
        });
        this.firstButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SearchPanel.this.firstButtonKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.firstButton, gridBagConstraints);
        this.nextButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/VCRPlay.png")));
        this.nextButton.setToolTipText("Find next match");
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.nextButtonActionPerformed(actionEvent);
            }
        });
        this.nextButton.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                SearchPanel.this.nextButtonKeyPressed(keyEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.nextButton, gridBagConstraints);
        this.searchGlobalButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/World2.png")));
        this.searchGlobalButton.setToolTipText("Global search, all accounts");
        this.searchGlobalButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.searchGlobalButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.searchGlobalButton, gridBagConstraints);
        this.closeButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/FolderOut.png")));
        this.closeButton.setToolTipText("Close search window");
        this.closeButton.setFocusable(false);
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.closeButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 9;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.closeButton, gridBagConstraints);
        this.helpButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/Help.png")));
        this.helpButton.setToolTipText("Provide context-sensitive help");
        this.helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchPanel.this.helpButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.add((Component)this.helpButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 10;
        gridBagConstraints.fill = 2;
        this.add((Component)this.progressBar, gridBagConstraints);
    }

    private void helpButtonActionPerformed(ActionEvent actionEvent) {
        this.help_accountsearch();
    }

    private void searchGlobalButtonActionPerformed(ActionEvent actionEvent) {
        this.newGlobalSearch();
    }

    private void caseCheckBoxItemStateChanged(ItemEvent itemEvent) {
        this.setCaseSensitive();
    }

    private void nextButtonActionPerformed(ActionEvent actionEvent) {
        this.searchNext();
    }

    private void firstButtonActionPerformed(ActionEvent actionEvent) {
        this.searchFirst();
    }

    private void searchTextFieldKeyTyped(KeyEvent keyEvent) {
        this.processFindKey(this.searchTextField, keyEvent);
    }

    private void searchTextFieldKeyPressed(KeyEvent keyEvent) {
        this.processKey(keyEvent);
    }

    private void modeComboBoxKeyPressed(KeyEvent keyEvent) {
        this.processKey(keyEvent);
    }

    private void nextButtonKeyPressed(KeyEvent keyEvent) {
        this.processKey(keyEvent);
    }

    private void firstButtonKeyPressed(KeyEvent keyEvent) {
        this.processKey(keyEvent);
    }

    private void fieldComboBoxKeyPressed(KeyEvent keyEvent) {
        this.processKey(keyEvent);
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        this.processKey(keyEvent);
    }

    private void closeButtonActionPerformed(ActionEvent actionEvent) {
        this.closeThis();
    }

    class ThreadAccountRecord {
        Account acc;
        int record;

        public ThreadAccountRecord(Account account, int n) {
            this.acc = account;
            this.record = n;
        }
    }
}

