/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Stack;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class SearchEngine {
    String[] comparators = new String[]{"=", "==", ">=", "<=", "<", ">", "!=", "<>"};
    String[] logics = new String[]{"and", "or", "&&", "||", "&", "|"};
    String anyFieldTag = "any";
    String[] fields = new String[]{"date", "number", "payee", "address", "memo", "amount", "cleared", "category", "price", "shares", "commission", "security", this.anyFieldTag};
    String opTokens = "<>=!";
    String logicTokens = "&|";
    PLCash parent;
    ReportGeneratorForm reportForm;
    String searchString;
    Vector comStack;
    TreeSet comparatorMap;
    TreeSet logicMap;
    TreeSet fieldMap;
    Vector comSet;
    boolean regexSyntaxError = false;

    public SearchEngine(PLCash pLCash, ReportGeneratorForm reportGeneratorForm) {
        this.parent = pLCash;
        this.reportForm = reportGeneratorForm;
        this.searchString = reportGeneratorForm.getSearchString();
        this.comparatorMap = new TreeSet<String>(Arrays.asList(this.comparators));
        this.logicMap = new TreeSet<String>(Arrays.asList(this.logics));
        this.fieldMap = new TreeSet<String>(Arrays.asList(this.fields));
        if (this.reportForm.reportDesign.db_enableSearching) {
            this.reportForm.showResult("");
            this.comSet = this.parseSearch(this.searchString);
            this.examine(new Transaction(this.parent));
            if (this.parent.programValues.db_ShowDebugData) {
                this.dumpStack(this.comSet);
            }
        }
    }

    private void dumpStack(Vector vector) {
        String[] stringArray = vector.toArray(new String[vector.size()]);
        String string = this.parent.commonCode.join(stringArray, "\n");
        string = "[" + string.replaceAll("\\n", "][") + "]";
        this.reportForm.addResult("Translated to postfix form:\n" + string + "\n");
    }

    private Vector parseSearch(String string) {
        Vector vector = new Vector();
        Vector vector2 = new Vector();
        vector2 = this.tokenizeString(string);
        this.toPostfix(vector, vector2);
        return vector;
    }

    private void toPostfix(Vector vector, Vector vector2) {
        if (vector2 == null || vector2.size() == 0) {
            return;
        }
        Stack<String> stack = new Stack<String>();
        Stack<String> stack2 = new Stack<String>();
        Stack<String> stack3 = new Stack<String>();
        int n = 0;
        do {
            String[] stringArray;
            String string;
            if ((string = (String)vector2.get(n)).equals("(")) {
                int n2 = this.findClosingParen(vector2, n);
                if (n2 == -1) {
                    this.reportForm.addResult("Error: unbalanced parentheses.\n");
                    return;
                }
                if (n < n2 - 1) {
                    stringArray = new Vector(vector2.subList(n + 1, n2));
                    this.toPostfix(vector, (Vector)stringArray);
                }
                n = n2;
            } else if (this.lcContains(this.comparatorMap, string)) {
                stack2.push(string);
            } else if (this.lcContains(this.logicMap, string)) {
                stack3.push(string);
            } else {
                stack.push(string);
            }
            if (stack.size() != 2 || stack2.size() <= 0) continue;
            String string2 = (String)stack.firstElement();
            if (!this.lcContains(this.fieldMap, string2)) {
                this.reportForm.addResult("Error: field ID \"" + string2 + "\" not recognized.\n");
                stringArray = this.fieldMap.toArray(new String[0]);
                String string3 = this.parent.commonCode.join(stringArray, "|");
                this.reportForm.addResult("Permitted field IDs: " + string3 + "\n");
            }
            for (int i = 0; i < 2; ++i) {
                string = (String)stack.firstElement();
                stack.remove(0);
                if (string == null) continue;
                vector.add(string);
            }
            vector.add(stack2.pop());
        } while (++n < vector2.size());
        while (stack3.size() > 0) {
            vector.add(stack3.pop());
        }
    }

    private boolean lcContains(TreeSet treeSet, String string) {
        if (string == null) {
            return false;
        }
        return treeSet.contains(string.toLowerCase());
    }

    private int findClosingParen(Vector vector, int n) {
        int n2 = 0;
        String string = "";
        int n3 = 0;
        for (n3 = n; n3 < vector.size(); ++n3) {
            string = (String)vector.get(n3);
            if (string.equals("(")) {
                ++n2;
                continue;
            }
            if (!string.equals(")") || --n2 != 0) continue;
            return n3;
        }
        return -1;
    }

    public Vector tokenizeString(String string) {
        if (string == null) {
            return null;
        }
        Vector vector = new Vector();
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        boolean bl = false;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == '\\') {
                if (bl) {
                    stringBuffer.append(c);
                }
                bl = !bl;
                continue;
            }
            if (c == '\"') {
                if (bl) {
                    stringBuffer.append(c);
                } else if (n2 == 3) {
                    this.addToVec(vector, stringBuffer);
                    stringBuffer = new StringBuffer();
                    n2 = 0;
                } else {
                    if (n2 != 0) {
                        this.addToVec(vector, stringBuffer);
                        stringBuffer = new StringBuffer();
                    }
                    n2 = 3;
                }
            } else if (n2 == 3) {
                stringBuffer.append(c);
            } else if (c == ' ') {
                if (n2 == 3) {
                    stringBuffer.append(c);
                } else if (n2 != 0) {
                    this.addToVec(vector, stringBuffer);
                    stringBuffer = new StringBuffer();
                }
                n2 = 0;
            } else if (c == ')' || c == '(') {
                if (n2 == 3) {
                    stringBuffer.append(c);
                } else {
                    if (n2 != 0) {
                        this.addToVec(vector, stringBuffer);
                        stringBuffer = new StringBuffer();
                    }
                    stringBuffer.append(c);
                    this.addToVec(vector, stringBuffer);
                    stringBuffer = new StringBuffer();
                    n2 = 0;
                }
            } else if (this.opTokens.indexOf(c) != -1) {
                if (n2 != 1 && n2 != 0) {
                    this.addToVec(vector, stringBuffer);
                    stringBuffer = new StringBuffer();
                }
                n2 = 1;
                stringBuffer.append(c);
            } else if (this.logicTokens.indexOf(c) != -1) {
                if (n2 != 4 && n2 != 0) {
                    this.addToVec(vector, stringBuffer);
                    stringBuffer = new StringBuffer();
                }
                n2 = 4;
                stringBuffer.append(c);
            } else if (this.isAlphanumeric(c)) {
                if (n2 != 2 && n2 != 0) {
                    this.addToVec(vector, stringBuffer);
                    stringBuffer = new StringBuffer();
                }
                n2 = 2;
                stringBuffer.append(c);
            }
            bl = false;
        }
        if (n2 != 0) {
            this.addToVec(vector, stringBuffer);
        }
        return vector;
    }

    private boolean isAlphanumeric(char c) {
        return Character.isLetterOrDigit(c) || ".-+".indexOf(c) != -1;
    }

    private void addToVec(Vector vector, StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        string = this.minimizeComparatorTokens(string);
        vector.add(string);
    }

    private String minimizeComparatorTokens(String string) {
        if (this.comparatorMap.contains(string)) {
            if (string.equals("<>")) {
                string = "!=";
            } else if (string.equals("=")) {
                string = "==";
            }
        } else if (this.logicMap.contains(string)) {
            if (string.equals("and")) {
                string = "&&";
            } else if (string.equals("&")) {
                string = "&&";
            } else if (string.equals("or")) {
                string = "||";
            } else if (string.equals("|")) {
                string = "||";
            }
        }
        return string;
    }

    public boolean examine(Transaction transaction) {
        boolean bl = false;
        boolean bl2 = false;
        Stack<Object> stack = new Stack<Object>();
        Stack<Boolean> stack2 = new Stack<Boolean>();
        for (int i = 0; i < this.comSet.size(); ++i) {
            String string = (String)this.comSet.get(i);
            if (this.fieldMap.contains(string.toLowerCase())) {
                if (string.equals(this.anyFieldTag)) {
                    stack.push(string);
                    continue;
                }
                stack.push(this.getFieldObject(string, transaction));
                continue;
            }
            if (this.comparatorMap.contains(string)) {
                stack2.push(this.compareTest(stack, string, transaction));
                continue;
            }
            if (this.logicMap.contains(string)) {
                stack2.push(this.logicTest(stack2, string, transaction));
                continue;
            }
            stack.push(string);
        }
        if (stack2.size() == 1) {
            bl = (Boolean)stack2.pop();
        }
        return bl;
    }

    private Boolean logicTest(Stack stack, String string, Transaction transaction) {
        boolean bl = false;
        if (stack.size() >= 2) {
            boolean bl2 = (Boolean)stack.pop();
            boolean bl3 = (Boolean)stack.pop();
            bl = string.equals("||") ? bl3 || bl2 : bl3 && bl2;
        }
        return new Boolean(bl);
    }

    private Boolean compareTest(Stack stack, String string, Transaction transaction) {
        boolean bl = false;
        if (stack.size() >= 2) {
            Object e = stack.pop();
            Object e2 = stack.pop();
            if (e2 instanceof String && ((String)e2).equals(this.anyFieldTag)) {
                for (int i = 0; i < this.fields.length && !bl; ++i) {
                    if (this.fields[i].equals(this.anyFieldTag)) continue;
                    Object object = this.getFieldObject(this.fields[i], transaction);
                    bl |= this.compareTest2(object, e, string);
                }
            } else {
                bl = this.compareTest2(e2, e, string);
            }
        }
        return new Boolean(bl);
    }

    private boolean compareTest2(Object object, Object object2, String string) {
        boolean bl = false;
        if (object instanceof String && object2 instanceof String) {
            String string2 = (String)object;
            String string3 = (String)object2;
            long l = this.parent.commonCode.timeForDbDate(string2);
            long l2 = this.parent.commonCode.timeForDisplayDateLenient(string3);
            if (l >= 0L && l2 >= 0L) {
                bl = this.compareTimes(l, l2, string);
            } else if (l >= 0L) {
                String string4 = this.parent.commonCode.displayDateForTime(l);
                bl = this.compareStrings(string4, string3, string);
            } else {
                bl = this.compareStrings(string2, string3, string);
            }
        } else if (object instanceof Double || object2 instanceof Double) {
            Double d = null;
            Double d2 = null;
            if (object instanceof Double) {
                d = (Double)object;
                d2 = this.parent.commonCode.safeParseDouble(object2.toString());
                if (d2 == null) {
                    return false;
                }
            } else if (object2 instanceof Double) {
                d2 = (Double)object2;
                d = this.parent.commonCode.safeParseDouble(object.toString());
                if (d == null) {
                    return false;
                }
            }
            if (d != null && d2 != null) {
                bl = this.compareDoubles(d, d2, string);
            }
        }
        return bl;
    }

    private boolean compareDoubles(double d, double d2, String string) {
        if (string.equals("==")) {
            return d == d2;
        }
        if (string.equals("!=")) {
            return d != d2;
        }
        if (string.equals(">=")) {
            return d >= d2;
        }
        if (string.equals("<=")) {
            return d <= d2;
        }
        if (string.equals(">")) {
            return d > d2;
        }
        if (string.equals("<")) {
            return d < d2;
        }
        return false;
    }

    private boolean compareTimes(long l, long l2, String string) {
        if (string.equals("==")) {
            return l == l2;
        }
        if (string.equals("!=")) {
            return l != l2;
        }
        if (string.equals(">=")) {
            return l >= l2;
        }
        if (string.equals("<=")) {
            return l <= l2;
        }
        if (string.equals(">")) {
            return l > l2;
        }
        if (string.equals("<")) {
            return l < l2;
        }
        return false;
    }

    private boolean compareStrings(String string, String string2, String string3) {
        boolean bl;
        block5: {
            bl = false;
            try {
                Pattern pattern = this.parent.programValues.db_CaseSensitiveReportSearch ? Pattern.compile(string2) : Pattern.compile(string2, 2);
                bl = pattern.matcher(string).matches();
            }
            catch (PatternSyntaxException patternSyntaxException) {
                if (this.regexSyntaxError) break block5;
                this.reportForm.addResult("Error: the regular expression parser reports: " + patternSyntaxException.getMessage() + "\n");
                this.regexSyntaxError = true;
            }
        }
        if (string3.equals("!=")) {
            bl = !bl;
        } else if (!string3.equals("==")) {
            this.reportForm.addResult("Error: operator '" + string3 + "\" is not valid for string comparisons. Only (\"==\" or \"=\") and (\"!=\" or \"<>\") are valid.\n");
        }
        return bl;
    }

    private Object getFieldObject(String string, Object object) {
        Object object2 = null;
        try {
            String string2 = "db_" + string.substring(0, 1).toUpperCase() + string.substring(1).toLowerCase();
            Field field = object.getClass().getDeclaredField(string2);
            object2 = field.get(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return object2;
    }
}

