/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public final class ReconcileTable
extends JPanel {
    PLCash parent;
    Account account;
    ReconcileForm reconcileForm;
    boolean credits = false;
    int rows = 0;
    Vector aliasList = null;
    Vector filterList = null;
    Font displayFont;
    EmptyBorder tableCellBorder;
    FloatingWindow floatingWindow;
    final String[] headerNames = new String[]{"C", "Date", "Check", "Payee", "Amount"};
    int[] colWidths = new int[]{2, 14, 8, -1, 20};
    private JScrollPane scrollPane;
    private JMenuItem doneMenuItem;
    private JCheckBoxMenuItem viewTableContentsCheckBoxMenuItem;
    private JLabel totalLabel;
    private JTable dataTable;
    private JPanel jPanel1;
    private JPopupMenu popupMenu;
    private JMenuItem cancelMenuItem;

    public ReconcileTable(PLCash pLCash, Account account, ReconcileForm reconcileForm, boolean bl) {
        this.credits = bl;
        this.parent = pLCash;
        this.account = account;
        this.reconcileForm = reconcileForm;
        this.displayFont = new Font("Monospaced", 0, this.parent.programValues.db_TableFontSize);
        this.setFont(this.displayFont);
        this.tableCellBorder = new EmptyBorder(0, 2, 0, 2);
        this.initComponents();
        this.dataTable.setFont(this.displayFont);
        this.setViewTableContents(false);
        this.floatingWindow = new FloatingWindow(this.displayFont);
        this.scrollPane.getVerticalScrollBar().addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                ReconcileTable.this.scrollVertMouseDragged(mouseEvent);
            }
        });
        this.scrollPane.getVerticalScrollBar().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ReconcileTable.this.scrollVertMouseReleased(mouseEvent);
            }
        });
        this.setBorder(new TitledBorder(this.credits ? "Credits" : "Debits"));
        this.createAliasArray();
    }

    public void setup() {
        boolean bl = this.reconcileForm.getShowAllFlag();
        this.setupList(bl);
        this.setupTable();
    }

    private void createAliasArray() {
        this.aliasList = new Vector();
        int n = this.account.size();
        for (int i = 0; i < n; ++i) {
            Transaction transaction = this.account.getTransaction(i);
            if (!(this.credits ? transaction.db_Amount >= 0.0 : transaction.db_Amount < 0.0)) continue;
            this.aliasList.add(new TransAlias(transaction));
        }
    }

    private void setupList(boolean bl) {
        this.filterList = new Vector();
        int n = this.aliasList.size();
        for (int i = 0; i < n; ++i) {
            TransAlias transAlias = (TransAlias)this.aliasList.get(i);
            if (!bl && transAlias.cleared) continue;
            this.filterList.add(transAlias);
        }
        this.rows = this.filterList.size();
    }

    private void setupTable() {
        Vector<String> vector = new Vector<String>(Arrays.asList(this.headerNames));
        DefaultTableModel defaultTableModel = new DefaultTableModel(vector, this.rows){

            @Override
            public boolean isCellEditable(int n, int n2) {
                return n2 == 0;
            }

            public Class getColumnClass(int n) {
                return n == 0 ? JCheckBox.class : JTextField.class;
            }
        };
        this.dataTable.setDefaultRenderer(Object.class, new MyTableCellRenderer());
        MyCellEditor myCellEditor = new MyCellEditor(new JCheckBox());
        this.dataTable.setDefaultEditor(JCheckBox.class, myCellEditor);
        this.dataTable.setModel(defaultTableModel);
        this.setColumnWidths(this.dataTable);
        this.scrollToEnd();
    }

    private void setColumnWidths(JTable jTable) {
        TableColumn tableColumn = null;
        FontMetrics fontMetrics = jTable.getFontMetrics(this.displayFont);
        int n = fontMetrics.charWidth('W');
        int n2 = fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading();
        jTable.setRowHeight(n2);
        for (int i = 0; i < this.colWidths.length; ++i) {
            tableColumn = jTable.getColumnModel().getColumn(i);
            if (this.colWidths[i] <= 0) continue;
            Insets insets = this.tableCellBorder.getBorderInsets();
            int n3 = this.colWidths[i] * n + insets.left * 2 + insets.right * 2;
            tableColumn.setPreferredWidth(n3);
            tableColumn.setMaxWidth(n3);
            tableColumn.setMinWidth(n3);
        }
    }

    public double processChange() {
        Object object;
        if (this.filterList == null) {
            return 0.0;
        }
        int n = this.filterList.size();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            object = (TransAlias)this.filterList.get(i);
            if (!((TransAlias)object).cleared) continue;
            d += ((TransAlias)object).t.db_Amount;
        }
        String string = this.credits ? "Credit" : "Debit";
        object = "Total of " + string + "s: " + this.parent.commonCode.getCurrencyDollarCentString(d, false);
        this.totalLabel.setText((String)object);
        return d;
    }

    private void scrollToEnd() {
        if (this.filterList != null && this.filterList.size() > 0) {
            this.dataTable.scrollRectToVisible(this.dataTable.getCellRect(this.filterList.size() - 1, 0, true));
        }
    }

    public void commitChanges() {
        for (int i = 0; i < this.aliasList.size(); ++i) {
            ((TransAlias)this.aliasList.get(i)).commit();
        }
    }

    private void scrollVertMouseDragged(MouseEvent mouseEvent) {
        if (!this.handleMenu(mouseEvent) && !this.parent.programValues.db_ShowTableContentsWhileScrolling) {
            this.scrollPane.getViewport().setVisible(false);
            JScrollBar jScrollBar = this.scrollPane.getVerticalScrollBar();
            double d = this.scrollPane.getViewport().getSize().height;
            double d2 = jScrollBar.getMaximum() - jScrollBar.getVisibleAmount();
            double d3 = jScrollBar.getValue();
            double d4 = d3 / d2;
            int n = this.dataTable.rowAtPoint(new Point(0, (int)(d3 += d4 * d)));
            if (n == -1) {
                n = this.dataTable.getRowCount() - 1;
            }
            TransAlias transAlias = (TransAlias)this.filterList.get(n);
            long l = transAlias.t.getTime();
            this.floatingWindow.setMessage(this.parent.commonCode.mediumDateForTime(l));
            Point point = jScrollBar.getLocationOnScreen();
            int n2 = point.x - (this.floatingWindow.getSize().width + 8);
            int n3 = mouseEvent.getY() + point.y - this.floatingWindow.getSize().height / 2;
            this.floatingWindow.showAt(new Point(n2, n3));
        }
    }

    private void scrollVertMouseReleased(MouseEvent mouseEvent) {
        if (!this.handleMenu(mouseEvent) && !this.parent.programValues.db_ShowTableContentsWhileScrolling) {
            this.floatingWindow.hideWindow();
            this.scrollPane.getViewport().setVisible(true);
        }
    }

    private boolean handleMenu(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            return true;
        }
        return false;
    }

    private void setViewTableContents(boolean bl) {
        if (bl) {
            this.parent.programValues.db_ShowTableContentsWhileScrolling = this.viewTableContentsCheckBoxMenuItem.isSelected();
        } else {
            this.viewTableContentsCheckBoxMenuItem.setSelected(this.parent.programValues.db_ShowTableContentsWhileScrolling);
        }
    }

    private void initComponents() {
        this.popupMenu = new JPopupMenu();
        this.doneMenuItem = new JMenuItem();
        this.cancelMenuItem = new JMenuItem();
        this.viewTableContentsCheckBoxMenuItem = new JCheckBoxMenuItem();
        this.scrollPane = new JScrollPane();
        this.dataTable = new JTable();
        this.jPanel1 = new JPanel();
        this.totalLabel = new JLabel();
        this.doneMenuItem.setText("Item");
        this.popupMenu.add(this.doneMenuItem);
        this.cancelMenuItem.setText("Item");
        this.popupMenu.add(this.cancelMenuItem);
        this.viewTableContentsCheckBoxMenuItem.setText("View contents while scrolling");
        this.viewTableContentsCheckBoxMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ReconcileTable.this.viewTableContentsCheckBoxMenuItemActionPerformed(actionEvent);
            }
        });
        this.popupMenu.add(this.viewTableContentsCheckBoxMenuItem);
        this.setLayout(new BorderLayout());
        this.scrollPane.setBackground(new Color(255, 255, 255));
        this.scrollPane.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ReconcileTable.this.scrollPaneMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ReconcileTable.this.scrollPaneMouseReleased(mouseEvent);
            }
        });
        this.dataTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        this.dataTable.setRowMargin(0);
        this.dataTable.setShowHorizontalLines(false);
        this.dataTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                ReconcileTable.this.dataTableMousePressed(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                ReconcileTable.this.dataTableMouseReleased(mouseEvent);
            }
        });
        this.scrollPane.setViewportView(this.dataTable);
        this.add((Component)this.scrollPane, "Center");
        this.jPanel1.setLayout(new BorderLayout());
        this.totalLabel.setHorizontalAlignment(4);
        this.totalLabel.setText("jLabel1");
        this.jPanel1.add((Component)this.totalLabel, "Center");
        this.add((Component)this.jPanel1, "South");
    }

    private void viewTableContentsCheckBoxMenuItemActionPerformed(ActionEvent actionEvent) {
        this.setViewTableContents(true);
    }

    private void scrollPaneMouseReleased(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void scrollPaneMousePressed(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void dataTableMouseReleased(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    private void dataTableMousePressed(MouseEvent mouseEvent) {
        this.handleMenu(mouseEvent);
    }

    class MyCellEditor
    extends DefaultCellEditor {
        JCheckBox box;

        public MyCellEditor(JCheckBox jCheckBox) {
            super(jCheckBox);
            this.box = jCheckBox;
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TransAlias transAlias = (TransAlias)ReconcileTable.this.filterList.get(n);
            this.box.setSelected(transAlias.cleared);
            return this.box;
        }
    }

    final class MyTableCellRenderer
    extends JLabel
    implements TableCellRenderer {
        public MyTableCellRenderer() {
            this.setOpaque(true);
            this.setVerticalAlignment(0);
            this.setFont(ReconcileTable.this.displayFont);
            this.setBorder(ReconcileTable.this.tableCellBorder);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Color color = (n & 1) == 0 ? ReconcileTable.this.parent.programValues.db_EvenRowColor : ReconcileTable.this.parent.programValues.db_OddRowColor;
            this.setHorizontalAlignment(n2 != 3 ? 4 : 2);
            JComponent jComponent = this;
            TransAlias transAlias = (TransAlias)ReconcileTable.this.filterList.get(n);
            switch (n2) {
                case 0: {
                    JCheckBox jCheckBox = new JCheckBox();
                    if (object instanceof Boolean) {
                        boolean bl3 = (Boolean)object;
                        jCheckBox.setSelected(bl3);
                        transAlias.cleared = bl3;
                        ReconcileTable.this.reconcileForm.processChange();
                    } else {
                        jCheckBox.setSelected(transAlias.cleared);
                    }
                    jComponent = jCheckBox;
                    break;
                }
                case 1: {
                    this.setText(ReconcileTable.this.parent.commonCode.displayDateForTime(transAlias.t.getTime()));
                    break;
                }
                case 2: {
                    this.setText(transAlias.t.db_Number);
                    break;
                }
                case 3: {
                    this.setText(transAlias.t.db_Payee);
                    break;
                }
                case 4: {
                    this.setText(ReconcileTable.this.parent.commonCode.getCurrencyDollarCentString(transAlias.t.db_Amount, false));
                }
            }
            ((Component)jComponent).setBackground(color);
            return jComponent;
        }
    }
}

