/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.util.Stack;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;

public final class DisplayHandler {
    PLCash parent;
    JTabbedPane tabbedPane;
    Stack forward;
    Stack backward;

    public DisplayHandler(PLCash pLCash, JTabbedPane jTabbedPane) {
        this.parent = pLCash;
        this.tabbedPane = jTabbedPane;
    }

    public void setSelectedTab(int n) {
        if (n >= 0 && n < this.tabbedPane.getTabCount()) {
            this.tabbedPane.setSelectedIndex(n);
        }
    }

    public int getSelectedTab() {
        return this.tabbedPane.getSelectedIndex();
    }

    public Account getSelectedAccount() {
        Component component = this.tabbedPane.getSelectedComponent();
        if (component instanceof AccountDisplay) {
            return ((AccountDisplay)component).account;
        }
        return null;
    }

    public void addComp(String string, JComponent jComponent) {
        int n = this.tabbedPane.indexOfComponent(jComponent);
        if (n != -1) {
            this.tabbedPane.setSelectedIndex(n);
        } else {
            this.tabbedPane.addTab(string, jComponent);
            this.tabbedPane.setSelectedComponent(jComponent);
        }
    }

    public String[] getOpenAccountList() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            vector.add(this.tabbedPane.getTitleAt(i));
        }
        return vector.toArray(new String[0]);
    }

    public void addTest(Account account) {
        this.addTest(account, -1);
    }

    public void addTest(Account account, int n) {
        if (account != null) {
            this.addComp(account.db_Name, account.getAccountDisplay(n));
            account.refreshTable();
        }
    }

    public void closeSelectedTab() {
        int n = this.tabbedPane.getSelectedIndex();
        if (n > 0) {
            this.closeTab(n);
        } else {
            this.parent.beep();
        }
    }

    public void closeTab(int n) {
        if (n > 0 && n < this.tabbedPane.getTabCount()) {
            Component component = this.tabbedPane.getComponentAt(n);
            if (component instanceof AccountDisplay) {
                ((AccountDisplay)component).account.close();
            }
            this.tabbedPane.remove(n);
            this.testNoAccountTabs();
        }
    }

    public void closeTab(Component component) {
        if (component == null) {
            return;
        }
        int n = this.tabbedPane.indexOfComponent(component);
        if (n >= 0) {
            this.tabbedPane.remove(n);
            this.testNoAccountTabs();
        }
    }

    public boolean hasTab(Component component) {
        return this.tabbedPane.indexOfComponent(component) >= 0;
    }

    public void closeAll() {
        while (this.tabbedPane.getTabCount() > 1) {
            this.closeTab(1);
        }
        this.parent.closeEditWindow();
    }

    private void testNoAccountTabs() {
        int n = this.tabbedPane.getTabCount();
        if (n < 2) {
            this.parent.closeSearchWindow();
        }
    }
}

