/*
 * Decompiled with CFR 0.152.
 */
import java.util.TreeMap;
import java.util.Vector;

public final class Category
extends EditableList {
    final String[] defaultCatList = new String[]{"Household", "Household:Purchase", "Household:Maintenance", "Household:Rent", "Household:Utilities", "Household:Cable", "Household:Miscellaneous", "Personal", "Personal:Dental", "Personal:Medical", "Personal:Recreation", "Personal:Education", "Personal:Miscellaneous"};
    String fileName = "categoryList.tsv";
    String unCat = "Uncategorized";
    String transfer = "Transfer";

    public Category(PLCash pLCash) {
        super(pLCash);
    }

    private void readDefaults() {
        for (int i = 0; i < this.defaultCatList.length; ++i) {
            this.addItem(this.defaultCatList[i], new CategoryItem(this.defaultCatList[i]));
        }
    }

    public String[] getCategoryList(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        String[] stringArray = this.getDataKeys();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            boolean bl5 = true;
            if (!bl4 && stringArray[i].indexOf(":") != -1) {
                bl5 = false;
            }
            if (bl5) {
                CategoryItem categoryItem = (CategoryItem)this.getDataObject(stringArray[i]);
                boolean bl6 = bl5 = categoryItem.Income && bl || !categoryItem.Income && bl2 || categoryItem.TaxRelated && bl3;
            }
            if (!bl5) continue;
            vector.add(stringArray[i]);
        }
        return vector.toArray(new String[vector.size()]);
    }

    public void displayData() {
        this.displayMap("Categories", this, "");
    }

    public void readTSV(String string) {
        this.readTSV(string, this.fileName, this.dataMap, new CategoryItem(), "", false);
        if (this.dataMap.size() == 0) {
            this.readDefaults();
        }
        if (!this.dataMap.containsKey(this.unCat)) {
            this.addCategory(new CategoryItem(this.unCat));
        }
        if (!this.dataMap.containsKey(this.transfer)) {
            this.addCategory(new CategoryItem(this.transfer));
        }
    }

    public void writeTSV(String string) {
        this.writeTSV(string, this.fileName, this.dataMap, (Object)new CategoryItem(), "");
    }

    public void createFromQIFData(TreeMap treeMap) {
        CategoryItem categoryItem = new CategoryItem();
        categoryItem.Category = this.parent.commonCode.safeTreeGet(treeMap, "N");
        categoryItem.Description = this.parent.commonCode.safeTreeGet(treeMap, "D");
        categoryItem.TaxRelated = treeMap.containsKey("T");
        categoryItem.Income = treeMap.containsKey("I");
        categoryItem.BudgetAmount = this.parent.commonCode.zeroFailParseDouble(this.parent.commonCode.safeTreeGet(treeMap, "B"));
        categoryItem.TaxSchedInfo = this.parent.commonCode.safeTreeGet(treeMap, "R");
        this.addCategory(categoryItem);
    }

    public void addCategory(CategoryItem categoryItem) {
        this.addItem(categoryItem.Category, categoryItem);
    }

    @Override
    public boolean allowEditRecords(int n) {
        return true;
    }

    @Override
    public Object getDataObject(String string) {
        return this.dataMap.get(string);
    }

    @Override
    public Object getDataObject(int n) {
        return new CategoryItem();
    }

    @Override
    public boolean allowCreateDeleteRecords() {
        return true;
    }

    public int validateCategory(String string) {
        if (string.length() == 0) {
            return 0;
        }
        if (this.keyExists(string)) {
            return 1;
        }
        NewCategoryDialog newCategoryDialog = new NewCategoryDialog(this.parent, true);
        newCategoryDialog.display(string);
        if (newCategoryDialog.createdCategory) {
            return 2;
        }
        if (newCategoryDialog.valid) {
            return 1;
        }
        return 0;
    }
}

