/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Collections;
import java.util.Set;
import javax.swing.JComboBox;
import javax.swing.JTextField;

public final class ActiveComboBox
extends JComboBox {
    PLCash parent;
    Set defaultFocusTraversalKeys;
    private boolean found = false;
    private boolean allowUndefinedEntries = true;

    public ActiveComboBox(PLCash pLCash, boolean bl) {
        this.parent = pLCash;
        this.allowUndefinedEntries = bl;
        this.defaultFocusTraversalKeys = this.getFocusTraversalKeys(0);
        this.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent keyEvent) {
                ActiveComboBox.this.testFound(keyEvent);
            }

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                ActiveComboBox.this.processText(keyEvent);
            }
        });
    }

    public boolean isValidItem() {
        JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
        String string = jTextField.getText();
        int n = this.getItemCount();
        for (int i = 0; i < n; ++i) {
            if (!((String)this.getItemAt(i)).equals(string)) continue;
            return true;
        }
        return false;
    }

    public void testFound(KeyEvent keyEvent) {
        if (this.found) {
            keyEvent.consume();
        }
    }

    public void processText(KeyEvent keyEvent) {
        this.found = false;
        this.setFocusTraversalKeys(0, Collections.EMPTY_SET);
        JTextField jTextField = (JTextField)this.getEditor().getEditorComponent();
        int n = jTextField.getCaretPosition();
        String string = jTextField.getText().substring(0, n);
        char c = keyEvent.getKeyChar();
        if (c == '\t' || c == ':') {
            String string2 = (String)this.getSelectedItem();
            if (string2.equals(string)) {
                this.setFocusTraversalKeys(0, this.defaultFocusTraversalKeys);
            } else {
                jTextField.setText(string2);
                jTextField.setCaretPosition(string2.length());
                this.showPopup();
            }
        } else {
            int n2;
            String string3 = (string + c).toLowerCase();
            int n3 = this.getItemCount();
            for (n2 = 0; n2 < n3 && ((String)this.getItemAt(n2)).toLowerCase().indexOf(string3) != 0; ++n2) {
            }
            if (n2 < n3) {
                this.setSelectedIndex(n2);
                this.showPopup();
                int n4 = jTextField.getText().length();
                n = string3.length();
                if (n > n4) {
                    n = n4 - 1;
                }
                jTextField.setCaretPosition(n);
                this.found = true;
                keyEvent.consume();
            } else if (!(c == '\uffff' || Character.isISOControl(c) || Character.isWhitespace(c) || this.allowUndefinedEntries)) {
                keyEvent.consume();
                this.found = true;
                this.parent.beep();
            }
        }
    }
}

