/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Panel;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Vector;

public final class IndexQuelle {
    public static final int ID_NONE = -1;
    public static final int ID_DAX30 = 0;
    public static final int ID_DAX100 = 1;
    public static final int ID_TECDAX = 2;
    public static final int ID_NEMAX50 = 3;
    public static final int ID_MDAX = 4;
    public static final int ID_SDAX = 5;
    public static final int ID_EUROSTOXX50 = 6;
    public static final int ID_STOXX50 = 7;
    public static final int ID_DOWJONES = 8;
    public static final int ID_SP500 = 9;
    public static final int ID_NASDAQ100 = 10;
    public static final int ID_NASDAQ = 11;
    public static final int ID_NIKKEI = 12;
    public static final int ID_NIKKEI225 = 13;
    public static final int COUNT = 14;
    private static final int COLUMNS = 3;
    private static Panel indexPanel = null;
    private static Vector canvasliste = new Vector();
    private static Vector usedindices = null;
    private static long currentThreadID = 0L;
    private static long nextThreadID = currentThreadID + 1L;
    private static Thread leser = null;
    private static final String[] iNames = new String[]{"DAX 30", "DAX 100", "TecDAX", "NEMAX 50", "MDAX", "SDAX", "EuroSTOXX 50", "STOXX 50", "Dow Jones", "S&P 500", "NASDAQ 100", "NASDAQ", "NIKKEI", "NIKKEI 225"};
    public static final String[] iDescr = new String[]{"DAX/DAX 30 Index", "HDAX/DAX 100 Index", "TecDAX Index", "NEMAX 50 Index", "MDAX Index", "SDAX Index", "Dow Jones Euro STOXX 50 Index", "Dow Jones STOXX 50 Index", "Dow Jones Industrials Index", "S&P 500 Index", "NASDAQ 100 Index", "NASDAQ/NMS Composite Index", "NIKKEI/ISE 50 Index", "NIKKEI 225 Index"};
    private static final int[] defaultIndices;

    static {
        int[] nArray = new int[6];
        nArray[1] = 2;
        nArray[2] = 8;
        nArray[3] = 9;
        nArray[4] = 11;
        nArray[5] = 13;
        defaultIndices = nArray;
    }

    public static synchronized void call() {
        if (currentThreadID == nextThreadID) {
            leser.interrupt();
        } else {
            currentThreadID = nextThreadID;
            IndexLeser indexLeser = new IndexLeser(currentThreadID);
            leser = new Thread(indexLeser);
            leser.start();
        }
    }

    public static synchronized void clearThread(long l) {
        if (l == nextThreadID) {
            leser = null;
            ++nextThreadID;
        }
    }

    private static synchronized void addCanvas(IndexCanvas indexCanvas) {
        canvasliste.addElement(indexCanvas);
    }

    private static synchronized void setPanel(Panel panel) {
        indexPanel = panel;
    }

    public static synchronized void checkIndex(int n, long l, long l2, String string) {
        int n2 = 0;
        while (n2 < canvasliste.size()) {
            IndexCanvas indexCanvas = (IndexCanvas)canvasliste.elementAt(n2);
            if (indexCanvas.getIndex() == n) {
                indexCanvas.setValues(l, l2, string);
                indexCanvas.repaint();
                int n3 = IndexQuelle.index2Used(indexCanvas.getIndex());
                if (n3 >= 0) {
                    ((UsedIndex)usedindices.elementAt(n3)).setValues(l, l2, string);
                }
            }
            ++n2;
        }
    }

    public static synchronized void updateFinished() {
        if (indexPanel != null) {
            indexPanel.validate();
            indexPanel.repaint();
        }
        IndexQuelle.saveValues();
    }

    public static boolean autoIndexOn() {
        return AktienMan.properties.getBoolean("Konfig.Index", false);
    }

    public static synchronized void addIndex(int n) {
        if (IndexQuelle.isIndexOn(n)) {
            return;
        }
        usedindices.addElement(new UsedIndex(n));
    }

    public static synchronized void removeIndex(int n) {
        int n2 = IndexQuelle.index2Used(n);
        if (n2 >= 0) {
            usedindices.removeElementAt(n2);
        }
    }

    public static synchronized boolean isIndexOn(int n) {
        return IndexQuelle.index2Used(n) >= 0;
    }

    private static synchronized int index2Used(int n) {
        int n2 = 0;
        while (n2 < usedindices.size()) {
            if (((UsedIndex)usedindices.elementAt(n2)).getIndex() == n) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public static synchronized void addIndices(Panel panel) {
        IndexQuelle.setPanel(panel);
        IndexQuelle.loadValues();
        int n = (usedindices.size() + 3 - 1) / 3;
        int n2 = 0;
        while (n2 < usedindices.size()) {
            int n3;
            UsedIndex usedIndex = (UsedIndex)usedindices.elementAt(n2);
            int n4 = usedIndex.getIndex();
            String[] stringArray = new String[n];
            int n5 = n3 = n2 % 3;
            int n6 = 0;
            while (n6 < n) {
                if (n5 < usedindices.size()) {
                    int n7 = ((UsedIndex)usedindices.elementAt(n5)).getIndex();
                    stringArray[n6] = iNames[n7];
                }
                n5 += 3;
                ++n6;
            }
            IndexCanvas indexCanvas = new IndexCanvas(iNames[n4], n4, stringArray, "99999,99", usedIndex.getPunkte(), usedIndex.getVortag(), usedIndex.getDatum());
            AFrame.constrain(panel, indexCanvas, n3, n2 / 3, 1, 1, 2, 17, 1.0, 0.0, 0, 0, 0, 0);
            IndexQuelle.addCanvas(indexCanvas);
            ++n2;
        }
    }

    public static synchronized void renewIndices() {
        if (indexPanel == null) {
            return;
        }
        indexPanel.setVisible(false);
        indexPanel.removeAll();
        canvasliste = new Vector();
        IndexQuelle.addIndices(indexPanel);
        AktienMan.hauptdialog.addIndexPanelAndPane(true);
        indexPanel.setVisible(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized void loadValues() {
        int n;
        Throwable throwable2;
        block18: {
            block16: {
                if (usedindices != null) {
                    return;
                }
                ObjectInputStream objectInputStream = null;
                try {
                    try {
                        FileInputStream fileInputStream = new FileInputStream(FileUtil.getIndexFile());
                        objectInputStream = new ObjectInputStream(new BufferedInputStream(fileInputStream));
                        usedindices = (Vector)objectInputStream.readObject();
                        int n2 = 0;
                        while (n2 < usedindices.size()) {
                            int n3 = ((UsedIndex)usedindices.elementAt(n2)).getIndex();
                            if (n3 < 0 || n3 >= 14) {
                                usedindices = null;
                                break;
                            }
                            ++n2;
                        }
                    }
                    catch (Exception exception) {
                    }
                    Object var2_6 = null;
                    if (objectInputStream == null) break block16;
                }
                catch (Throwable throwable2) {
                    Object var2_7 = null;
                    if (objectInputStream != null) {
                        try {
                            objectInputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (usedindices != null) throw throwable2;
                    usedindices = new Vector();
                    n = 0;
                    break block18;
                }
                try {}
                catch (Exception exception) {}
                objectInputStream.close();
            }
            if (usedindices != null) return;
            usedindices = new Vector();
            int n4 = 0;
            while (true) {
                if (n4 >= defaultIndices.length) {
                    return;
                }
                IndexQuelle.addIndex(defaultIndices[n4]);
                ++n4;
            }
        }
        while (true) {
            if (n >= defaultIndices.length) {
                throw throwable2;
            }
            IndexQuelle.addIndex(defaultIndices[n]);
            ++n;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void saveValues() {
        if (usedindices == null) {
            return;
        }
        ObjectOutputStream objectOutputStream = null;
        try {
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(FileUtil.getIndexFile());
                objectOutputStream = new ObjectOutputStream(new BufferedOutputStream(fileOutputStream));
                objectOutputStream.writeObject(usedindices);
                objectOutputStream.flush();
            }
            catch (Exception exception) {
            }
            Object var2_2 = null;
            if (objectOutputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            if (objectOutputStream == null) throw throwable;
            try {
                objectOutputStream.close();
                throw throwable;
            }
            catch (Exception exception) {}
            throw throwable;
        }
        try {
            objectOutputStream.close();
            return;
        }
        catch (Exception exception) {}
    }
}

